/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.spec;

import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.LookupTableSource;
import org.apache.flink.table.planner.delegation.PlannerBase;
import org.apache.flink.table.planner.plan.abilities.source.SourceAbilitySpec;
import org.apache.flink.table.planner.plan.nodes.exec.spec.DynamicTableSourceSpec;
import org.apache.flink.table.planner.plan.schema.TableSourceTable;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TemporalTableSourceSpec {
    public static final String FIELD_NAME_LOOK_UP_TABLE_SOURCE = "lookupTableSource";
    public static final String FIELD_NAME_OUTPUT_TYPE = "outputType";
    @JsonProperty(value="lookupTableSource")
    @Nullable
    private DynamicTableSourceSpec tableSourceSpec;
    @JsonProperty(value="outputType")
    @Nullable
    private RelDataType outputType;
    @JsonIgnore
    private RelOptTable temporalTable;

    public TemporalTableSourceSpec(RelOptTable temporalTable, TableConfig tableConfig) {
        this.temporalTable = temporalTable;
        if (temporalTable instanceof TableSourceTable) {
            TableSourceTable tableSourceTable = (TableSourceTable)temporalTable;
            this.outputType = tableSourceTable.getRowType();
            this.tableSourceSpec = new DynamicTableSourceSpec(tableSourceTable.tableIdentifier(), tableSourceTable.catalogTable(), Arrays.asList(tableSourceTable.abilitySpecs()));
            this.tableSourceSpec.setTableSource(tableSourceTable.tableSource());
            this.tableSourceSpec.setReadableConfig((ReadableConfig)tableConfig.getConfiguration());
        }
    }

    @JsonCreator
    public TemporalTableSourceSpec(@JsonProperty(value="lookupTableSource") @Nullable DynamicTableSourceSpec dynamicTableSourceSpec, @JsonProperty(value="outputType") @Nullable RelDataType outputType) {
        this.tableSourceSpec = dynamicTableSourceSpec;
        this.outputType = outputType;
    }

    @JsonIgnore
    public RelOptTable getTemporalTable(PlannerBase planner) {
        if (null != this.temporalTable) {
            return this.temporalTable;
        }
        if (null != this.tableSourceSpec && null != this.outputType) {
            LookupTableSource lookupTableSource = this.tableSourceSpec.getLookupTableSource(planner);
            ObjectIdentifier objectIdentifier = this.tableSourceSpec.getObjectIdentifier();
            ResolvedCatalogTable catalogTable = this.tableSourceSpec.getCatalogTable();
            SourceAbilitySpec[] sourceAbilitySpecs = null;
            if (null != this.tableSourceSpec.getSourceAbilitySpecs()) {
                sourceAbilitySpecs = this.tableSourceSpec.getSourceAbilitySpecs().toArray(new SourceAbilitySpec[0]);
            }
            return new TableSourceTable(null, objectIdentifier, this.outputType, FlinkStatistic.UNKNOWN(), (DynamicTableSource)lookupTableSource, true, catalogTable, new String[0], sourceAbilitySpecs);
        }
        throw new TableException("Can not obtain temporalTable correctly!");
    }

    @JsonIgnore
    @Nullable
    public DynamicTableSourceSpec getTableSourceSpec() {
        return this.tableSourceSpec;
    }

    @JsonIgnore
    @Nullable
    public RelDataType getOutputType() {
        return this.outputType;
    }
}

