/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.plan.nodes.exec.serde;

import java.io.IOException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.planner.plan.nodes.exec.InputProperty;

public class RequiredDistributionJsonDeserializer
extends StdDeserializer<InputProperty.RequiredDistribution> {
    private static final long serialVersionUID = 1L;

    public RequiredDistributionJsonDeserializer() {
        super(InputProperty.RequiredDistribution.class);
    }

    public InputProperty.RequiredDistribution deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException, JsonProcessingException {
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        InputProperty.DistributionType type = InputProperty.DistributionType.valueOf(jsonNode.get("type").asText().toUpperCase());
        switch (type) {
            case ANY: {
                return InputProperty.ANY_DISTRIBUTION;
            }
            case SINGLETON: {
                return InputProperty.SINGLETON_DISTRIBUTION;
            }
            case BROADCAST: {
                return InputProperty.BROADCAST_DISTRIBUTION;
            }
            case UNKNOWN: {
                return InputProperty.UNKNOWN_DISTRIBUTION;
            }
            case HASH: {
                JsonNode keysNode = jsonNode.get("keys");
                if (keysNode == null) {
                    throw new TableException("Hash distribution requires non-empty hash keys.");
                }
                int[] keys = new int[keysNode.size()];
                for (int i = 0; i < keysNode.size(); ++i) {
                    keys[i] = keysNode.get(i).asInt();
                }
                return InputProperty.hashDistribution(keys);
            }
        }
        throw new TableException("Unsupported distribution type: " + (Object)((Object)type));
    }
}

