/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.delegation;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.util.StringUtils;

@Internal
public abstract class ExecutorBase
implements Executor {
    private static final String DEFAULT_JOB_NAME = "Flink Exec Table Job";
    private final StreamExecutionEnvironment executionEnvironment;
    protected TableConfig tableConfig;

    public ExecutorBase(StreamExecutionEnvironment executionEnvironment) {
        this.executionEnvironment = executionEnvironment;
    }

    public StreamExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public JobExecutionResult execute(Pipeline pipeline) throws Exception {
        return this.executionEnvironment.execute((StreamGraph)pipeline);
    }

    public JobClient executeAsync(Pipeline pipeline) throws Exception {
        return this.executionEnvironment.executeAsync((StreamGraph)pipeline);
    }

    protected String getNonEmptyJobName(String jobName) {
        if (StringUtils.isNullOrWhitespaceOnly((String)jobName)) {
            return DEFAULT_JOB_NAME;
        }
        return jobName;
    }
}

