/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.catalog;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.TemporalTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.Catalog;
import org.apache.flink.table.catalog.CatalogManager;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ConnectorCatalogTable;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedCatalogBaseTable;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.factories.TableFactoryUtil;
import org.apache.flink.table.factories.TableSourceFactory;
import org.apache.flink.table.factories.TableSourceFactoryContextImpl;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.plan.stats.FlinkStatistic;
import org.apache.flink.table.planner.sources.TableSourceUtil;
import org.apache.flink.table.runtime.types.PlannerTypeUtils;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.sources.TableSourceValidation;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import scala.Option;

public class CatalogSchemaTable
extends AbstractTable
implements TemporalTable {
    private final ObjectIdentifier tableIdentifier;
    private final CatalogManager.TableLookupResult lookupResult;
    private final FlinkStatistic statistic;
    private final boolean isStreamingMode;

    public CatalogSchemaTable(ObjectIdentifier tableIdentifier, CatalogManager.TableLookupResult lookupResult, FlinkStatistic statistic2, boolean isStreaming) {
        this.tableIdentifier = tableIdentifier;
        this.lookupResult = lookupResult;
        this.statistic = statistic2;
        this.isStreamingMode = isStreaming;
    }

    public Optional<Catalog> getCatalog() {
        return this.lookupResult.getCatalog();
    }

    public ObjectIdentifier getTableIdentifier() {
        return this.tableIdentifier;
    }

    public ResolvedCatalogBaseTable<?> getResolvedCatalogTable() {
        return this.lookupResult.getResolvedTable();
    }

    public boolean isTemporary() {
        return this.lookupResult.isTemporary();
    }

    public boolean isStreamingMode() {
        return this.isStreamingMode;
    }

    @Override
    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        FlinkTypeFactory flinkTypeFactory = (FlinkTypeFactory)typeFactory;
        ResolvedSchema schema = this.lookupResult.getResolvedSchema();
        Optional<TableSource<?>> sourceOpt = this.findAndCreateTableSource();
        if (this.isStreamingMode && schema.getColumns().stream().allMatch(Column::isPhysical) && schema.getWatermarkSpecs().isEmpty() && sourceOpt.isPresent()) {
            TableSchema tableSchema = TableSchema.fromResolvedSchema((ResolvedSchema)schema);
            TableSource<?> source = sourceOpt.get();
            if (TableSourceValidation.hasProctimeAttribute(source) || TableSourceValidation.hasRowtimeAttribute(source)) {
                tableSchema = ConnectorCatalogTable.calculateSourceSchema(source, (boolean)false);
            }
            return TableSourceUtil.getSourceRowType(flinkTypeFactory, tableSchema, Option.empty(), true);
        }
        List fieldNames = schema.getColumnNames();
        List<LogicalType> fieldTypes = schema.getColumnDataTypes().stream().map(DataType::getLogicalType).map(PlannerTypeUtils::removeLegacyTypes).collect(Collectors.toList());
        return flinkTypeFactory.buildRelNodeRowType(fieldNames, fieldTypes);
    }

    @Override
    public FlinkStatistic getStatistic() {
        return this.statistic;
    }

    @Override
    public String getSysStartFieldName() {
        return "sys_start";
    }

    @Override
    public String getSysEndFieldName() {
        return "sys_end";
    }

    private Optional<TableSource<?>> findAndCreateTableSource() {
        Optional<TableSource<?>> tableSource;
        block4: {
            tableSource = Optional.empty();
            try {
                if (!(this.lookupResult.getTable() instanceof CatalogTable)) break block4;
                Configuration config = new Configuration();
                TableSourceFactoryContextImpl context = new TableSourceFactoryContextImpl(this.tableIdentifier, (CatalogTable)this.lookupResult.getTable(), (ReadableConfig)config, this.lookupResult.isTemporary());
                TableSource source = TableFactoryUtil.findAndCreateTableSource((TableSourceFactory.Context)context);
                if (source instanceof StreamTableSource) {
                    if (!this.isStreamingMode && !((StreamTableSource)source).isBounded()) {
                        throw new ValidationException("Cannot query on an unbounded source in batch mode, but " + this.tableIdentifier.asSummaryString() + " is unbounded.");
                    }
                    tableSource = Optional.of(source);
                    break block4;
                }
                throw new ValidationException("Catalog tables only support StreamTableSource and InputFormatTableSource.");
            }
            catch (Exception e) {
                tableSource = Optional.empty();
            }
        }
        return tableSource;
    }
}

