/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Optional;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.service.AuthInterceptor;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.common.auth.DefaultAuthentication;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public final class ClientUtils {
    private static final Logger log = LoggerFactory.getLogger(ClientUtils.class);
    private static final String REQUEST_FAILED_MSG = "Request to Inlong %s failed: %s";
    private static ClientFactory clientFactory;

    public static ClientFactory getClientFactory(ClientConfiguration configuration) {
        return Optional.ofNullable(clientFactory).orElse(new ClientFactory(configuration));
    }

    public static Retrofit createRetrofit(ClientConfiguration configuration) {
        String host = configuration.getBindHost();
        int port = configuration.getBindPort();
        Authentication authentication = configuration.getAuthentication();
        Preconditions.expectNotNull((Object)authentication, (String)"inlong should be authenticated");
        Preconditions.expectTrue((boolean)(authentication instanceof DefaultAuthentication), (String)"inlong only support default authentication");
        DefaultAuthentication defaultAuthentication = (DefaultAuthentication)authentication;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor(defaultAuthentication.getUsername(), defaultAuthentication.getPassword(), configuration::getTenant)).connectTimeout((long)configuration.getConnectTimeout(), configuration.getTimeUnit()).readTimeout((long)configuration.getReadTimeout(), configuration.getTimeUnit()).writeTimeout((long)configuration.getWriteTimeout(), configuration.getTimeUnit()).retryOnConnectionFailure(true).build();
        return new Retrofit.Builder().baseUrl("http://" + host + ":" + port + "/inlong/manager/api/").addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)JsonUtils.OBJECT_MAPPER)).client(okHttpClient).build();
    }

    public static <T> T executeHttpCall(Call<T> call) {
        Request request = call.request();
        String url = request.url().encodedPath();
        try {
            Response response = call.execute();
            Preconditions.expectTrue((boolean)response.isSuccessful(), (String)String.format(REQUEST_FAILED_MSG, url, response.message()));
            return (T)response.body();
        }
        catch (IOException e) {
            log.error(String.format(REQUEST_FAILED_MSG, url, e.getMessage()), (Throwable)e);
            throw new RuntimeException(String.format(REQUEST_FAILED_MSG, url, e.getMessage()), e);
        }
    }

    public static void assertRespSuccess(org.apache.inlong.manager.pojo.common.Response<?> response) {
        Preconditions.expectTrue((boolean)response.isSuccess(), (String)String.format(REQUEST_FAILED_MSG, response.getErrMsg(), null));
    }

    private ClientUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

