/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import java.util.Map;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.WorkflowApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.workflow.ProcessDetailResponse;
import org.apache.inlong.manager.pojo.workflow.ProcessRequest;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskRequest;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowOperationRequest;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkflowClient {
    private static final Logger log = LoggerFactory.getLogger(WorkflowClient.class);
    private final WorkflowApi workflowApi;

    public WorkflowClient(ClientConfiguration configuration) {
        this.workflowApi = (WorkflowApi)ClientUtils.createRetrofit(configuration).create(WorkflowApi.class);
    }

    public WorkflowResult startInlongGroup(int taskId, ApplyGroupProcessForm groupProcessForm) {
        ObjectNode workflowTaskOperation = JsonUtils.OBJECT_MAPPER.createObjectNode();
        workflowTaskOperation.putPOJO("transferTo", (Object)Lists.newArrayList());
        workflowTaskOperation.put("remark", "approved by system");
        ObjectNode groupApproveForm = JsonUtils.OBJECT_MAPPER.createObjectNode();
        groupApproveForm.putPOJO("groupApproveInfo", (Object)groupProcessForm.getGroupInfo());
        groupApproveForm.putPOJO("streamApproveInfoList", (Object)groupProcessForm.getStreamInfoList());
        groupApproveForm.put("formName", "InlongGroupApproveForm");
        workflowTaskOperation.set("form", (JsonNode)groupApproveForm);
        log.info("startInlongGroup workflowTaskOperation: {}", (Object)groupApproveForm);
        Map requestMap = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)workflowTaskOperation, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.startInlongGroup(taskId, requestMap));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public WorkflowResult start(WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)request.getName(), (String)"process name cannot be null");
        Preconditions.expectNotNull((Object)request.getForm(), (String)"form cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.start(request));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public WorkflowResult cancel(Integer processId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.cancel(processId, request));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public WorkflowResult continueProcess(Integer processId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.continueProcess(processId, request));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public WorkflowResult reject(Integer taskId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)taskId, (String)"task id cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.reject(taskId, request));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public WorkflowResult complete(Integer taskId, WorkflowOperationRequest request) {
        Preconditions.expectNotNull((Object)taskId, (String)"task id cannot be null");
        Response<WorkflowResult> response = ClientUtils.executeHttpCall(this.workflowApi.complete(taskId, request));
        ClientUtils.assertRespSuccess(response);
        return (WorkflowResult)response.getData();
    }

    public ProcessDetailResponse detail(Integer processId, Integer taskId) {
        Preconditions.expectNotNull((Object)processId, (String)"process id cannot be null");
        Response<ProcessDetailResponse> response = ClientUtils.executeHttpCall(this.workflowApi.detail(processId, taskId));
        ClientUtils.assertRespSuccess(response);
        return (ProcessDetailResponse)response.getData();
    }

    public PageResult<ProcessResponse> listProcess(ProcessRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"process request cannot be null");
        Map requestMap = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Response<PageResult<ProcessResponse>> response = ClientUtils.executeHttpCall(this.workflowApi.listProcess(requestMap));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }

    public PageResult<TaskResponse> listTask(TaskRequest request) {
        Preconditions.expectNotNull((Object)request, (String)"task request cannot be null");
        Map requestMap = (Map)JsonUtils.OBJECT_MAPPER.convertValue((Object)request, (TypeReference)new TypeReference<Map<String, Object>>(){});
        Response<PageResult<TaskResponse>> response = ClientUtils.executeHttpCall(this.workflowApi.listTask(requestMap));
        ClientUtils.assertRespSuccess(response);
        return (PageResult)response.getData();
    }
}

