/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.StreamTransformApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.transform.TransformRequest;
import org.apache.inlong.manager.pojo.transform.TransformResponse;

public class StreamTransformClient {
    private final StreamTransformApi streamTransformApi;

    public StreamTransformClient(ClientConfiguration configuration) {
        this.streamTransformApi = (StreamTransformApi)ClientUtils.createRetrofit(configuration).create(StreamTransformApi.class);
    }

    public Integer createTransform(TransformRequest transformRequest) {
        Response<Integer> response = ClientUtils.executeHttpCall(this.streamTransformApi.createTransform(transformRequest));
        ClientUtils.assertRespSuccess(response);
        return (Integer)response.getData();
    }

    public List<TransformResponse> listTransform(String groupId, String streamId) {
        Response<List<TransformResponse>> response = ClientUtils.executeHttpCall(this.streamTransformApi.listTransform(groupId, streamId));
        ClientUtils.assertRespSuccess(response);
        return (List)response.getData();
    }

    public Pair<Boolean, String> updateTransform(TransformRequest transformRequest) {
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamTransformApi.updateTransform(transformRequest));
        if (response.getData() != null) {
            return Pair.of((Object)response.getData(), (Object)response.getErrMsg());
        }
        return Pair.of((Object)false, (Object)response.getErrMsg());
    }

    public boolean deleteTransform(TransformRequest transformRequest) {
        Preconditions.expectNotBlank((String)transformRequest.getInlongGroupId(), (ErrorCodeEnum)ErrorCodeEnum.GROUP_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)transformRequest.getInlongStreamId(), (ErrorCodeEnum)ErrorCodeEnum.STREAM_ID_IS_EMPTY);
        Preconditions.expectNotBlank((String)transformRequest.getTransformName(), (ErrorCodeEnum)ErrorCodeEnum.TRANSFORM_NAME_IS_NULL);
        Response<Boolean> response = ClientUtils.executeHttpCall(this.streamTransformApi.deleteTransform(transformRequest.getInlongGroupId(), transformRequest.getInlongStreamId(), transformRequest.getTransformName()));
        ClientUtils.assertRespSuccess(response);
        return (Boolean)response.getData();
    }
}

