/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.inner.client;

import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.service.InlongTenantApi;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.pojo.common.PageResult;
import org.apache.inlong.manager.pojo.common.Response;
import org.apache.inlong.manager.pojo.tenant.InlongTenantInfo;
import org.apache.inlong.manager.pojo.tenant.InlongTenantPageRequest;
import org.apache.inlong.manager.pojo.tenant.InlongTenantRequest;

public class InlongTenantClient {
    private final InlongTenantApi inlongTenantApi;

    public InlongTenantClient(ClientConfiguration configuration) {
        this.inlongTenantApi = (InlongTenantApi)ClientUtils.createRetrofit(configuration).create(InlongTenantApi.class);
    }

    public InlongTenantInfo getTenantByName(String name) {
        Response<InlongTenantInfo> inlongTenantInfoResponse = ClientUtils.executeHttpCall(this.inlongTenantApi.get(name));
        ClientUtils.assertRespSuccess(inlongTenantInfoResponse);
        return (InlongTenantInfo)inlongTenantInfoResponse.getData();
    }

    public Integer save(InlongTenantRequest inlongTenantRequest) {
        Response<Integer> saveInlongTenantResult = ClientUtils.executeHttpCall(this.inlongTenantApi.createInLongTenant(inlongTenantRequest));
        ClientUtils.assertRespSuccess(saveInlongTenantResult);
        return (Integer)saveInlongTenantResult.getData();
    }

    public PageResult<InlongTenantInfo> listByCondition(InlongTenantPageRequest inlongTenantPageRequest) {
        Response<PageResult<InlongTenantInfo>> pageResultResponse = ClientUtils.executeHttpCall(this.inlongTenantApi.listByCondition(inlongTenantPageRequest));
        ClientUtils.assertRespSuccess(pageResultResponse);
        return (PageResult)pageResultResponse.getData();
    }

    public Boolean update(InlongTenantRequest request) {
        Response<Boolean> updateResult = ClientUtils.executeHttpCall(this.inlongTenantApi.update(request));
        ClientUtils.assertRespSuccess(updateResult);
        return (Boolean)updateResult.getData();
    }
}

