/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.client.api.impl;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.inlong.manager.client.api.ClientConfiguration;
import org.apache.inlong.manager.client.api.InlongGroup;
import org.apache.inlong.manager.client.api.InlongGroupContext;
import org.apache.inlong.manager.client.api.InlongStream;
import org.apache.inlong.manager.client.api.InlongStreamBuilder;
import org.apache.inlong.manager.client.api.impl.DefaultInlongStreamBuilder;
import org.apache.inlong.manager.client.api.impl.InlongStreamImpl;
import org.apache.inlong.manager.client.api.inner.InnerGroupContext;
import org.apache.inlong.manager.client.api.inner.client.ClientFactory;
import org.apache.inlong.manager.client.api.inner.client.InlongGroupClient;
import org.apache.inlong.manager.client.api.inner.client.InlongStreamClient;
import org.apache.inlong.manager.client.api.inner.client.WorkflowClient;
import org.apache.inlong.manager.client.api.util.ClientUtils;
import org.apache.inlong.manager.client.api.util.InlongGroupTransfer;
import org.apache.inlong.manager.common.enums.GroupStatus;
import org.apache.inlong.manager.common.enums.ProcessStatus;
import org.apache.inlong.manager.common.enums.SimpleGroupStatus;
import org.apache.inlong.manager.common.enums.SortStatus;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.group.InlongGroupCountResponse;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupResetRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;
import org.apache.inlong.manager.pojo.sort.SortStatusInfo;
import org.apache.inlong.manager.pojo.sort.SortStatusRequest;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.pojo.workflow.ProcessResponse;
import org.apache.inlong.manager.pojo.workflow.TaskResponse;
import org.apache.inlong.manager.pojo.workflow.WorkflowResult;
import org.apache.inlong.manager.pojo.workflow.form.process.ApplyGroupProcessForm;
import org.springframework.boot.configurationprocessor.json.JSONObject;

public class InlongGroupImpl
implements InlongGroup {
    public static final String GROUP_FIELD = "groupInfo";
    public static final String MQ_FIELD_OLD = "middlewareType";
    public static final String MQ_FIELD = "mqType";
    private final InnerGroupContext groupContext;
    private final InlongGroupClient groupClient;
    private final WorkflowClient workflowClient;
    private final InlongStreamClient streamClient;
    private final ClientConfiguration configuration;
    private InlongGroupInfo groupInfo;

    public InlongGroupImpl(InlongGroupInfo groupInfo, ClientConfiguration configuration) {
        this.groupInfo = groupInfo;
        this.groupContext = new InnerGroupContext();
        this.configuration = configuration;
        ClientFactory clientFactory = ClientUtils.getClientFactory(configuration);
        this.streamClient = clientFactory.getStreamClient();
        this.groupClient = clientFactory.getGroupClient();
        this.workflowClient = clientFactory.getWorkflowClient();
        String groupId = groupInfo.getInlongGroupId();
        InlongGroupInfo existGroupInfo = this.groupClient.getGroupInfo(groupId);
        if (existGroupInfo == null) {
            InlongGroupTransfer.createGroupInfo(groupInfo, groupInfo.getSortConf());
            groupId = this.groupClient.createGroup(groupInfo.genRequest());
            groupInfo.setInlongGroupId(groupId);
        }
        InlongGroupInfo newGroupInfo = this.groupClient.getGroupInfo(groupId);
        groupInfo.setVersion(newGroupInfo.getVersion());
        this.groupContext.setGroupInfo(groupInfo);
    }

    @Override
    public InlongStreamBuilder createStream(InlongStreamInfo streamInfo) {
        return new DefaultInlongStreamBuilder(streamInfo, this.groupContext, this.configuration);
    }

    @Override
    public InlongGroupContext context() throws Exception {
        return this.generateSnapshot();
    }

    @Override
    public InlongGroupContext context(String credentials) throws Exception {
        return this.generateSnapshot(credentials);
    }

    @Override
    public InlongGroupContext init() throws Exception {
        JSONObject groupInfoJson;
        InlongGroupInfo groupInfo = this.groupContext.getGroupInfo();
        WorkflowResult initWorkflowResult = this.groupClient.initInlongGroup(groupInfo.genRequest());
        List taskViews = initWorkflowResult.getNewTasks();
        Preconditions.expectNotEmpty((Collection)taskViews, (String)"init inlong group info failed");
        TaskResponse taskView = (TaskResponse)taskViews.get(0);
        int taskId = taskView.getId();
        ProcessResponse processView = initWorkflowResult.getProcessInfo();
        Preconditions.expectTrue((ProcessStatus.PROCESSING == processView.getStatus() ? 1 : 0) != 0, (String)String.format("process status %s is not corrected, should be PROCESSING", processView.getStatus()));
        JSONObject formDataJson = (JSONObject)JsonUtils.parseObject((String)JsonUtils.toJsonString((Object)JsonUtils.toJsonString((Object)processView.getFormData())), JSONObject.class);
        assert (formDataJson != null);
        if (formDataJson.has(GROUP_FIELD) && (groupInfoJson = formDataJson.getJSONObject(GROUP_FIELD)).has(MQ_FIELD_OLD) && !groupInfoJson.has(MQ_FIELD)) {
            groupInfoJson.put(MQ_FIELD, groupInfoJson.get(MQ_FIELD_OLD));
        }
        String formDataNew = formDataJson.toString();
        ApplyGroupProcessForm groupProcessForm = (ApplyGroupProcessForm)JsonUtils.parseObject((String)formDataNew, ApplyGroupProcessForm.class);
        Preconditions.expectNotNull((Object)groupProcessForm, (String)"ApplyGroupProcessForm cannot be null");
        this.groupContext.setInitMsg(groupProcessForm);
        assert (groupProcessForm != null);
        WorkflowResult startWorkflowResult = this.workflowClient.startInlongGroup(taskId, groupProcessForm);
        processView = startWorkflowResult.getProcessInfo();
        Preconditions.expectTrue((ProcessStatus.COMPLETED == processView.getStatus() ? 1 : 0) != 0, (String)String.format("inlong group status %s is incorrect, should be COMPLETED", processView.getStatus()));
        return this.generateSnapshot();
    }

    @Override
    public void update(InlongGroupInfo originGroupInfo, BaseSortConf sortConf) throws Exception {
        if (originGroupInfo == null) {
            originGroupInfo = this.groupInfo;
        }
        Preconditions.expectTrue((boolean)Objects.equal((Object)originGroupInfo.getInlongGroupId(), (Object)this.groupInfo.getInlongGroupId()), (String)"groupId must be same");
        InlongGroupInfo groupInfo = InlongGroupTransfer.createGroupInfo(originGroupInfo, sortConf);
        this.updateOpt(groupInfo);
        this.groupInfo = this.groupContext.getGroupInfo();
    }

    @Override
    public void update(BaseSortConf sortConf) throws Exception {
        Preconditions.expectNotNull((Object)sortConf, (String)"sort conf cannot be null");
        this.updateOpt(InlongGroupTransfer.createGroupInfo(this.groupInfo, sortConf));
    }

    private void updateOpt(InlongGroupInfo groupInfo) {
        InlongGroupInfo existGroupInfo = this.groupClient.getGroupInfo(groupInfo.getInlongGroupId());
        Preconditions.expectNotNull((Object)existGroupInfo, (String)"inlong group does not exist, cannot be updated");
        SimpleGroupStatus status = SimpleGroupStatus.parseStatusByCode((int)existGroupInfo.getStatus());
        Preconditions.expectTrue((status != SimpleGroupStatus.INITIALIZING ? 1 : 0) != 0, (String)"inlong group is in init status, cannot be updated");
        groupInfo.setVersion(existGroupInfo.getVersion());
        Pair<String, String> idAndErr = this.groupClient.updateGroup(groupInfo.genRequest());
        String errMsg = (String)idAndErr.getValue();
        Preconditions.expectNull((Object)errMsg, (String)errMsg);
        this.groupContext.setGroupInfo(groupInfo);
    }

    @Override
    public InlongGroupContext reInitOnUpdate(InlongGroupInfo originGroupInfo, BaseSortConf sortConf) throws Exception {
        this.update(originGroupInfo, sortConf);
        String groupId = this.groupContext.getGroupInfo().getInlongGroupId();
        InlongGroupInfo newGroupInfo = this.groupClient.getGroupInfo(groupId);
        if (newGroupInfo == null) {
            throw new RuntimeException(String.format("Group not found by inlongGroupId=%s", groupId));
        }
        this.groupContext.setGroupInfo(newGroupInfo);
        return this.init();
    }

    @Override
    public InlongGroupContext suspend() {
        return this.suspend(false);
    }

    @Override
    public InlongGroupContext suspend(boolean async) {
        InlongGroupInfo groupInfo = this.groupContext.getGroupInfo();
        this.updateOpt(groupInfo);
        this.groupClient.operateInlongGroup(groupInfo.getInlongGroupId(), SimpleGroupStatus.STOPPED, async);
        return this.generateSnapshot();
    }

    @Override
    public InlongGroupContext restart() {
        return this.restart(false);
    }

    @Override
    public InlongGroupContext restart(boolean async) {
        InlongGroupInfo groupInfo = this.groupContext.getGroupInfo();
        this.updateOpt(groupInfo);
        this.groupClient.operateInlongGroup(groupInfo.getInlongGroupId(), SimpleGroupStatus.STARTED, async);
        return this.generateSnapshot();
    }

    @Override
    public InlongGroupContext delete() throws Exception {
        return this.delete(false);
    }

    @Override
    public InlongGroupContext delete(boolean async) throws Exception {
        InlongGroupInfo groupInfo = this.groupClient.getGroupInfo(this.groupContext.getGroupId());
        GroupStatus status = GroupStatus.forCode((int)groupInfo.getStatus());
        if (status == GroupStatus.FINISH) {
            this.groupClient.deleteInlongGroup(groupInfo.getInlongGroupId());
            return this.generateSnapshot();
        }
        boolean isDeleted = this.groupClient.deleteInlongGroup(groupInfo.getInlongGroupId(), async);
        if (isDeleted) {
            groupInfo.setStatus(GroupStatus.DELETED.getCode());
        }
        return this.generateSnapshot();
    }

    @Override
    public List<InlongStream> listStreams() {
        String inlongGroupId = this.groupContext.getGroupId();
        return this.fetchInlongStreams(inlongGroupId);
    }

    @Override
    public InlongGroupContext reset(int rerun, int resetFinalStatus) {
        InlongGroupInfo groupInfo = this.groupContext.getGroupInfo();
        InlongGroupResetRequest request = new InlongGroupResetRequest(groupInfo.getInlongGroupId(), Integer.valueOf(rerun), Integer.valueOf(resetFinalStatus));
        this.groupClient.resetGroup(request);
        return this.generateSnapshot();
    }

    @Override
    public InlongGroupCountResponse countGroupByUser() {
        return this.groupClient.countGroupByUser();
    }

    @Override
    public InlongGroupTopicInfo getTopic(String id) {
        return this.groupClient.getTopic(id);
    }

    private InlongGroupContext generateSnapshot() {
        InlongGroupInfo groupInfo = this.groupClient.getGroupInfo(this.groupContext.getGroupId());
        if (groupInfo == null) {
            groupInfo = this.groupContext.getGroupInfo();
            groupInfo.setStatus(GroupStatus.DELETED.getCode());
            return new InlongGroupContext(this.groupContext);
        }
        this.groupContext.setGroupInfo(groupInfo);
        String inlongGroupId = groupInfo.getInlongGroupId();
        List<InlongStream> dataStreams = this.fetchInlongStreams(inlongGroupId);
        if (CollectionUtils.isNotEmpty(dataStreams)) {
            dataStreams.forEach(this.groupContext::setStream);
        }
        return new InlongGroupContext(this.groupContext);
    }

    private InlongGroupContext generateSnapshot(String credentials) {
        InlongGroupContext groupContext = this.generateSnapshot();
        InlongGroupInfo groupInfo = groupContext.getGroupInfo();
        SortStatus sortStatus = SortStatus.NOT_EXISTS;
        if (groupInfo.getExtList().stream().anyMatch(ext -> "sort.job.id".equals(ext.getKeyName()) && StringUtils.isNotEmpty((CharSequence)ext.getKeyValue()))) {
            Optional<SortStatusInfo> optional;
            SortStatusRequest request = new SortStatusRequest();
            String groupId = groupInfo.getInlongGroupId();
            request.setInlongGroupIds(Collections.singletonList(groupId));
            request.setCredentials(credentials);
            List<SortStatusInfo> statusInfos = this.groupClient.listSortStatus(request);
            if (CollectionUtils.isNotEmpty(statusInfos) && (optional = statusInfos.stream().filter(statusInfo -> groupId.equals(statusInfo.getInlongGroupId())).findFirst()).isPresent()) {
                sortStatus = optional.get().getSortStatus();
            }
        }
        groupContext.updateSortStatus(sortStatus);
        return groupContext;
    }

    private List<InlongStream> fetchInlongStreams(String groupId) {
        List<InlongStreamInfo> streamInfos = this.streamClient.listStreamInfo(groupId);
        if (CollectionUtils.isEmpty(streamInfos)) {
            return null;
        }
        return streamInfos.stream().map(streamInfo -> new InlongStreamImpl((InlongStreamInfo)streamInfo, this.configuration)).collect(Collectors.toList());
    }
}

