/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.node.AbstractConfigurationProvider;

public abstract class AbstractZooKeeperConfigurationProvider
extends AbstractConfigurationProvider {
    static final String DEFAULT_ZK_BASE_PATH = "/flume";
    protected final String basePath;
    protected final String zkConnString;

    protected AbstractZooKeeperConfigurationProvider(String agentName, String zkConnString, String basePath) {
        super(agentName);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)zkConnString) ? 1 : 0) != 0, (String)"Invalid Zookeeper Connection String %s", (Object[])new Object[]{zkConnString});
        this.zkConnString = zkConnString;
        this.basePath = basePath == null || basePath.isEmpty() ? DEFAULT_ZK_BASE_PATH : basePath;
    }

    protected CuratorFramework createClient() {
        return CuratorFrameworkFactory.newClient((String)this.zkConnString, (RetryPolicy)new ExponentialBackoffRetry(1000, 1));
    }

    protected FlumeConfiguration configFromBytes(byte[] configData) throws IOException {
        Map<Object, Object> configMap;
        if (configData == null || configData.length == 0) {
            configMap = Collections.emptyMap();
        } else {
            String fileContent = new String(configData, Charsets.UTF_8);
            Properties properties = new Properties();
            properties.load(new StringReader(fileContent));
            configMap = this.toMap(properties);
        }
        return new FlumeConfiguration(configMap);
    }
}

