/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.changelog.StateChange;
import org.apache.flink.runtime.state.changelog.StateChangelogHandle;
import org.apache.flink.util.CloseableIterator;

class InMemoryStateChangelogHandle
implements StateChangelogHandle<Void> {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, List<byte[]>> changes;

    public InMemoryStateChangelogHandle(Map<Integer, List<byte[]>> changes) {
        this.changes = changes;
    }

    @Override
    public void discardState() {
    }

    @Override
    public long getStateSize() {
        return 0L;
    }

    @Override
    public CloseableIterator<StateChange> getChanges(Void unused) {
        return CloseableIterator.fromList(this.changes.entrySet().stream().flatMap(this::mapEntryToChangeStream).collect(Collectors.toList()), change -> {});
    }

    private Stream<StateChange> mapEntryToChangeStream(Map.Entry<Integer, List<byte[]>> entry) {
        int keyGroup = entry.getKey();
        return entry.getValue().stream().map(bytes -> new StateChange(keyGroup, (byte[])bytes));
    }

    @Override
    public KeyGroupRange getKeyGroupRange() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nullable
    public KeyedStateHandle getIntersection(KeyGroupRange keyGroupRange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerSharedStates(SharedStateRegistry stateRegistry) {
        throw new UnsupportedOperationException();
    }
}

