/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.util.function.ThrowingRunnable;

public class ComponentClosingUtils {
    private ComponentClosingUtils() {
    }

    public static CompletableFuture<Void> closeAsyncWithTimeout(String componentName, Runnable closingSequence, Duration closeTimeout) {
        return ComponentClosingUtils.closeAsyncWithTimeout(componentName, (ThrowingRunnable<Exception>)((ThrowingRunnable)closingSequence::run), closeTimeout);
    }

    public static CompletableFuture<Void> closeAsyncWithTimeout(String componentName, ThrowingRunnable<Exception> closingSequence, Duration closeTimeout) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Thread t = new Thread(() -> {
            try {
                closingSequence.run();
                future.complete(null);
            }
            catch (Throwable error) {
                future.completeExceptionally(error);
            }
        });
        t.start();
        future.exceptionally(error -> {
            if (error instanceof TimeoutException && t.isAlive()) {
                ComponentClosingUtils.abortThread(t);
            }
            return null;
        });
        FutureUtils.orTimeout(future, closeTimeout.toMillis(), TimeUnit.MILLISECONDS, String.format("Failed to close the %s before timeout of %d ms", componentName, closeTimeout.toMillis()));
        return future;
    }

    static void abortThread(Thread t) {
        t.interrupt();
    }
}

