/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.task;

import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.dao.mapper.InlongGroupEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongGroupExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamExtEntityMapper;
import org.apache.inlong.manager.dao.mapper.InlongStreamFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamTransformEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamTransformFieldEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowEventLogEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowProcessEntityMapper;
import org.apache.inlong.manager.dao.mapper.WorkflowTaskEntityMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DataCleansingTask
extends TimerTask
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(DataCleansingTask.class);
    private static final int INITIAL_DELAY = 60;
    @Value(value="${data.cleansing.enabled:false}")
    private Boolean enabled;
    @Value(value="${data.cleansing.interval.seconds:1800}")
    private Integer interval;
    @Value(value="${data.cleansing.before.days:10}")
    private Integer before;
    @Value(value="${data.cleansing.batchSize:100}")
    private Integer batchSize;
    @Autowired
    private InlongGroupEntityMapper groupMapper;
    @Autowired
    private InlongGroupExtEntityMapper groupExtMapper;
    @Autowired
    private InlongStreamEntityMapper streamMapper;
    @Autowired
    private InlongStreamExtEntityMapper streamExtMapper;
    @Autowired
    private InlongStreamFieldEntityMapper streamFieldMapper;
    @Autowired
    private StreamSinkEntityMapper streamSinkMapper;
    @Autowired
    private StreamSinkFieldEntityMapper streamSinkFieldMapper;
    @Autowired
    private StreamSourceEntityMapper streamSourceMapper;
    @Autowired
    private StreamSourceFieldEntityMapper streamSourceFieldMapper;
    @Autowired
    private StreamTransformEntityMapper streamTransformMapper;
    @Autowired
    private StreamTransformFieldEntityMapper streamTransformFieldMapper;
    @Autowired
    private WorkflowProcessEntityMapper workflowProcessMapper;
    @Autowired
    private WorkflowTaskEntityMapper workflowTaskMapper;
    @Autowired
    private WorkflowEventLogEntityMapper workflowEventLogMapper;

    public void afterPropertiesSet() {
        if (this.enabled.booleanValue()) {
            log.info("start data cleansing timer task");
            ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
            executor.scheduleWithFixedDelay(this, 60L, this.interval.intValue(), TimeUnit.SECONDS);
        }
    }

    @Override
    public void run() {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(5, -this.before.intValue());
            Date daysBefore = calendar.getTime();
            List groupIds = this.groupMapper.selectDeletedGroupIds(daysBefore, this.batchSize);
            if (CollectionUtils.isEmpty((Collection)groupIds)) {
                return;
            }
            log.info("begin to delete data before {}, group ids {}", (Object)daysBefore, (Object)groupIds);
            this.groupMapper.deleteByInlongGroupIds(groupIds);
            this.groupExtMapper.deleteByInlongGroupIds(groupIds);
            this.streamMapper.deleteByInlongGroupIds(groupIds);
            this.streamExtMapper.deleteByInlongGroupIds(groupIds);
            this.streamFieldMapper.deleteByInlongGroupIds(groupIds);
            this.streamSinkMapper.deleteByInlongGroupIds(groupIds);
            this.streamSinkFieldMapper.deleteByInlongGroupIds(groupIds);
            this.streamSourceMapper.deleteByInlongGroupIds(groupIds);
            this.streamSourceFieldMapper.deleteByInlongGroupIds(groupIds);
            this.streamTransformMapper.deleteByInlongGroupIds(groupIds);
            this.streamTransformFieldMapper.deleteByInlongGroupIds(groupIds);
            List processIds = this.workflowProcessMapper.selectByInlongGroupIds(groupIds);
            this.workflowProcessMapper.deleteByProcessIds(processIds);
            this.workflowTaskMapper.deleteByProcessIds(processIds);
            this.workflowEventLogMapper.deleteByProcessIds(processIds);
            log.info("success to delete data before {}, group ids size: {}", (Object)daysBefore, (Object)groupIds.size());
        }
        catch (Exception e) {
            log.error("exception while cleansing data from db: ", (Throwable)e);
        }
    }
}

