/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.postgresql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.postgresql.PostgreSQLTableInfo;
import org.apache.inlong.manager.service.resource.sink.postgresql.PostgreSQLSqlBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLJdbcUtils {
    private static final String POSTGRES_DRIVER_CLASS = "org.postgresql.Driver";
    private static final String POSTGRES_JDBC_PREFIX = "jdbc:postgresql";
    private static final String POSTGRESQL_DEFAULT_SCHEMA = "public";
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSQLJdbcUtils.class);

    public static Connection getConnection(String url, String user, String password) throws Exception {
        Connection conn;
        if (StringUtils.isBlank((CharSequence)url) || !url.startsWith(POSTGRES_JDBC_PREFIX)) {
            throw new Exception("PostgreSQL server URL was invalid, it should start with jdbc:postgresql");
        }
        try {
            Class.forName(POSTGRES_DRIVER_CLASS);
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (Exception e) {
            String errorMsg = "get PostgreSQL connection error, please check postgresql jdbc url, username or password";
            LOG.error(errorMsg, (Throwable)e);
            throw new Exception(errorMsg + ": " + e.getMessage());
        }
        if (conn == null) {
            throw new Exception("get PostgreSQL connection failed, please contact administrator");
        }
        LOG.info("get PostgreSQL connection success, url={}", (Object)url);
        return conn;
    }

    public static void executeSql(Connection conn, String sql) throws Exception {
        try (Statement stmt = conn.createStatement();){
            stmt.execute(sql);
            LOG.info("execute sql [{}] success", (Object)sql);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlBatch(Connection conn, List<String> sqls) throws Exception {
        conn.setAutoCommit(false);
        try (Statement stmt = conn.createStatement();){
            for (String entry : sqls) {
                stmt.execute(entry);
            }
            conn.commit();
            LOG.info("execute sql [{}] success", sqls);
        }
        finally {
            conn.setAutoCommit(true);
        }
    }

    public static void createSchema(Connection conn, String schemaName, String userName) throws Exception {
        if (PostgreSQLJdbcUtils.checkSchemaExist(conn, schemaName)) {
            LOG.info("the schema [{}] are exists", (Object)schemaName);
        } else {
            String sql = PostgreSQLSqlBuilder.buildCreateSchema(schemaName, userName);
            PostgreSQLJdbcUtils.executeSql(conn, sql);
            LOG.info("execute create schema sql [{}] success", (Object)sql);
        }
    }

    public static boolean checkSchemaExist(Connection conn, String schemaName) throws Exception {
        boolean result = false;
        if (POSTGRESQL_DEFAULT_SCHEMA.equals(schemaName)) {
            result = true;
        } else {
            String checkColumnSql = PostgreSQLSqlBuilder.getCheckSchema(schemaName);
            try (Statement statement = conn.createStatement();
                 ResultSet resultSet = statement.executeQuery(checkColumnSql);){
                int count;
                if (Objects.nonNull(resultSet) && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                    result = true;
                }
            }
        }
        LOG.info("check schema exist for schema={}, result={}", (Object)schemaName, (Object)result);
        return result;
    }

    public static boolean checkColumnExist(Connection conn, String schemaName, String tableName, String column) throws Exception {
        boolean result = false;
        String checkColumnSql = PostgreSQLSqlBuilder.getCheckColumn(schemaName, tableName, column);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkColumnSql);){
            int count;
            if (Objects.nonNull(resultSet) && resultSet.next() && (count = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check column exist for table={}, column={}, result={}", new Object[]{tableName, column, result});
        return result;
    }

    public static void createTable(Connection conn, PostgreSQLTableInfo tableInfo) throws Exception {
        if (PostgreSQLJdbcUtils.checkTablesExist(conn, tableInfo.getSchemaName(), tableInfo.getTableName())) {
            LOG.info("the table [{}] are exists", (Object)tableInfo.getTableName());
        } else {
            List<String> createTableSqls = PostgreSQLSqlBuilder.buildCreateTableSql(tableInfo);
            PostgreSQLJdbcUtils.executeSqlBatch(conn, createTableSqls);
            LOG.info("execute sql [{}] success", createTableSqls);
        }
    }

    public static boolean checkTablesExist(Connection conn, String schemaName, String tableName) throws Exception {
        boolean result = false;
        String checkTableSql = PostgreSQLSqlBuilder.getCheckTable(schemaName, tableName);
        try (Statement statement = conn.createStatement();
             ResultSet resultSet = statement.executeQuery(checkTableSql);){
            int size;
            if (null != resultSet && resultSet.next() && (size = resultSet.getInt(1)) > 0) {
                result = true;
            }
        }
        LOG.info("check table exist for username={} table={}, result={}", new Object[]{schemaName, tableName, result});
        return result;
    }

    public static List<PostgreSQLColumnInfo> getColumns(Connection conn, String schemaName, String tableName) throws Exception {
        ArrayList<PostgreSQLColumnInfo> columnList = new ArrayList<PostgreSQLColumnInfo>();
        String querySql = PostgreSQLSqlBuilder.buildDescTableSql(schemaName, tableName);
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(querySql);){
            while (rs.next()) {
                columnList.add(new PostgreSQLColumnInfo(rs.getString(1), rs.getString(2), rs.getString(3)));
            }
        }
        return columnList;
    }

    public static void addColumns(Connection conn, String schemaName, String tableName, List<PostgreSQLColumnInfo> columns) throws Exception {
        ArrayList<PostgreSQLColumnInfo> columnInfos = new ArrayList<PostgreSQLColumnInfo>();
        for (PostgreSQLColumnInfo columnInfo : columns) {
            if (PostgreSQLJdbcUtils.checkColumnExist(conn, schemaName, tableName, columnInfo.getName())) continue;
            columnInfos.add(columnInfo);
        }
        List<String> addColumnSql = PostgreSQLSqlBuilder.buildAddColumnsSql(schemaName, tableName, columnInfos);
        PostgreSQLJdbcUtils.executeSqlBatch(conn, addColumnSql);
        LOG.info("execute add columns sql [{}] success", addColumnSql);
    }
}

