/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.iceberg;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergColumnInfo;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergPartition;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergTableInfo;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergCatalogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IcebergCatalogUtils.class);
    private static final String CATALOG_PROP_WAREHOUSE = "warehouse";
    private static final String CATALOG_PROP_URI = "uri";

    public static HiveCatalog getCatalog(String metastoreUri, String warehouse) {
        HiveCatalog catalog = new HiveCatalog();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put(CATALOG_PROP_URI, metastoreUri);
        if (StringUtils.isNotEmpty((CharSequence)warehouse)) {
            properties.put(CATALOG_PROP_WAREHOUSE, warehouse);
        }
        catalog.initialize("hive", properties);
        return catalog;
    }

    public static HiveCatalog getCatalog(String metastoreUri) {
        return IcebergCatalogUtils.getCatalog(metastoreUri, "");
    }

    public static void createDb(String metastoreUri, String warehouse, String dbName) {
        HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri, warehouse);
        Namespace ns = Namespace.of((String[])new String[]{dbName});
        if (catalog.namespaceExists(ns)) {
            LOGGER.info("db {} already exists", (Object)dbName);
            return;
        }
        catalog.createNamespace(ns);
    }

    public static void createTable(String metastoreUri, String warehouse, IcebergTableInfo tableInfo) {
        ArrayList<Types.NestedField> nestedFields = new ArrayList<Types.NestedField>();
        int id = 1;
        for (IcebergColumnInfo column : tableInfo.getColumns()) {
            if (column.isRequired()) {
                nestedFields.add(Types.NestedField.required((int)id, (String)column.getName(), (Type)Types.fromPrimitiveString((String)IcebergCatalogUtils.icebergTypeDesc(column))));
            } else {
                nestedFields.add(Types.NestedField.optional((int)id, (String)column.getName(), (Type)Types.fromPrimitiveString((String)IcebergCatalogUtils.icebergTypeDesc(column))));
            }
            ++id;
        }
        Schema schema = new Schema(nestedFields);
        PartitionSpec spec = IcebergCatalogUtils.createPartitionSpec(schema, tableInfo.getColumns());
        HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri, warehouse);
        TableIdentifier name = TableIdentifier.of((String[])new String[]{tableInfo.getDbName(), tableInfo.getTableName()});
        catalog.createTable(name, schema, spec);
    }

    private static String icebergTypeDesc(IcebergColumnInfo column) {
        switch (IcebergType.forType((String)column.getType())) {
            case DECIMAL: {
                return String.format("decimal(%d, %d)", column.getPrecision(), column.getScale());
            }
            case FIXED: {
                return String.format("fixed(%d)", column.getLength());
            }
        }
        return column.getType();
    }

    public static boolean tableExists(String metastoreUri, String dbName, String tableName) {
        HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri);
        return catalog.tableExists(TableIdentifier.of((String[])new String[]{dbName, tableName}));
    }

    public static List<IcebergColumnInfo> getColumns(String metastoreUri, String dbName, String tableName) {
        ArrayList<IcebergColumnInfo> columnList = new ArrayList<IcebergColumnInfo>();
        HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri);
        Table table = catalog.loadTable(TableIdentifier.of((String[])new String[]{dbName, tableName}));
        Schema schema = table.schema();
        for (Types.NestedField column : schema.columns()) {
            IcebergColumnInfo info = new IcebergColumnInfo();
            info.setName(column.name());
            info.setRequired(column.isRequired());
            columnList.add(info);
        }
        return columnList;
    }

    public static void addColumns(String metastoreUri, String dbName, String tableName, List<IcebergColumnInfo> columns) {
        HiveCatalog catalog = IcebergCatalogUtils.getCatalog(metastoreUri);
        Table table = catalog.loadTable(TableIdentifier.of((String[])new String[]{dbName, tableName}));
        UpdateSchema updateSchema = table.updateSchema();
        for (IcebergColumnInfo column : columns) {
            if (column.isRequired()) {
                updateSchema.addRequiredColumn(column.getName(), (Type)Types.fromPrimitiveString((String)IcebergCatalogUtils.icebergTypeDesc(column)), column.getDesc());
                continue;
            }
            updateSchema.addColumn(column.getName(), (Type)Types.fromPrimitiveString((String)IcebergCatalogUtils.icebergTypeDesc(column)), column.getDesc());
        }
        updateSchema.commit();
        UpdatePartitionSpec updateSpec = table.updateSpec();
        columns.forEach(c -> IcebergCatalogUtils.updateColumnSpec(c, updateSpec));
        updateSpec.commit();
    }

    private static PartitionSpec createPartitionSpec(Schema schema, List<IcebergColumnInfo> columns) {
        PartitionSpec.Builder spec = PartitionSpec.builderFor((Schema)schema);
        columns.forEach(c -> IcebergCatalogUtils.buildColumnSpec(c, spec));
        return spec.build();
    }

    private static void buildColumnSpec(IcebergColumnInfo column, PartitionSpec.Builder builder) {
        if (StringUtils.isEmpty((CharSequence)column.getPartitionStrategy())) {
            return;
        }
        switch (IcebergPartition.forName((String)column.getPartitionStrategy())) {
            case IDENTITY: {
                builder.identity(column.getName());
                break;
            }
            case BUCKET: {
                builder.bucket(column.getName(), column.getBucketNum().intValue());
                break;
            }
            case TRUNCATE: {
                builder.truncate(column.getName(), column.getWidth().intValue());
                break;
            }
            case YEAR: {
                builder.year(column.getName());
                break;
            }
            case MONTH: {
                builder.month(column.getName());
                break;
            }
            case DAY: {
                builder.day(column.getName());
                break;
            }
            case HOUR: {
                builder.hour(column.getName());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown iceberg partition strategy: " + column.getPartitionStrategy());
            }
        }
    }

    private static void updateColumnSpec(IcebergColumnInfo column, UpdatePartitionSpec builder) {
        if (StringUtils.isEmpty((CharSequence)column.getPartitionStrategy())) {
            return;
        }
        switch (IcebergPartition.forName((String)column.getPartitionStrategy())) {
            case IDENTITY: {
                builder.addField(column.getName());
                break;
            }
            case BUCKET: {
                builder.addField((Term)Expressions.bucket((String)column.getName(), (int)column.getBucketNum()));
                break;
            }
            case TRUNCATE: {
                builder.addField((Term)Expressions.truncate((String)column.getName(), (int)column.getWidth()));
                break;
            }
            case YEAR: {
                builder.addField((Term)Expressions.year((String)column.getName()));
                break;
            }
            case MONTH: {
                builder.addField((Term)Expressions.month((String)column.getName()));
                break;
            }
            case DAY: {
                builder.addField((Term)Expressions.day((String)column.getName()));
                break;
            }
            case HOUR: {
                builder.addField((Term)Expressions.hour((String)column.getName()));
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown iceberg partition strategy: " + column.getPartitionStrategy());
            }
        }
    }
}

