/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.sink.es;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.consts.InlongConstants;
import org.apache.inlong.manager.common.enums.SinkStatus;
import org.apache.inlong.manager.common.exceptions.WorkflowException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.StreamSinkFieldEntity;
import org.apache.inlong.manager.dao.mapper.StreamSinkFieldEntityMapper;
import org.apache.inlong.manager.pojo.sink.SinkInfo;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchFieldInfo;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSinkDTO;
import org.apache.inlong.manager.service.node.DataNodeOperateHelper;
import org.apache.inlong.manager.service.resource.sink.SinkResourceOperator;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchApi;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchConfig;
import org.apache.inlong.manager.service.sink.StreamSinkService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElasticsearchResourceOperator
implements SinkResourceOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchResourceOperator.class);
    @Autowired
    private StreamSinkService sinkService;
    @Autowired
    private StreamSinkFieldEntityMapper sinkFieldMapper;
    @Autowired
    private DataNodeOperateHelper dataNodeHelper;

    @Override
    public Boolean accept(String sinkType) {
        return "ELASTICSEARCH".equals(sinkType);
    }

    @Override
    public void createSinkResource(SinkInfo sinkInfo) {
        if (sinkInfo == null) {
            LOGGER.warn("sink info was null, skip to create es resource");
            return;
        }
        if (SinkStatus.CONFIG_SUCCESSFUL.getCode().equals(sinkInfo.getStatus())) {
            LOGGER.warn("sink resource [" + sinkInfo.getId() + "] already success, skip to create");
            return;
        }
        if (InlongConstants.DISABLE_CREATE_RESOURCE.equals(sinkInfo.getEnableCreateResource())) {
            LOGGER.warn("create resource was disabled, skip to create for [" + sinkInfo.getId() + "]");
            return;
        }
        this.createIndex(sinkInfo);
    }

    private void createIndex(SinkInfo sinkInfo) {
        LOGGER.info("begin to create es index for sinkId={}", (Object)sinkInfo.getId());
        List sinkList = this.sinkFieldMapper.selectBySinkId(sinkInfo.getId());
        if (CollectionUtils.isEmpty((Collection)sinkList)) {
            LOGGER.warn("no es fields found, skip to create es index for sinkId={}", (Object)sinkInfo.getId());
        }
        List<ElasticsearchFieldInfo> fieldList = this.getElasticsearchFieldFromSink(sinkList);
        try {
            ElasticsearchApi client = new ElasticsearchApi();
            ElasticsearchSinkDTO esInfo = ElasticsearchSinkDTO.getFromJson((String)sinkInfo.getExtParams());
            client.setEsConfig(this.getElasticsearchConfig(sinkInfo, esInfo));
            String indexName = esInfo.getIndexName();
            boolean indexExists = client.indexExists(indexName);
            if (!indexExists) {
                client.createIndexAndMapping(indexName, fieldList);
            } else {
                client.addNotExistFields(indexName, fieldList);
            }
            String info = "success to create es resource";
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_SUCCESSFUL.getCode(), info);
            LOGGER.info(info + " for sinkInfo={}", (Object)sinkInfo);
        }
        catch (Throwable e) {
            String errMsg = "Create Elasticsearch index failed: " + e.getMessage();
            LOGGER.error(errMsg, e);
            this.sinkService.updateStatus(sinkInfo.getId(), SinkStatus.CONFIG_FAILED.getCode(), errMsg);
            throw new WorkflowException(errMsg);
        }
    }

    public List<ElasticsearchFieldInfo> getElasticsearchFieldFromSink(List<StreamSinkFieldEntity> sinkList) {
        ArrayList<ElasticsearchFieldInfo> esFieldList = new ArrayList<ElasticsearchFieldInfo>();
        for (StreamSinkFieldEntity fieldEntity : sinkList) {
            if (StringUtils.isNotBlank((CharSequence)fieldEntity.getExtParams())) {
                ElasticsearchFieldInfo elasticsearchFieldInfo = ElasticsearchFieldInfo.getFromJson((String)fieldEntity.getExtParams());
                CommonBeanUtils.copyProperties((Object)fieldEntity, (Object)elasticsearchFieldInfo, (boolean)true);
                esFieldList.add(elasticsearchFieldInfo);
                continue;
            }
            ElasticsearchFieldInfo esFieldInfo = new ElasticsearchFieldInfo();
            CommonBeanUtils.copyProperties((Object)fieldEntity, (Object)esFieldInfo, (boolean)true);
            esFieldList.add(esFieldInfo);
        }
        return esFieldList;
    }

    private ElasticsearchConfig getElasticsearchConfig(SinkInfo sinkInfo, ElasticsearchSinkDTO esInfo) {
        ElasticsearchConfig config = new ElasticsearchConfig();
        if (StringUtils.isNotEmpty((CharSequence)esInfo.getUsername())) {
            config.setAuthEnable(true);
            config.setUsername(esInfo.getUsername());
            config.setPassword(esInfo.getPassword());
        }
        config.setHosts(esInfo.getHosts());
        return config;
    }
}

