/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.resource.queue.kafka;

import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.WorkflowListenerException;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.pojo.cluster.ClusterInfo;
import org.apache.inlong.manager.pojo.cluster.kafka.KafkaClusterInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.kafka.InlongKafkaInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamInfo;
import org.apache.inlong.manager.service.cluster.InlongClusterService;
import org.apache.inlong.manager.service.consume.InlongConsumeService;
import org.apache.inlong.manager.service.resource.queue.QueueResourceOperator;
import org.apache.inlong.manager.service.resource.queue.kafka.KafkaOperator;
import org.apache.inlong.manager.service.stream.InlongStreamService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class KafkaResourceOperators
implements QueueResourceOperator {
    private static final Logger log = LoggerFactory.getLogger(KafkaResourceOperators.class);
    public static final String KAFKA_CONSUMER_GROUP = "%s_%s_consumer_group";
    @Autowired
    private KafkaOperator kafkaOperator;
    @Autowired
    private InlongStreamService streamService;
    @Autowired
    private InlongConsumeService consumeService;
    @Autowired
    private InlongClusterService clusterService;

    @Override
    public boolean accept(String mqType) {
        return "KAFKA".equals(mqType);
    }

    @Override
    public void createQueueForGroup(@NotNull InlongGroupInfo groupInfo, @NotBlank String operator) {
        log.info("skip to create kafka topic for groupId={}, just create in each inlong stream", (Object)groupInfo.getInlongGroupId());
    }

    @Override
    public void deleteQueueForGroup(InlongGroupInfo groupInfo, String operator) {
        Preconditions.expectNotNull((Object)groupInfo, (String)"inlong group info cannot be null");
        String groupId = groupInfo.getInlongGroupId();
        log.info("begin to delete kafka resource for groupId={}", (Object)groupId);
        ClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "KAFKA");
        try {
            List<InlongStreamBriefInfo> streamInfoList = this.streamService.getTopicList(groupId);
            if (streamInfoList == null || streamInfoList.isEmpty()) {
                log.warn("skip to create kafka topic and subscription as no streams for groupId={}", (Object)groupId);
                return;
            }
            for (InlongStreamBriefInfo streamInfo : streamInfoList) {
                this.deleteKafkaTopic(groupInfo, streamInfo.getMqResource());
            }
        }
        catch (Exception e) {
            log.error("failed to delete kafka resource for groupId=" + groupId, (Throwable)e);
            throw new WorkflowListenerException("failed to delete kafka resource: " + e.getMessage());
        }
        log.info("success to delete kafka resource for groupId={}, cluster={}", (Object)groupId, (Object)clusterInfo);
    }

    @Override
    public void createQueueForStream(InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, String operator) {
        Preconditions.expectNotNull((Object)groupInfo, (String)"inlong group info cannot be null");
        Preconditions.expectNotNull((Object)streamInfo, (String)"inlong stream info cannot be null");
        Preconditions.expectNotBlank((String)operator, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"operator cannot be null");
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        log.info("begin to create kafka resource for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        try {
            InlongKafkaInfo inlongKafkaInfo = (InlongKafkaInfo)groupInfo;
            String topicName = streamInfo.getMqResource();
            if (topicName.equals(streamId)) {
                topicName = String.format("%s.%s", inlongKafkaInfo.getMqResource(), streamInfo.getMqResource());
            }
            this.createKafkaTopic(inlongKafkaInfo, topicName);
        }
        catch (Exception e) {
            String msg = String.format("failed to create kafka topic for groupId=%s, streamId=%s", groupId, streamId);
            log.error(msg, (Throwable)e);
            throw new WorkflowListenerException(msg + ": " + e.getMessage());
        }
        log.info("success to create kafka resource for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
    }

    @Override
    public void deleteQueueForStream(InlongGroupInfo groupInfo, InlongStreamInfo streamInfo, String operator) {
        Preconditions.expectNotNull((Object)groupInfo, (String)"inlong group info cannot be null");
        Preconditions.expectNotNull((Object)streamInfo, (String)"inlong stream info cannot be null");
        String groupId = streamInfo.getInlongGroupId();
        String streamId = streamInfo.getInlongStreamId();
        log.info("begin to delete kafka resource for groupId={} streamId={}", (Object)groupId, (Object)streamId);
        try {
            String topicName = streamInfo.getMqResource();
            if (StringUtils.isBlank((CharSequence)topicName) || topicName.equals(streamId)) {
                topicName = String.format("%s.%s", groupInfo.getMqResource(), streamInfo.getMqResource());
            }
            this.deleteKafkaTopic(groupInfo, topicName);
            log.info("success to delete kafka topic for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
        }
        catch (Exception e) {
            String msg = String.format("failed to delete kafka topic for groupId=%s, streamId=%s", groupId, streamId);
            log.error(msg, (Throwable)e);
            throw new WorkflowListenerException(msg);
        }
        log.info("success to delete kafka resource for groupId={}, streamId={}", (Object)groupId, (Object)streamId);
    }

    private void createKafkaTopic(InlongKafkaInfo kafkaInfo, String topicName) throws Exception {
        ClusterInfo clusterInfo = this.clusterService.getOne(kafkaInfo.getInlongClusterTag(), null, "KAFKA");
        this.kafkaOperator.createTopic(kafkaInfo, (KafkaClusterInfo)clusterInfo, topicName);
        boolean exist = this.kafkaOperator.topicIsExists((KafkaClusterInfo)clusterInfo, topicName);
        if (!exist) {
            String bootStrapServers = clusterInfo.getUrl();
            log.error("topic={} not exists in {}", (Object)topicName, (Object)bootStrapServers);
            throw new WorkflowListenerException("topic=" + topicName + " not exists in " + bootStrapServers);
        }
        String consumeGroup = String.format(KAFKA_CONSUMER_GROUP, kafkaInfo.getInlongClusterTag(), topicName);
        Integer id = this.consumeService.saveBySystem((InlongGroupInfo)kafkaInfo, topicName, consumeGroup);
        log.info("success to save inlong consume [{}] for consumerGroup={}, groupId={}, topic={}", new Object[]{id, consumeGroup, kafkaInfo.getInlongGroupId(), topicName});
    }

    private void deleteKafkaTopic(InlongGroupInfo groupInfo, String topicName) {
        ClusterInfo clusterInfo = this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "KAFKA");
        this.kafkaOperator.forceDeleteTopic((KafkaClusterInfo)clusterInfo, topicName);
    }
}

