/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.node.mysql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.Connection;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.DataNodeEntity;
import org.apache.inlong.manager.pojo.node.DataNodeInfo;
import org.apache.inlong.manager.pojo.node.DataNodeRequest;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeDTO;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeInfo;
import org.apache.inlong.manager.pojo.node.mysql.MySQLDataNodeRequest;
import org.apache.inlong.manager.service.node.AbstractDataNodeOperator;
import org.apache.inlong.manager.service.resource.sink.mysql.MySQLJdbcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MySQLDataNodeOperator
extends AbstractDataNodeOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLDataNodeOperator.class);
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public Boolean accept(String dataNodeType) {
        return this.getDataNodeType().equals(dataNodeType);
    }

    @Override
    public String getDataNodeType() {
        return "MYSQL";
    }

    @Override
    public DataNodeInfo getFromEntity(DataNodeEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.DATA_NODE_NOT_FOUND);
        }
        MySQLDataNodeInfo dataNodeInfo = new MySQLDataNodeInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)dataNodeInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            MySQLDataNodeDTO dto = MySQLDataNodeDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)dataNodeInfo);
        }
        return dataNodeInfo;
    }

    @Override
    protected void setTargetEntity(DataNodeRequest request, DataNodeEntity targetEntity) {
        MySQLDataNodeRequest dataNodeRequest = (MySQLDataNodeRequest)request;
        CommonBeanUtils.copyProperties((Object)dataNodeRequest, (Object)targetEntity, (boolean)true);
        try {
            MySQLDataNodeDTO dto = MySQLDataNodeDTO.getFromRequest((MySQLDataNodeRequest)dataNodeRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("Failed to build extParams for MySQL node: %s", e.getMessage()));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Boolean testConnection(DataNodeRequest request) {
        String jdbcUrl = MySQLDataNodeDTO.convertToJdbcurl((String)request.getUrl());
        String username = request.getUsername();
        String password = request.getToken();
        Preconditions.expectNotBlank((String)jdbcUrl, (ErrorCodeEnum)ErrorCodeEnum.INVALID_PARAMETER, (String)"connection jdbcUrl cannot be empty");
        try (Connection ignored = MySQLJdbcUtils.getConnection(jdbcUrl, username, password);){
            LOGGER.info("mysql connection not null - connection success for jdbcUrl={}, username={}, password={}", new Object[]{jdbcUrl, username, password});
            Boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsg = String.format("mysql connection failed for jdbcUrl=%s, username=%s, password=%s", jdbcUrl, username, password);
            LOGGER.error(errMsg, (Throwable)e);
            throw new BusinessException(errMsg);
        }
    }

    @Override
    public void updateRelatedStreamSource(DataNodeRequest request, DataNodeEntity oldEntity, String operator) {
        boolean changed;
        MySQLDataNodeRequest nodeRequest = (MySQLDataNodeRequest)request;
        MySQLDataNodeInfo nodeInfo = (MySQLDataNodeInfo)this.getFromEntity(oldEntity);
        boolean bl = changed = !Objects.equals(nodeRequest.getUrl(), nodeInfo.getUrl()) || !Objects.equals(nodeRequest.getBackupUrl(), nodeInfo.getBackupUrl()) || !Objects.equals(nodeRequest.getUsername(), nodeInfo.getUsername()) || !Objects.equals(nodeRequest.getToken(), nodeInfo.getToken());
        if (changed) {
            this.retryStreamSourceByDataNodeNameAndType(request.getName(), "MYSQL_SQL", operator);
        }
    }
}

