/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.group;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.dao.entity.InlongGroupEntity;
import org.apache.inlong.manager.dao.entity.InlongGroupExtEntity;
import org.apache.inlong.manager.dao.entity.InlongStreamExtEntity;
import org.apache.inlong.manager.pojo.cluster.pulsar.PulsarClusterInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarDTO;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarInfo;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarRequest;
import org.apache.inlong.manager.pojo.group.pulsar.InlongPulsarTopicInfo;
import org.apache.inlong.manager.pojo.stream.InlongStreamBriefInfo;
import org.apache.inlong.manager.service.group.AbstractGroupOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class InlongGroupOperator4Pulsar
extends AbstractGroupOperator {
    private static final Logger LOGGER = LoggerFactory.getLogger(InlongGroupOperator4Pulsar.class);

    @Override
    public Boolean accept(String mqType) {
        return this.getMQType().equals(mqType) || "TDMQ_PULSAR".equals(mqType);
    }

    @Override
    public String getMQType() {
        return "PULSAR";
    }

    @Override
    public InlongGroupInfo getFromEntity(InlongGroupEntity entity) {
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.GROUP_NOT_FOUND);
        }
        InlongPulsarInfo groupInfo = new InlongPulsarInfo();
        CommonBeanUtils.copyProperties((Object)entity, (Object)groupInfo);
        if (StringUtils.isNotBlank((CharSequence)entity.getExtParams())) {
            InlongPulsarDTO dto = InlongPulsarDTO.getFromJson((String)entity.getExtParams());
            CommonBeanUtils.copyProperties((Object)dto, (Object)groupInfo);
        }
        return groupInfo;
    }

    @Override
    protected void setTargetEntity(InlongGroupRequest request, InlongGroupEntity targetEntity) {
        InlongPulsarRequest pulsarRequest = (InlongPulsarRequest)request;
        Integer ackQuorum = pulsarRequest.getAckQuorum();
        Integer writeQuorum = pulsarRequest.getWriteQuorum();
        if (ackQuorum == null) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Pulsar ackQuorum cannot be empty");
        }
        if (writeQuorum == null) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Pulsar writeQuorum cannot be empty");
        }
        if (ackQuorum < 0 || writeQuorum < 0) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Pulsar ackQuorum or writeQuorum must greater than or equal to 0");
        }
        if (ackQuorum > writeQuorum) {
            throw new BusinessException(ErrorCodeEnum.INVALID_PARAMETER, "Pulsar params must meet: ackQuorum <= writeQuorum");
        }
        pulsarRequest.setEnsemble(writeQuorum);
        CommonBeanUtils.copyProperties((Object)pulsarRequest, (Object)targetEntity, (boolean)true);
        try {
            InlongPulsarDTO dto = InlongPulsarDTO.getFromRequest((InlongPulsarRequest)pulsarRequest, (String)targetEntity.getExtParams());
            targetEntity.setExtParams(this.objectMapper.writeValueAsString((Object)dto));
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SOURCE_INFO_INCORRECT, String.format("serialize extParams of Pulsar failure: %s", e.getMessage()));
        }
    }

    @Override
    public InlongGroupTopicInfo getTopic(InlongGroupInfo groupInfo) {
        PulsarClusterInfo pulsarCluster = (PulsarClusterInfo)this.clusterService.getOne(groupInfo.getInlongClusterTag(), null, "PULSAR");
        String tenant = ((InlongPulsarInfo)groupInfo).getPulsarTenant();
        if (StringUtils.isBlank((CharSequence)tenant)) {
            tenant = pulsarCluster.getPulsarTenant();
        }
        InlongPulsarTopicInfo topicInfo = new InlongPulsarTopicInfo();
        topicInfo.setTenant(tenant);
        topicInfo.setNamespace(groupInfo.getMqResource());
        List topics = this.streamService.getTopicList(groupInfo.getInlongGroupId()).stream().map(InlongStreamBriefInfo::getMqResource).collect(Collectors.toList());
        topicInfo.setTopics(topics);
        return topicInfo;
    }

    @Override
    public InlongGroupTopicInfo getBackupTopic(InlongGroupInfo groupInfo) {
        String groupId = groupInfo.getInlongGroupId();
        InlongGroupExtEntity extEntity = this.groupExtMapper.selectByUniqueKey(groupId, "backup_mq_resource");
        InlongPulsarTopicInfo topicInfo = new InlongPulsarTopicInfo();
        if (extEntity != null && StringUtils.isNotBlank((CharSequence)extEntity.getKeyValue())) {
            topicInfo.setNamespace(extEntity.getKeyValue());
        } else {
            topicInfo.setNamespace(groupInfo.getMqResource());
        }
        List<InlongStreamBriefInfo> streamTopics = this.streamService.getTopicList(groupId);
        List topics = streamTopics.stream().map(stream -> {
            InlongStreamExtEntity streamExtEntity = this.streamExtMapper.selectByKey(groupId, stream.getInlongStreamId(), "backup_mq_resource");
            if (streamExtEntity != null && StringUtils.isNotBlank((CharSequence)streamExtEntity.getKeyValue())) {
                return streamExtEntity.getKeyValue();
            }
            return stream.getMqResource();
        }).collect(Collectors.toList());
        topicInfo.setTopics(topics);
        return topicInfo;
    }
}

