/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.service.core.impl;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.SQL;
import org.apache.inlong.manager.common.enums.AuditQuerySource;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.enums.TimeStaticsDim;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.Preconditions;
import org.apache.inlong.manager.dao.entity.AuditBaseEntity;
import org.apache.inlong.manager.dao.entity.AuditSourceEntity;
import org.apache.inlong.manager.dao.entity.StreamSinkEntity;
import org.apache.inlong.manager.dao.mapper.AuditBaseEntityMapper;
import org.apache.inlong.manager.dao.mapper.AuditEntityMapper;
import org.apache.inlong.manager.dao.mapper.AuditSourceEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSinkEntityMapper;
import org.apache.inlong.manager.dao.mapper.StreamSourceEntityMapper;
import org.apache.inlong.manager.pojo.audit.AuditInfo;
import org.apache.inlong.manager.pojo.audit.AuditRequest;
import org.apache.inlong.manager.pojo.audit.AuditSourceRequest;
import org.apache.inlong.manager.pojo.audit.AuditSourceResponse;
import org.apache.inlong.manager.pojo.audit.AuditVO;
import org.apache.inlong.manager.pojo.user.LoginUserUtils;
import org.apache.inlong.manager.service.core.AuditService;
import org.apache.inlong.manager.service.resource.sink.ck.ClickHouseConfig;
import org.apache.inlong.manager.service.resource.sink.es.ElasticsearchApi;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class AuditServiceImpl
implements AuditService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditServiceImpl.class);
    private static final String SECOND_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String HOUR_FORMAT = "yyyy-MM-dd HH";
    private static final String DAY_FORMAT = "yyyy-MM-dd";
    private static final DateTimeFormatter SECOND_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter HOUR_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH");
    private static final DateTimeFormatter DAY_DATE_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private final Map<String, AuditBaseEntity> auditSentItemMap = new ConcurrentHashMap<String, AuditBaseEntity>();
    private final Map<String, AuditBaseEntity> auditReceivedItemMap = new ConcurrentHashMap<String, AuditBaseEntity>();
    @Value(value="#{'${audit.admin.ids:3,4,5,6}'.split(',')}")
    private List<String> auditIdListForAdmin;
    @Value(value="#{'${audit.user.ids:3,4,5,6}'.split(',')}")
    private List<String> auditIdListForUser;
    @Value(value="${audit.query.source}")
    private String auditQuerySource;
    @Autowired
    private AuditBaseEntityMapper auditBaseMapper;
    @Autowired
    private AuditEntityMapper auditEntityMapper;
    @Autowired
    private ElasticsearchApi elasticsearchApi;
    @Autowired
    private StreamSinkEntityMapper sinkEntityMapper;
    @Autowired
    private StreamSourceEntityMapper sourceEntityMapper;
    @Autowired
    private ClickHouseConfig config;
    @Autowired
    private AuditSourceEntityMapper auditSourceMapper;

    @PostConstruct
    public void initialize() {
        LOGGER.info("init audit base item cache map for {}", (Object)AuditServiceImpl.class.getSimpleName());
        try {
            this.refreshBaseItemCache();
        }
        catch (Throwable t) {
            LOGGER.error("initialize audit base item cache error", t);
        }
    }

    @Override
    public Boolean refreshBaseItemCache() {
        LOGGER.debug("start to reload audit base item info");
        try {
            List auditBaseEntities = this.auditBaseMapper.selectAll();
            for (AuditBaseEntity auditBaseEntity : auditBaseEntities) {
                String type = auditBaseEntity.getType();
                if (auditBaseEntity.getIsSent() == 1) {
                    this.auditSentItemMap.put(type, auditBaseEntity);
                    continue;
                }
                this.auditReceivedItemMap.put(type, auditBaseEntity);
            }
        }
        catch (Throwable t) {
            LOGGER.error("failed to reload audit base item info", t);
            return false;
        }
        LOGGER.debug("success to reload audit base item info");
        return true;
    }

    @Override
    public Integer updateAuditSource(AuditSourceRequest request, String operator) {
        String offlineUrl = request.getOfflineUrl();
        if (StringUtils.isNotBlank((CharSequence)offlineUrl)) {
            this.auditSourceMapper.offlineSourceByUrl(offlineUrl);
            LOGGER.info("success offline the audit source with url: {}", (Object)offlineUrl);
        }
        AuditSourceEntity entity = (AuditSourceEntity)CommonBeanUtils.copyProperties((Object)request, AuditSourceEntity::new);
        entity.setStatus(Integer.valueOf(1));
        entity.setCreator(operator);
        entity.setModifier(operator);
        this.auditSourceMapper.insert(entity);
        Integer id = entity.getId();
        LOGGER.info("success to insert audit source with id={}", (Object)id);
        this.config.updateRuntimeConfig();
        LOGGER.info("success to update audit source with id={}", (Object)id);
        return id;
    }

    @Override
    public AuditSourceResponse getAuditSource() {
        AuditSourceEntity entity = this.auditSourceMapper.selectOnlineSource();
        if (entity == null) {
            throw new BusinessException(ErrorCodeEnum.RECORD_NOT_FOUND);
        }
        LOGGER.debug("success to get audit source, id={}", (Object)entity.getId());
        return (AuditSourceResponse)CommonBeanUtils.copyProperties((Object)entity, AuditSourceResponse::new);
    }

    @Override
    public String getAuditId(String type, boolean isSent) {
        AuditBaseEntity auditBaseEntity;
        if (StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        AuditBaseEntity auditBaseEntity2 = auditBaseEntity = isSent ? this.auditSentItemMap.get(type) : this.auditReceivedItemMap.get(type);
        if (auditBaseEntity != null) {
            return auditBaseEntity.getAuditId();
        }
        auditBaseEntity = this.auditBaseMapper.selectByTypeAndIsSent(type, Integer.valueOf(isSent ? 1 : 0));
        Preconditions.expectNotNull((Object)auditBaseEntity, (ErrorCodeEnum)ErrorCodeEnum.AUDIT_ID_TYPE_NOT_SUPPORTED, (String)String.format(ErrorCodeEnum.AUDIT_ID_TYPE_NOT_SUPPORTED.getMessage(), type));
        if (isSent) {
            this.auditSentItemMap.put(type, auditBaseEntity);
        } else {
            this.auditReceivedItemMap.put(type, auditBaseEntity);
        }
        return auditBaseEntity.getAuditId();
    }

    @Override
    public List<AuditVO> listByCondition(AuditRequest request) throws Exception {
        LOGGER.info("begin query audit list request={}", (Object)request);
        Preconditions.expectNotNull((Object)request, (String)"request is null");
        String groupId = request.getInlongGroupId();
        String streamId = request.getInlongStreamId();
        String sinkNodeType = null;
        Integer sinkId = request.getSinkId();
        StreamSinkEntity sinkEntity = null;
        List sinkEntityList = this.sinkEntityMapper.selectByRelatedId(groupId, streamId);
        if (sinkId != null) {
            sinkEntity = this.sinkEntityMapper.selectByPrimaryKey(sinkId);
        } else if (CollectionUtils.isNotEmpty((Collection)sinkEntityList)) {
            sinkEntity = (StreamSinkEntity)sinkEntityList.get(0);
        }
        if (sinkEntity != null) {
            sinkNodeType = sinkEntity.getSinkType();
        }
        request.setAuditIds(this.getAuditIds(groupId, streamId, sinkNodeType));
        ArrayList<AuditVO> result = new ArrayList<AuditVO>();
        AuditQuerySource querySource = AuditQuerySource.valueOf((String)this.auditQuerySource);
        for (String auditId : request.getAuditIds()) {
            List auditSet;
            if (AuditQuerySource.MYSQL == querySource) {
                String format = "%Y-%m-%d %H:%i:00";
                DateTime endDate = DAY_DATE_FORMATTER.parseDateTime(request.getEndDate());
                String endDateStr = endDate.plusDays(1).toString(DAY_DATE_FORMATTER);
                List sumList = this.auditEntityMapper.sumByLogTs(groupId, streamId, auditId, request.getStartDate(), endDateStr, format);
                auditSet = sumList.stream().map(s -> {
                    AuditInfo vo = new AuditInfo();
                    vo.setLogTs((String)s.get("logTs"));
                    vo.setCount(((BigDecimal)s.get("total")).longValue());
                    vo.setCount(((BigDecimal)s.get("totalDelay")).longValue());
                    return vo;
                }).collect(Collectors.toList());
                result.add(new AuditVO(auditId, auditSet, auditId.equals(this.getAuditId(sinkNodeType, true)) ? sinkNodeType : null));
                continue;
            }
            if (AuditQuerySource.ELASTICSEARCH == querySource) {
                ParsedTerms terms;
                String index = String.format("%s_%s", request.getStartDate().replaceAll("-", ""), auditId);
                if (!this.elasticsearchApi.indexExists(index)) {
                    LOGGER.warn("elasticsearch index={} not exists", (Object)index);
                    continue;
                }
                SearchResponse response = this.elasticsearchApi.search(this.toAuditSearchRequest(index, groupId, streamId));
                List aggregations = response.getAggregations().asList();
                if (!CollectionUtils.isNotEmpty((Collection)aggregations) || !CollectionUtils.isNotEmpty((Collection)(terms = (ParsedTerms)aggregations.get(0)).getBuckets())) continue;
                auditSet = terms.getBuckets().stream().map(bucket -> {
                    AuditInfo vo = new AuditInfo();
                    vo.setLogTs(bucket.getKeyAsString());
                    vo.setCount((long)((ParsedSum)bucket.getAggregations().asList().get(0)).getValue());
                    vo.setDelay((long)((ParsedSum)bucket.getAggregations().asList().get(1)).getValue());
                    return vo;
                }).collect(Collectors.toList());
                result.add(new AuditVO(auditId, auditSet, auditId.equals(this.getAuditId(sinkNodeType, true)) ? sinkNodeType : null));
                continue;
            }
            if (AuditQuerySource.CLICKHOUSE != querySource) continue;
            Connection connection = this.config.getCkConnection();
            Throwable throwable = null;
            try {
                PreparedStatement statement = this.getAuditCkStatement(connection, groupId, streamId, auditId, request.getStartDate(), request.getEndDate());
                Throwable throwable2 = null;
                try {
                    ResultSet resultSet = statement.executeQuery();
                    Throwable throwable3 = null;
                    try {
                        ArrayList<AuditInfo> auditSet2 = new ArrayList<AuditInfo>();
                        while (resultSet.next()) {
                            AuditInfo vo = new AuditInfo();
                            vo.setLogTs(resultSet.getString("log_ts"));
                            vo.setCount(resultSet.getLong("total"));
                            vo.setDelay(resultSet.getLong("total_delay"));
                            auditSet2.add(vo);
                        }
                        result.add(new AuditVO(auditId, auditSet2, auditId.equals(this.getAuditId(sinkNodeType, true)) ? sinkNodeType : null));
                    }
                    catch (Throwable throwable4) {
                        throwable3 = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (resultSet == null) continue;
                        if (throwable3 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable5) {
                                throwable3.addSuppressed(throwable5);
                            }
                            continue;
                        }
                        resultSet.close();
                    }
                }
                catch (Throwable throwable6) {
                    throwable2 = throwable6;
                    throw throwable6;
                }
                finally {
                    if (statement == null) continue;
                    if (throwable2 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable7) {
                            throwable2.addSuppressed(throwable7);
                        }
                        continue;
                    }
                    statement.close();
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (connection == null) continue;
                if (throwable != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable9) {
                        throwable.addSuppressed(throwable9);
                    }
                    continue;
                }
                connection.close();
            }
        }
        LOGGER.info("success to query audit list for request={}", (Object)request);
        return this.aggregateByTimeDim(result, request.getTimeStaticsDim());
    }

    private List<String> getAuditIds(String groupId, String streamId, String sinkNodeType) {
        boolean dpReceivedNeeded;
        HashSet<String> auditSet;
        HashSet<String> hashSet = auditSet = LoginUserUtils.getLoginUser().getRoles().contains("TENANT_ADMIN") ? new HashSet<String>(this.auditIdListForAdmin) : new HashSet<String>(this.auditIdListForUser);
        if (sinkNodeType == null) {
            auditSet.add(this.getAuditId("DATAPROXY", true));
        } else {
            auditSet.add(this.getAuditId(sinkNodeType, false));
        }
        List sourceList = this.sourceEntityMapper.selectByRelatedId(groupId, streamId, null);
        if ((CollectionUtils.isEmpty((Collection)sourceList) || sourceList.stream().allMatch(s -> "AUTO_PUSH".equals(s.getSourceType()))) && (dpReceivedNeeded = auditSet.contains(this.getAuditId("AGENT", false)))) {
            auditSet.add(this.getAuditId("DATAPROXY", false));
        }
        return new ArrayList<String>(auditSet);
    }

    private SearchRequest toAuditSearchRequest(String index, String groupId, String streamId) {
        TermsAggregationBuilder builder = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"log_ts").field("log_ts")).size(Integer.MAX_VALUE).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"count").field("count"))).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"delay").field("delay"));
        BoolQueryBuilder filterBuilder = new BoolQueryBuilder();
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"inlong_group_id", (String)groupId));
        filterBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"inlong_stream_id", (String)streamId));
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.aggregation((AggregationBuilder)builder);
        sourceBuilder.query((QueryBuilder)filterBuilder);
        sourceBuilder.from(0);
        sourceBuilder.size(0);
        sourceBuilder.sort("log_ts", SortOrder.ASC);
        return new SearchRequest(new String[]{index}, sourceBuilder);
    }

    private PreparedStatement getAuditCkStatement(Connection connection, String groupId, String streamId, String auditId, String startDate, String endDate) throws SQLException {
        String start = DAY_DATE_FORMATTER.parseDateTime(startDate).toString(SECOND_FORMAT);
        String end = DAY_DATE_FORMATTER.parseDateTime(endDate).plusDays(1).toString(SECOND_FORMAT);
        String subQuery = ((SQL)((SQL)((SQL)((SQL)((SQL)((SQL)((SQL)new SQL().SELECT_DISTINCT(new String[]{"ip", "docker_id", "thread_id", "sdk_ts", "packet_id", "log_ts", "inlong_group_id", "inlong_stream_id", "audit_id", "count", "size", "delay"})).FROM("audit_data")).WHERE("inlong_group_id = ?")).WHERE("inlong_stream_id = ?")).WHERE("audit_id = ?")).WHERE("log_ts >= ?")).WHERE("log_ts < ?")).toString();
        String sql = ((SQL)((SQL)((SQL)((SQL)new SQL().SELECT(new String[]{"log_ts", "sum(count) as total", "sum(delay) as total_delay"})).FROM("(" + subQuery + ") as sub")).GROUP_BY("log_ts")).ORDER_BY("log_ts")).toString();
        PreparedStatement statement = connection.prepareStatement(sql);
        statement.setString(1, groupId);
        statement.setString(2, streamId);
        statement.setString(3, auditId);
        statement.setString(4, start);
        statement.setString(5, end);
        return statement;
    }

    private List<AuditVO> aggregateByTimeDim(List<AuditVO> auditVOList, TimeStaticsDim timeStaticsDim) {
        List<AuditVO> result;
        switch (timeStaticsDim) {
            case HOUR: {
                result = this.doAggregate(auditVOList, HOUR_FORMAT);
                break;
            }
            case DAY: {
                result = this.doAggregate(auditVOList, DAY_FORMAT);
                break;
            }
            default: {
                result = this.doAggregate(auditVOList, SECOND_FORMAT);
            }
        }
        return result;
    }

    private List<AuditVO> doAggregate(List<AuditVO> auditVOList, String format) {
        ArrayList<AuditVO> result = new ArrayList<AuditVO>();
        for (AuditVO auditVO : auditVOList) {
            AuditVO statInfo = new AuditVO();
            HashMap<String, AtomicLong> countMap = new HashMap<String, AtomicLong>();
            HashMap<String, AtomicLong> delayMap = new HashMap<String, AtomicLong>();
            statInfo.setAuditId(auditVO.getAuditId());
            statInfo.setNodeType(auditVO.getNodeType());
            for (AuditInfo auditInfo : auditVO.getAuditSet()) {
                String statKey = this.formatLogTime(auditInfo.getLogTs(), format);
                if (statKey == null) continue;
                if (countMap.get(statKey) == null) {
                    countMap.put(statKey, new AtomicLong(0L));
                }
                if (delayMap.get(statKey) == null) {
                    delayMap.put(statKey, new AtomicLong(0L));
                }
                ((AtomicLong)countMap.get(statKey)).addAndGet(auditInfo.getCount());
                ((AtomicLong)delayMap.get(statKey)).addAndGet(auditInfo.getDelay());
            }
            LinkedList<AuditInfo> auditInfoList = new LinkedList<AuditInfo>();
            for (Map.Entry entry : countMap.entrySet()) {
                AuditInfo auditInfoStat = new AuditInfo();
                auditInfoStat.setLogTs((String)entry.getKey());
                long count = ((AtomicLong)entry.getValue()).get();
                auditInfoStat.setCount(((AtomicLong)entry.getValue()).get());
                auditInfoStat.setDelay(count == 0L ? 0L : ((AtomicLong)delayMap.get(entry.getKey())).get() / count);
                auditInfoList.add(auditInfoStat);
            }
            statInfo.setAuditSet(auditInfoList);
            result.add(statInfo);
        }
        return result;
    }

    private String formatLogTime(String dateString, String format) {
        String formatDateString = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat(format);
            Date date = formatter.parse(dateString);
            formatDateString = formatter.format(date);
        }
        catch (Exception e) {
            LOGGER.error("format lot time exception", (Throwable)e);
        }
        return formatDateString;
    }
}

