/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.source.tubemq;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.TreeSet;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.source.SourceRequest;
import org.apache.inlong.manager.pojo.source.StreamSource;
import org.apache.inlong.manager.pojo.source.tubemq.TubeMQSourceRequest;

@ApiModel(value="TubeMQ source info")
@JsonTypeDefine(value="TUBEMQ")
public class TubeMQSource
extends StreamSource {
    @ApiModelProperty(value="Master RPC of the TubeMQ")
    private String masterRpc;
    @ApiModelProperty(value="Topic of the TubeMQ")
    private String topic;
    @ApiModelProperty(value="Group of the TubeMQ")
    private String groupId;
    @ApiModelProperty(value="Session key of the TubeMQ")
    private String sessionKey;
    @ApiModelProperty(value="Tid of the TubeMQ")
    private TreeSet<String> tid;

    public TubeMQSource() {
        this.setSourceType("TUBEMQ");
    }

    @Override
    public SourceRequest genSourceRequest() {
        return (SourceRequest)CommonBeanUtils.copyProperties((Object)this, TubeMQSourceRequest::new);
    }

    protected TubeMQSource(TubeMQSourceBuilder<?, ?> b) {
        super((StreamSource.StreamSourceBuilder<?, ?>)b);
        this.masterRpc = ((TubeMQSourceBuilder)b).masterRpc;
        this.topic = ((TubeMQSourceBuilder)b).topic;
        this.groupId = ((TubeMQSourceBuilder)b).groupId;
        this.sessionKey = ((TubeMQSourceBuilder)b).sessionKey;
        this.tid = ((TubeMQSourceBuilder)b).tid;
    }

    public static TubeMQSourceBuilder<?, ?> builder() {
        return new TubeMQSourceBuilderImpl();
    }

    public String getMasterRpc() {
        return this.masterRpc;
    }

    public String getTopic() {
        return this.topic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public TreeSet<String> getTid() {
        return this.tid;
    }

    public void setMasterRpc(String masterRpc) {
        this.masterRpc = masterRpc;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public void setTid(TreeSet<String> tid) {
        this.tid = tid;
    }

    public TubeMQSource(String masterRpc, String topic, String groupId, String sessionKey, TreeSet<String> tid) {
        this.masterRpc = masterRpc;
        this.topic = topic;
        this.groupId = groupId;
        this.sessionKey = sessionKey;
        this.tid = tid;
    }

    @Override
    public String toString() {
        return "TubeMQSource(super=" + super.toString() + ", masterRpc=" + this.getMasterRpc() + ", topic=" + this.getTopic() + ", groupId=" + this.getGroupId() + ", sessionKey=" + this.getSessionKey() + ", tid=" + this.getTid() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TubeMQSource)) {
            return false;
        }
        TubeMQSource other = (TubeMQSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$masterRpc = this.getMasterRpc();
        String other$masterRpc = other.getMasterRpc();
        if (this$masterRpc == null ? other$masterRpc != null : !this$masterRpc.equals(other$masterRpc)) {
            return false;
        }
        String this$topic = this.getTopic();
        String other$topic = other.getTopic();
        if (this$topic == null ? other$topic != null : !this$topic.equals(other$topic)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$sessionKey = this.getSessionKey();
        String other$sessionKey = other.getSessionKey();
        if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
            return false;
        }
        TreeSet<String> this$tid = this.getTid();
        TreeSet<String> other$tid = other.getTid();
        return !(this$tid == null ? other$tid != null : !((Object)this$tid).equals(other$tid));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TubeMQSource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $masterRpc = this.getMasterRpc();
        result = result * 59 + ($masterRpc == null ? 43 : $masterRpc.hashCode());
        String $topic = this.getTopic();
        result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $sessionKey = this.getSessionKey();
        result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
        TreeSet<String> $tid = this.getTid();
        result = result * 59 + ($tid == null ? 43 : ((Object)$tid).hashCode());
        return result;
    }

    private static final class TubeMQSourceBuilderImpl
    extends TubeMQSourceBuilder<TubeMQSource, TubeMQSourceBuilderImpl> {
        private TubeMQSourceBuilderImpl() {
        }

        @Override
        protected TubeMQSourceBuilderImpl self() {
            return this;
        }

        @Override
        public TubeMQSource build() {
            return new TubeMQSource(this);
        }
    }

    public static abstract class TubeMQSourceBuilder<C extends TubeMQSource, B extends TubeMQSourceBuilder<C, B>>
    extends StreamSource.StreamSourceBuilder<C, B> {
        private String masterRpc;
        private String topic;
        private String groupId;
        private String sessionKey;
        private TreeSet<String> tid;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B masterRpc(String masterRpc) {
            this.masterRpc = masterRpc;
            return (B)this.self();
        }

        public B topic(String topic) {
            this.topic = topic;
            return (B)this.self();
        }

        public B groupId(String groupId) {
            this.groupId = groupId;
            return (B)this.self();
        }

        public B sessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
            return (B)this.self();
        }

        public B tid(TreeSet<String> tid) {
            this.tid = tid;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "TubeMQSource.TubeMQSourceBuilder(super=" + super.toString() + ", masterRpc=" + this.masterRpc + ", topic=" + this.topic + ", groupId=" + this.groupId + ", sessionKey=" + this.sessionKey + ", tid=" + this.tid + ")";
        }
    }
}

