/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.util;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.inlong.manager.common.enums.TransformType;
import org.apache.inlong.manager.pojo.sort.util.FieldInfoUtils;
import org.apache.inlong.manager.pojo.sort.util.FieldRelationUtils;
import org.apache.inlong.manager.pojo.sort.util.FilterFunctionUtils;
import org.apache.inlong.manager.pojo.sort.util.StreamParseUtils;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.transform.TransformDefinition;
import org.apache.inlong.manager.pojo.transform.TransformResponse;
import org.apache.inlong.manager.pojo.transform.deduplication.DeDuplicationDefinition;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.transform.DistinctNode;
import org.apache.inlong.sort.protocol.node.transform.TransformNode;
import org.apache.inlong.sort.protocol.transformation.OrderDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformNodeUtils {
    private static final Logger log = LoggerFactory.getLogger(TransformNodeUtils.class);

    public static List<TransformNode> createTransformNodes(List<TransformResponse> transformResponses, Map<String, StreamField> constantFieldMap) {
        if (CollectionUtils.isEmpty(transformResponses)) {
            return Lists.newArrayList();
        }
        return transformResponses.stream().map(s -> TransformNodeUtils.createTransformNode(s, constantFieldMap)).collect(Collectors.toList());
    }

    public static TransformNode createTransformNode(TransformResponse transformResponse, Map<String, StreamField> constantFieldMap) {
        TransformType transformType = TransformType.forType((String)transformResponse.getTransformType());
        if (transformType == TransformType.DE_DUPLICATION) {
            TransformDefinition transformDefinition = StreamParseUtils.parseTransformDefinition(transformResponse.getTransformDefinition(), transformType);
            return TransformNodeUtils.createDistinctNode((DeDuplicationDefinition)transformDefinition, transformResponse, constantFieldMap);
        }
        return TransformNodeUtils.createNormalTransformNode(transformResponse, constantFieldMap);
    }

    public static DistinctNode createDistinctNode(DeDuplicationDefinition deDuplicationDefinition, TransformResponse transformResponse, Map<String, StreamField> constantFieldMap) {
        OrderDirection orderDirection;
        List<StreamField> streamFields = deDuplicationDefinition.getDupFields();
        List distinctFields = streamFields.stream().map(FieldInfoUtils::parseStreamField).collect(Collectors.toList());
        StreamField timingField = deDuplicationDefinition.getTimingField();
        FieldInfo orderField = FieldInfoUtils.parseStreamField(timingField);
        DeDuplicationDefinition.DeDuplicationStrategy deDuplicationStrategy = deDuplicationDefinition.getDeDuplicationStrategy();
        switch (deDuplicationStrategy) {
            case RESERVE_LAST: {
                orderDirection = OrderDirection.DESC;
                break;
            }
            case RESERVE_FIRST: {
                orderDirection = OrderDirection.ASC;
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported deduplication strategy=%s for inlong", new Object[]{deDuplicationStrategy}));
            }
        }
        TransformNode transformNode = TransformNodeUtils.createNormalTransformNode(transformResponse, constantFieldMap);
        return new DistinctNode(transformNode.getId(), transformNode.getName(), transformNode.getFields(), transformNode.getFieldRelations(), transformNode.getFilters(), transformNode.getFilterStrategy(), distinctFields, orderField, orderDirection);
    }

    public static TransformNode createNormalTransformNode(TransformResponse transformResponse, Map<String, StreamField> constantFieldMap) {
        TransformNode transformNode = new TransformNode();
        transformNode.setId(transformResponse.getTransformName());
        transformNode.setName(transformResponse.getTransformName());
        List fieldInfos = transformResponse.getFieldList().stream().filter(s -> s.getFieldValue() != null).map(FieldInfoUtils::parseStreamField).collect(Collectors.toList());
        transformNode.setFields(fieldInfos);
        transformNode.setFieldRelations(FieldRelationUtils.createFieldRelations(transformResponse, constantFieldMap));
        transformNode.setFilters(FilterFunctionUtils.createFilterFunctions(transformResponse));
        transformNode.setFilterStrategy(FilterFunctionUtils.parseFilterStrategy(transformResponse));
        return transformNode;
    }
}

