/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.format.Format;
import org.apache.inlong.sort.protocol.node.load.StarRocksLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class StarRocksProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "STARROCKS".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        StarRocksSink starRocksSink = (StarRocksSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(starRocksSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(starRocksSink.getSinkFieldList(), starRocksSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(starRocksSink.getSinkFieldList(), constantFieldMap);
        Format format = this.parsingSinkMultipleFormat(starRocksSink.getSinkMultipleEnable(), starRocksSink.getSinkMultipleFormat());
        return new StarRocksLoadNode(starRocksSink.getSinkName(), starRocksSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, starRocksSink.getJdbcUrl(), starRocksSink.getLoadUrl(), starRocksSink.getUsername(), starRocksSink.getPassword(), starRocksSink.getDatabaseName(), starRocksSink.getTableName(), starRocksSink.getPrimaryKey(), starRocksSink.getSinkMultipleEnable(), format, starRocksSink.getDatabasePattern(), starRocksSink.getTablePattern());
    }
}

