/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sort.node.provider;

import java.util.List;
import java.util.Map;
import org.apache.inlong.manager.pojo.sink.iceberg.IcebergSink;
import org.apache.inlong.manager.pojo.sort.node.base.LoadNodeProvider;
import org.apache.inlong.manager.pojo.stream.StreamField;
import org.apache.inlong.manager.pojo.stream.StreamNode;
import org.apache.inlong.sort.protocol.FieldInfo;
import org.apache.inlong.sort.protocol.constant.IcebergConstant;
import org.apache.inlong.sort.protocol.node.LoadNode;
import org.apache.inlong.sort.protocol.node.load.IcebergLoadNode;
import org.apache.inlong.sort.protocol.transformation.FieldRelation;

public class IcebergProvider
implements LoadNodeProvider {
    @Override
    public Boolean accept(String sinkType) {
        return "ICEBERG".equals(sinkType);
    }

    @Override
    public LoadNode createLoadNode(StreamNode nodeInfo, Map<String, StreamField> constantFieldMap) {
        IcebergSink icebergSink = (IcebergSink)nodeInfo;
        Map<String, String> properties = this.parseProperties(icebergSink.getProperties());
        List<FieldInfo> fieldInfos = this.parseSinkFieldInfos(icebergSink.getSinkFieldList(), icebergSink.getSinkName());
        List<FieldRelation> fieldRelations = this.parseSinkFields(icebergSink.getSinkFieldList(), constantFieldMap);
        IcebergConstant.CatalogType catalogType = IcebergConstant.CatalogType.forName((String)icebergSink.getCatalogType());
        return new IcebergLoadNode(icebergSink.getSinkName(), icebergSink.getSinkName(), fieldInfos, fieldRelations, null, null, null, properties, icebergSink.getDbName(), icebergSink.getTableName(), icebergSink.getPrimaryKey(), catalogType, icebergSink.getCatalogUri(), icebergSink.getWarehouse());
    }
}

