/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.starrocks;

import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksColumnInfo;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksSinkRequest;
import org.apache.inlong.manager.pojo.sink.starrocks.StarRocksTableInfo;

public class StarRocksSinkDTO {
    @ApiModelProperty(value="StarRocks jdbc url")
    private String jdbcUrl;
    @ApiModelProperty(value="StarRocks FE http address")
    private String loadUrl;
    @ApiModelProperty(value="Username for StarRocks accessing")
    private String username;
    @ApiModelProperty(value="Password for StarRocks accessing")
    private String password;
    @ApiModelProperty(value="Database name")
    private String databaseName;
    @ApiModelProperty(value="Table name")
    private String tableName;
    @ApiModelProperty(value="The primary key of sink table")
    private String primaryKey;
    @ApiModelProperty(value="The multiple enable of sink")
    private Boolean sinkMultipleEnable = false;
    @ApiModelProperty(value="The multiple format of sink")
    private String sinkMultipleFormat;
    @ApiModelProperty(value="The multiple database-pattern of sink")
    private String databasePattern;
    @ApiModelProperty(value="The multiple table-pattern of sink")
    private String tablePattern;
    @ApiModelProperty(value="The table engine,  like: OLAP, MYSQL, ELASTICSEARCH, etc, default is OLAP")
    private String tableEngine = "OLAP";
    @ApiModelProperty(value="The table replication num")
    private Integer replicationNum = 3;
    @ApiModelProperty(value="The table barrel size")
    private Integer barrelSize = 8;
    @ApiModelProperty(value="Password encrypt version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Properties for StarRocks")
    private Map<String, Object> properties;

    public static StarRocksSinkDTO getFromRequest(StarRocksSinkRequest request, String extParams) throws Exception {
        Integer encryptVersion = AESUtils.getCurrentVersion(null);
        String passwd = null;
        if (StringUtils.isNotEmpty((CharSequence)request.getPassword())) {
            passwd = AESUtils.encryptToString((byte[])request.getPassword().getBytes(StandardCharsets.UTF_8), (Integer)encryptVersion);
        }
        StarRocksSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? StarRocksSinkDTO.getFromJson(extParams) : new StarRocksSinkDTO();
        CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
        dto.setPassword(passwd);
        return dto;
    }

    public static StarRocksSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return ((StarRocksSinkDTO)Objects.requireNonNull(JsonUtils.parseObject((String)extParams, StarRocksSinkDTO.class))).decryptPassword();
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of StarRocks SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static StarRocksTableInfo getTableInfo(StarRocksSinkDTO sinkDTO, List<StarRocksColumnInfo> columnList) {
        StarRocksTableInfo tableInfo = new StarRocksTableInfo();
        tableInfo.setDbName(sinkDTO.getDatabaseName());
        tableInfo.setTableName(sinkDTO.getTableName());
        tableInfo.setColumns(columnList);
        tableInfo.setPrimaryKey(sinkDTO.getPrimaryKey());
        tableInfo.setTableEngine(sinkDTO.getTableEngine());
        tableInfo.setReplicationNum(sinkDTO.getReplicationNum());
        tableInfo.setBarrelSize(sinkDTO.getBarrelSize());
        return tableInfo;
    }

    private StarRocksSinkDTO decryptPassword() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            byte[] passwordBytes = AESUtils.decryptAsString((String)this.password, (Integer)this.encryptVersion);
            this.password = new String(passwordBytes, StandardCharsets.UTF_8);
        }
        return this;
    }

    public static StarRocksSinkDTOBuilder builder() {
        return new StarRocksSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getLoadUrl() {
        return this.loadUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Boolean getSinkMultipleEnable() {
        return this.sinkMultipleEnable;
    }

    public String getSinkMultipleFormat() {
        return this.sinkMultipleFormat;
    }

    public String getDatabasePattern() {
        return this.databasePattern;
    }

    public String getTablePattern() {
        return this.tablePattern;
    }

    public String getTableEngine() {
        return this.tableEngine;
    }

    public Integer getReplicationNum() {
        return this.replicationNum;
    }

    public Integer getBarrelSize() {
        return this.barrelSize;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setLoadUrl(String loadUrl) {
        this.loadUrl = loadUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setSinkMultipleEnable(Boolean sinkMultipleEnable) {
        this.sinkMultipleEnable = sinkMultipleEnable;
    }

    public void setSinkMultipleFormat(String sinkMultipleFormat) {
        this.sinkMultipleFormat = sinkMultipleFormat;
    }

    public void setDatabasePattern(String databasePattern) {
        this.databasePattern = databasePattern;
    }

    public void setTablePattern(String tablePattern) {
        this.tablePattern = tablePattern;
    }

    public void setTableEngine(String tableEngine) {
        this.tableEngine = tableEngine;
    }

    public void setReplicationNum(Integer replicationNum) {
        this.replicationNum = replicationNum;
    }

    public void setBarrelSize(Integer barrelSize) {
        this.barrelSize = barrelSize;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StarRocksSinkDTO)) {
            return false;
        }
        StarRocksSinkDTO other = (StarRocksSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$sinkMultipleEnable = this.getSinkMultipleEnable();
        Boolean other$sinkMultipleEnable = other.getSinkMultipleEnable();
        if (this$sinkMultipleEnable == null ? other$sinkMultipleEnable != null : !((Object)this$sinkMultipleEnable).equals(other$sinkMultipleEnable)) {
            return false;
        }
        Integer this$replicationNum = this.getReplicationNum();
        Integer other$replicationNum = other.getReplicationNum();
        if (this$replicationNum == null ? other$replicationNum != null : !((Object)this$replicationNum).equals(other$replicationNum)) {
            return false;
        }
        Integer this$barrelSize = this.getBarrelSize();
        Integer other$barrelSize = other.getBarrelSize();
        if (this$barrelSize == null ? other$barrelSize != null : !((Object)this$barrelSize).equals(other$barrelSize)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$loadUrl = this.getLoadUrl();
        String other$loadUrl = other.getLoadUrl();
        if (this$loadUrl == null ? other$loadUrl != null : !this$loadUrl.equals(other$loadUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        String this$sinkMultipleFormat = this.getSinkMultipleFormat();
        String other$sinkMultipleFormat = other.getSinkMultipleFormat();
        if (this$sinkMultipleFormat == null ? other$sinkMultipleFormat != null : !this$sinkMultipleFormat.equals(other$sinkMultipleFormat)) {
            return false;
        }
        String this$databasePattern = this.getDatabasePattern();
        String other$databasePattern = other.getDatabasePattern();
        if (this$databasePattern == null ? other$databasePattern != null : !this$databasePattern.equals(other$databasePattern)) {
            return false;
        }
        String this$tablePattern = this.getTablePattern();
        String other$tablePattern = other.getTablePattern();
        if (this$tablePattern == null ? other$tablePattern != null : !this$tablePattern.equals(other$tablePattern)) {
            return false;
        }
        String this$tableEngine = this.getTableEngine();
        String other$tableEngine = other.getTableEngine();
        if (this$tableEngine == null ? other$tableEngine != null : !this$tableEngine.equals(other$tableEngine)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StarRocksSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $sinkMultipleEnable = this.getSinkMultipleEnable();
        result = result * 59 + ($sinkMultipleEnable == null ? 43 : ((Object)$sinkMultipleEnable).hashCode());
        Integer $replicationNum = this.getReplicationNum();
        result = result * 59 + ($replicationNum == null ? 43 : ((Object)$replicationNum).hashCode());
        Integer $barrelSize = this.getBarrelSize();
        result = result * 59 + ($barrelSize == null ? 43 : ((Object)$barrelSize).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $loadUrl = this.getLoadUrl();
        result = result * 59 + ($loadUrl == null ? 43 : $loadUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        String $sinkMultipleFormat = this.getSinkMultipleFormat();
        result = result * 59 + ($sinkMultipleFormat == null ? 43 : $sinkMultipleFormat.hashCode());
        String $databasePattern = this.getDatabasePattern();
        result = result * 59 + ($databasePattern == null ? 43 : $databasePattern.hashCode());
        String $tablePattern = this.getTablePattern();
        result = result * 59 + ($tablePattern == null ? 43 : $tablePattern.hashCode());
        String $tableEngine = this.getTableEngine();
        result = result * 59 + ($tableEngine == null ? 43 : $tableEngine.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "StarRocksSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", loadUrl=" + this.getLoadUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", sinkMultipleEnable=" + this.getSinkMultipleEnable() + ", sinkMultipleFormat=" + this.getSinkMultipleFormat() + ", databasePattern=" + this.getDatabasePattern() + ", tablePattern=" + this.getTablePattern() + ", tableEngine=" + this.getTableEngine() + ", replicationNum=" + this.getReplicationNum() + ", barrelSize=" + this.getBarrelSize() + ", encryptVersion=" + this.getEncryptVersion() + ", properties=" + this.getProperties() + ")";
    }

    public StarRocksSinkDTO() {
    }

    public StarRocksSinkDTO(String jdbcUrl, String loadUrl, String username, String password, String databaseName, String tableName, String primaryKey, Boolean sinkMultipleEnable, String sinkMultipleFormat, String databasePattern, String tablePattern, String tableEngine, Integer replicationNum, Integer barrelSize, Integer encryptVersion, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.loadUrl = loadUrl;
        this.username = username;
        this.password = password;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.sinkMultipleEnable = sinkMultipleEnable;
        this.sinkMultipleFormat = sinkMultipleFormat;
        this.databasePattern = databasePattern;
        this.tablePattern = tablePattern;
        this.tableEngine = tableEngine;
        this.replicationNum = replicationNum;
        this.barrelSize = barrelSize;
        this.encryptVersion = encryptVersion;
        this.properties = properties;
    }

    public static class StarRocksSinkDTOBuilder {
        private String jdbcUrl;
        private String loadUrl;
        private String username;
        private String password;
        private String databaseName;
        private String tableName;
        private String primaryKey;
        private Boolean sinkMultipleEnable;
        private String sinkMultipleFormat;
        private String databasePattern;
        private String tablePattern;
        private String tableEngine;
        private Integer replicationNum;
        private Integer barrelSize;
        private Integer encryptVersion;
        private Map<String, Object> properties;

        StarRocksSinkDTOBuilder() {
        }

        public StarRocksSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public StarRocksSinkDTOBuilder loadUrl(String loadUrl) {
            this.loadUrl = loadUrl;
            return this;
        }

        public StarRocksSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public StarRocksSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public StarRocksSinkDTOBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public StarRocksSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public StarRocksSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public StarRocksSinkDTOBuilder sinkMultipleEnable(Boolean sinkMultipleEnable) {
            this.sinkMultipleEnable = sinkMultipleEnable;
            return this;
        }

        public StarRocksSinkDTOBuilder sinkMultipleFormat(String sinkMultipleFormat) {
            this.sinkMultipleFormat = sinkMultipleFormat;
            return this;
        }

        public StarRocksSinkDTOBuilder databasePattern(String databasePattern) {
            this.databasePattern = databasePattern;
            return this;
        }

        public StarRocksSinkDTOBuilder tablePattern(String tablePattern) {
            this.tablePattern = tablePattern;
            return this;
        }

        public StarRocksSinkDTOBuilder tableEngine(String tableEngine) {
            this.tableEngine = tableEngine;
            return this;
        }

        public StarRocksSinkDTOBuilder replicationNum(Integer replicationNum) {
            this.replicationNum = replicationNum;
            return this;
        }

        public StarRocksSinkDTOBuilder barrelSize(Integer barrelSize) {
            this.barrelSize = barrelSize;
            return this;
        }

        public StarRocksSinkDTOBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public StarRocksSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public StarRocksSinkDTO build() {
            return new StarRocksSinkDTO(this.jdbcUrl, this.loadUrl, this.username, this.password, this.databaseName, this.tableName, this.primaryKey, this.sinkMultipleEnable, this.sinkMultipleFormat, this.databasePattern, this.tablePattern, this.tableEngine, this.replicationNum, this.barrelSize, this.encryptVersion, this.properties);
        }

        public String toString() {
            return "StarRocksSinkDTO.StarRocksSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", loadUrl=" + this.loadUrl + ", username=" + this.username + ", password=" + this.password + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", sinkMultipleEnable=" + this.sinkMultipleEnable + ", sinkMultipleFormat=" + this.sinkMultipleFormat + ", databasePattern=" + this.databasePattern + ", tablePattern=" + this.tablePattern + ", tableEngine=" + this.tableEngine + ", replicationNum=" + this.replicationNum + ", barrelSize=" + this.barrelSize + ", encryptVersion=" + this.encryptVersion + ", properties=" + this.properties + ")";
        }
    }
}

