/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.mysql;

import com.google.common.base.Strings;
import io.swagger.annotations.ApiModelProperty;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLColumnInfo;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLSinkRequest;
import org.apache.inlong.manager.pojo.sink.mysql.MySQLTableInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLSinkDTO {
    private static final Map<String, String> SENSITIVE_REPLACE_PARAM_MAP = new HashMap<String, String>(){
        {
            this.put("autoDeserialize", "false");
            this.put("allowLoadLocalInfile", "false");
            this.put("allowUrlInLocalInfile", "false");
        }
    };
    private static final Set<String> SENSITIVE_REMOVE_PARAM_MAP = new HashSet<String>(){
        {
            this.add("allowLoadLocalInfileInPath");
        }
    };
    private static final Logger LOGGER = LoggerFactory.getLogger(MySQLSinkDTO.class);
    private static final String MYSQL_JDBC_PREFIX = "jdbc:mysql://";
    @ApiModelProperty(value="MySQL JDBC URL, such as jdbc:mysql://host:port")
    private String jdbcUrl;
    @ApiModelProperty(value="Username for JDBC URL")
    private String username;
    @ApiModelProperty(value="User password")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String databaseName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Primary key")
    private String primaryKey;
    @ApiModelProperty(value="Properties for MySQL")
    private Map<String, Object> properties;

    public static MySQLSinkDTO getFromRequest(MySQLSinkRequest request, String extParams) {
        MySQLSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? MySQLSinkDTO.getFromJson(extParams) : new MySQLSinkDTO();
        CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
        dto.setJdbcUrl(MySQLSinkDTO.filterSensitive(request.getJdbcUrl()));
        return dto;
    }

    public static MySQLSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return (MySQLSinkDTO)JsonUtils.parseObject((String)extParams, MySQLSinkDTO.class);
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of MySQL SinkDTO failure: %s", e.getMessage()));
        }
    }

    public static MySQLTableInfo getTableInfo(MySQLSinkDTO mySQLSink, List<MySQLColumnInfo> columnList) {
        MySQLTableInfo tableInfo = new MySQLTableInfo();
        tableInfo.setDbName(mySQLSink.getDatabaseName());
        tableInfo.setTableName(mySQLSink.getTableName());
        tableInfo.setPrimaryKey(mySQLSink.getPrimaryKey());
        tableInfo.setColumns(columnList);
        return tableInfo;
    }

    private static String getDbNameFromUrl(String jdbcUrl) {
        int pos1;
        String database = null;
        if (Strings.isNullOrEmpty((String)jdbcUrl)) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        if ((jdbcUrl = jdbcUrl.toLowerCase()).startsWith("jdbc:impala")) {
            jdbcUrl = jdbcUrl.replace(":impala", "");
        }
        if (!jdbcUrl.startsWith("jdbc:") || (pos1 = jdbcUrl.indexOf(58, 5)) == -1) {
            throw new IllegalArgumentException("Invalid JDBC url.");
        }
        String connUri = jdbcUrl.substring(pos1 + 1);
        if (connUri.startsWith("//")) {
            int pos = connUri.indexOf(47, 2);
            if (pos != -1) {
                database = connUri.substring(pos + 1);
            }
        } else {
            database = connUri;
        }
        if (Strings.isNullOrEmpty((String)database)) {
            throw new IllegalArgumentException("Invalid JDBC URL: " + jdbcUrl);
        }
        if (database.contains("?")) {
            database = database.substring(0, database.indexOf("?"));
        }
        if (database.contains(";")) {
            database = database.substring(0, database.indexOf(";"));
        }
        return database;
    }

    public static String setDbNameToUrl(String jdbcUrl, String databaseName) {
        if (StringUtils.isBlank((CharSequence)jdbcUrl)) {
            return jdbcUrl;
        }
        String pattern = "jdbc:mysql://(?<host>[a-zA-Z0-9-//.]+):(?<port>[0-9]+)?(?<ext>)";
        Pattern namePattern = Pattern.compile(pattern);
        Matcher dataMatcher = namePattern.matcher(jdbcUrl);
        if (!dataMatcher.find()) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, "MySQL JDBC URL was invalid, it should like jdbc:mysql://host:port");
        }
        String host = dataMatcher.group("host");
        String port = dataMatcher.group("port");
        StringBuilder resultUrl = new StringBuilder().append(MYSQL_JDBC_PREFIX).append(host).append(":").append(port).append("/").append(databaseName);
        if (jdbcUrl.contains("?")) {
            resultUrl.append(jdbcUrl.substring(jdbcUrl.indexOf("?")));
        }
        return resultUrl.toString();
    }

    public static String filterSensitive(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        try {
            String resultUrl = url;
            while (resultUrl.contains("%")) {
                resultUrl = URLDecoder.decode(resultUrl, "UTF-8");
            }
            if ((resultUrl = resultUrl.replaceAll(" ", "")).contains("?")) {
                StringBuilder builder = new StringBuilder();
                builder.append(StringUtils.substringBefore((String)resultUrl, (String)"?"));
                builder.append("?");
                ArrayList<String> paramList = new ArrayList<String>();
                String queryString = StringUtils.substringAfter((String)resultUrl, (String)"?");
                for (String param : queryString.split("&")) {
                    String key = StringUtils.substringBefore((String)param, (String)"=");
                    String value = StringUtils.substringAfter((String)param, (String)"=");
                    if (SENSITIVE_REMOVE_PARAM_MAP.contains(key)) continue;
                    if (SENSITIVE_REPLACE_PARAM_MAP.containsKey(key)) {
                        value = SENSITIVE_REPLACE_PARAM_MAP.get(key);
                    }
                    paramList.add(key + "=" + value);
                }
                String params = StringUtils.join(paramList, (String)"&");
                builder.append(params);
                resultUrl = builder.toString();
            }
            LOGGER.info("the origin url [{}] was replaced to: [{}]", (Object)url, (Object)resultUrl);
            return resultUrl;
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, ErrorCodeEnum.SINK_INFO_INCORRECT.getMessage() + ": " + e.getMessage());
        }
    }

    public static MySQLSinkDTOBuilder builder() {
        return new MySQLSinkDTOBuilder();
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MySQLSinkDTO)) {
            return false;
        }
        MySQLSinkDTO other = (MySQLSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$databaseName = this.getDatabaseName();
        String other$databaseName = other.getDatabaseName();
        if (this$databaseName == null ? other$databaseName != null : !this$databaseName.equals(other$databaseName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MySQLSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $databaseName = this.getDatabaseName();
        result = result * 59 + ($databaseName == null ? 43 : $databaseName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "MySQLSinkDTO(jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", databaseName=" + this.getDatabaseName() + ", tableName=" + this.getTableName() + ", primaryKey=" + this.getPrimaryKey() + ", properties=" + this.getProperties() + ")";
    }

    public MySQLSinkDTO() {
    }

    public MySQLSinkDTO(String jdbcUrl, String username, String password, String databaseName, String tableName, String primaryKey, Map<String, Object> properties) {
        this.jdbcUrl = jdbcUrl;
        this.username = username;
        this.password = password;
        this.databaseName = databaseName;
        this.tableName = tableName;
        this.primaryKey = primaryKey;
        this.properties = properties;
    }

    public static class MySQLSinkDTOBuilder {
        private String jdbcUrl;
        private String username;
        private String password;
        private String databaseName;
        private String tableName;
        private String primaryKey;
        private Map<String, Object> properties;

        MySQLSinkDTOBuilder() {
        }

        public MySQLSinkDTOBuilder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public MySQLSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MySQLSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public MySQLSinkDTOBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public MySQLSinkDTOBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public MySQLSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public MySQLSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public MySQLSinkDTO build() {
            return new MySQLSinkDTO(this.jdbcUrl, this.username, this.password, this.databaseName, this.tableName, this.primaryKey, this.properties);
        }

        public String toString() {
            return "MySQLSinkDTO.MySQLSinkDTOBuilder(jdbcUrl=" + this.jdbcUrl + ", username=" + this.username + ", password=" + this.password + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ", primaryKey=" + this.primaryKey + ", properties=" + this.properties + ")";
        }
    }
}

