/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.es;

import io.swagger.annotations.ApiModelProperty;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.manager.common.enums.ErrorCodeEnum;
import org.apache.inlong.manager.common.exceptions.BusinessException;
import org.apache.inlong.manager.common.util.AESUtils;
import org.apache.inlong.manager.common.util.CommonBeanUtils;
import org.apache.inlong.manager.common.util.JsonUtils;
import org.apache.inlong.manager.pojo.sink.es.ElasticsearchSinkRequest;

public class ElasticsearchSinkDTO {
    @ApiModelProperty(value="Host of the Elasticsearch server")
    private String hosts;
    @ApiModelProperty(value="Username of the Elasticsearch server")
    private String username;
    @ApiModelProperty(value="User password of the Elasticsearch server")
    private String password;
    @ApiModelProperty(value="Elasticsearch index name")
    private String indexName;
    @ApiModelProperty(value="Flush interval, unit: second, default is 1s")
    private Integer flushInterval;
    @ApiModelProperty(value="Flush when record number reaches flushRecord")
    private Integer flushRecord;
    @ApiModelProperty(value="Write max retry times, default is 3")
    private Integer retryTimes;
    @ApiModelProperty(value="Key field names, separate with commas")
    private String keyFieldNames;
    @ApiModelProperty(value="Document Type")
    private String documentType;
    @ApiModelProperty(value="Primary Key")
    private String primaryKey;
    @ApiModelProperty(value="Elasticsearch version")
    private Integer esVersion;
    @ApiModelProperty(value="Password encrypt version")
    private Integer encryptVersion;
    @ApiModelProperty(value="Properties for elasticsearch")
    private Map<String, Object> properties;

    public static ElasticsearchSinkDTO getFromRequest(ElasticsearchSinkRequest request, String extParams) {
        ElasticsearchSinkDTO dto = StringUtils.isNotBlank((CharSequence)extParams) ? ElasticsearchSinkDTO.getFromJson(extParams) : new ElasticsearchSinkDTO();
        return (ElasticsearchSinkDTO)CommonBeanUtils.copyProperties((Object)request, (Object)dto, (boolean)true);
    }

    public static ElasticsearchSinkDTO getFromJson(@NotNull String extParams) {
        try {
            return ((ElasticsearchSinkDTO)JsonUtils.parseObject((String)extParams, ElasticsearchSinkDTO.class)).decryptPassword();
        }
        catch (Exception e) {
            throw new BusinessException(ErrorCodeEnum.SINK_INFO_INCORRECT, String.format("parse extParams of Elasticsearch SinkDTO failure: %s", e.getMessage()));
        }
    }

    private ElasticsearchSinkDTO decryptPassword() throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)this.password)) {
            byte[] passwordBytes = AESUtils.decryptAsString((String)this.password, (Integer)this.encryptVersion);
            this.password = new String(passwordBytes, StandardCharsets.UTF_8);
        }
        return this;
    }

    public static ElasticsearchSinkDTOBuilder builder() {
        return new ElasticsearchSinkDTOBuilder();
    }

    public String getHosts() {
        return this.hosts;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public Integer getFlushInterval() {
        return this.flushInterval;
    }

    public Integer getFlushRecord() {
        return this.flushRecord;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public String getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public String getDocumentType() {
        return this.documentType;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public Integer getEsVersion() {
        return this.esVersion;
    }

    public Integer getEncryptVersion() {
        return this.encryptVersion;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setFlushInterval(Integer flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushRecord(Integer flushRecord) {
        this.flushRecord = flushRecord;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setKeyFieldNames(String keyFieldNames) {
        this.keyFieldNames = keyFieldNames;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public void setEsVersion(Integer esVersion) {
        this.esVersion = esVersion;
    }

    public void setEncryptVersion(Integer encryptVersion) {
        this.encryptVersion = encryptVersion;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ElasticsearchSinkDTO)) {
            return false;
        }
        ElasticsearchSinkDTO other = (ElasticsearchSinkDTO)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$flushInterval = this.getFlushInterval();
        Integer other$flushInterval = other.getFlushInterval();
        if (this$flushInterval == null ? other$flushInterval != null : !((Object)this$flushInterval).equals(other$flushInterval)) {
            return false;
        }
        Integer this$flushRecord = this.getFlushRecord();
        Integer other$flushRecord = other.getFlushRecord();
        if (this$flushRecord == null ? other$flushRecord != null : !((Object)this$flushRecord).equals(other$flushRecord)) {
            return false;
        }
        Integer this$retryTimes = this.getRetryTimes();
        Integer other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        Integer this$esVersion = this.getEsVersion();
        Integer other$esVersion = other.getEsVersion();
        if (this$esVersion == null ? other$esVersion != null : !((Object)this$esVersion).equals(other$esVersion)) {
            return false;
        }
        Integer this$encryptVersion = this.getEncryptVersion();
        Integer other$encryptVersion = other.getEncryptVersion();
        if (this$encryptVersion == null ? other$encryptVersion != null : !((Object)this$encryptVersion).equals(other$encryptVersion)) {
            return false;
        }
        String this$hosts = this.getHosts();
        String other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$indexName = this.getIndexName();
        String other$indexName = other.getIndexName();
        if (this$indexName == null ? other$indexName != null : !this$indexName.equals(other$indexName)) {
            return false;
        }
        String this$keyFieldNames = this.getKeyFieldNames();
        String other$keyFieldNames = other.getKeyFieldNames();
        if (this$keyFieldNames == null ? other$keyFieldNames != null : !this$keyFieldNames.equals(other$keyFieldNames)) {
            return false;
        }
        String this$documentType = this.getDocumentType();
        String other$documentType = other.getDocumentType();
        if (this$documentType == null ? other$documentType != null : !this$documentType.equals(other$documentType)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        if (this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey)) {
            return false;
        }
        Map<String, Object> this$properties = this.getProperties();
        Map<String, Object> other$properties = other.getProperties();
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ElasticsearchSinkDTO;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $flushInterval = this.getFlushInterval();
        result = result * 59 + ($flushInterval == null ? 43 : ((Object)$flushInterval).hashCode());
        Integer $flushRecord = this.getFlushRecord();
        result = result * 59 + ($flushRecord == null ? 43 : ((Object)$flushRecord).hashCode());
        Integer $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        Integer $esVersion = this.getEsVersion();
        result = result * 59 + ($esVersion == null ? 43 : ((Object)$esVersion).hashCode());
        Integer $encryptVersion = this.getEncryptVersion();
        result = result * 59 + ($encryptVersion == null ? 43 : ((Object)$encryptVersion).hashCode());
        String $hosts = this.getHosts();
        result = result * 59 + ($hosts == null ? 43 : $hosts.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $indexName = this.getIndexName();
        result = result * 59 + ($indexName == null ? 43 : $indexName.hashCode());
        String $keyFieldNames = this.getKeyFieldNames();
        result = result * 59 + ($keyFieldNames == null ? 43 : $keyFieldNames.hashCode());
        String $documentType = this.getDocumentType();
        result = result * 59 + ($documentType == null ? 43 : $documentType.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        Map<String, Object> $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }

    public String toString() {
        return "ElasticsearchSinkDTO(hosts=" + this.getHosts() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", indexName=" + this.getIndexName() + ", flushInterval=" + this.getFlushInterval() + ", flushRecord=" + this.getFlushRecord() + ", retryTimes=" + this.getRetryTimes() + ", keyFieldNames=" + this.getKeyFieldNames() + ", documentType=" + this.getDocumentType() + ", primaryKey=" + this.getPrimaryKey() + ", esVersion=" + this.getEsVersion() + ", encryptVersion=" + this.getEncryptVersion() + ", properties=" + this.getProperties() + ")";
    }

    public ElasticsearchSinkDTO() {
    }

    public ElasticsearchSinkDTO(String hosts, String username, String password, String indexName, Integer flushInterval, Integer flushRecord, Integer retryTimes, String keyFieldNames, String documentType, String primaryKey, Integer esVersion, Integer encryptVersion, Map<String, Object> properties) {
        this.hosts = hosts;
        this.username = username;
        this.password = password;
        this.indexName = indexName;
        this.flushInterval = flushInterval;
        this.flushRecord = flushRecord;
        this.retryTimes = retryTimes;
        this.keyFieldNames = keyFieldNames;
        this.documentType = documentType;
        this.primaryKey = primaryKey;
        this.esVersion = esVersion;
        this.encryptVersion = encryptVersion;
        this.properties = properties;
    }

    public static class ElasticsearchSinkDTOBuilder {
        private String hosts;
        private String username;
        private String password;
        private String indexName;
        private Integer flushInterval;
        private Integer flushRecord;
        private Integer retryTimes;
        private String keyFieldNames;
        private String documentType;
        private String primaryKey;
        private Integer esVersion;
        private Integer encryptVersion;
        private Map<String, Object> properties;

        ElasticsearchSinkDTOBuilder() {
        }

        public ElasticsearchSinkDTOBuilder hosts(String hosts) {
            this.hosts = hosts;
            return this;
        }

        public ElasticsearchSinkDTOBuilder username(String username) {
            this.username = username;
            return this;
        }

        public ElasticsearchSinkDTOBuilder password(String password) {
            this.password = password;
            return this;
        }

        public ElasticsearchSinkDTOBuilder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        public ElasticsearchSinkDTOBuilder flushInterval(Integer flushInterval) {
            this.flushInterval = flushInterval;
            return this;
        }

        public ElasticsearchSinkDTOBuilder flushRecord(Integer flushRecord) {
            this.flushRecord = flushRecord;
            return this;
        }

        public ElasticsearchSinkDTOBuilder retryTimes(Integer retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public ElasticsearchSinkDTOBuilder keyFieldNames(String keyFieldNames) {
            this.keyFieldNames = keyFieldNames;
            return this;
        }

        public ElasticsearchSinkDTOBuilder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        public ElasticsearchSinkDTOBuilder primaryKey(String primaryKey) {
            this.primaryKey = primaryKey;
            return this;
        }

        public ElasticsearchSinkDTOBuilder esVersion(Integer esVersion) {
            this.esVersion = esVersion;
            return this;
        }

        public ElasticsearchSinkDTOBuilder encryptVersion(Integer encryptVersion) {
            this.encryptVersion = encryptVersion;
            return this;
        }

        public ElasticsearchSinkDTOBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public ElasticsearchSinkDTO build() {
            return new ElasticsearchSinkDTO(this.hosts, this.username, this.password, this.indexName, this.flushInterval, this.flushRecord, this.retryTimes, this.keyFieldNames, this.documentType, this.primaryKey, this.esVersion, this.encryptVersion, this.properties);
        }

        public String toString() {
            return "ElasticsearchSinkDTO.ElasticsearchSinkDTOBuilder(hosts=" + this.hosts + ", username=" + this.username + ", password=" + this.password + ", indexName=" + this.indexName + ", flushInterval=" + this.flushInterval + ", flushRecord=" + this.flushRecord + ", retryTimes=" + this.retryTimes + ", keyFieldNames=" + this.keyFieldNames + ", documentType=" + this.documentType + ", primaryKey=" + this.primaryKey + ", esVersion=" + this.esVersion + ", encryptVersion=" + this.encryptVersion + ", properties=" + this.properties + ")";
        }
    }
}

