/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.sink.ck;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.Pattern;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.sink.SinkRequest;

@ApiModel(value="ClickHouse sink request")
@JsonTypeDefine(value="CLICKHOUSE")
public class ClickHouseSinkRequest
extends SinkRequest {
    @ApiModelProperty(value="JDBC URL of the ClickHouse server")
    @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url")
    private @Pattern(regexp="^((?!\\s).)*$", message="not supports blank in url") String jdbcUrl;
    @ApiModelProperty(value="Username of the ClickHouse server")
    private String username;
    @ApiModelProperty(value="User password of the ClickHouse server")
    private String password;
    @ApiModelProperty(value="Target database name")
    private String dbName;
    @ApiModelProperty(value="Target table name")
    private String tableName;
    @ApiModelProperty(value="Flush interval, unit: second, default is 1s")
    private Integer flushInterval = 1;
    @ApiModelProperty(value="Flush when record number reaches flushRecord")
    private Integer flushRecord;
    @ApiModelProperty(value="Write max retry times, default is 3")
    private Integer retryTimes = 3;
    @ApiModelProperty(value="Whether distributed table? 0: no, 1: yes")
    private Integer isDistributed;
    @ApiModelProperty(value="Partition strategy, support: BALANCE, RANDOM, HASH")
    private String partitionStrategy;
    @ApiModelProperty(value="Partition files, separate with commas", notes="Necessary when partitionStrategy is HASH, must be one of the field list")
    private String partitionFields;
    @ApiModelProperty(value="Key field names, separate with commas")
    private String keyFieldNames;
    @ApiModelProperty(value="ClickHouse table engine, support MergeTree Mem and so on")
    private String engine;
    @ApiModelProperty(value="Table partition information")
    private String partitionBy;
    @ApiModelProperty(value="Table order information")
    private String orderBy;
    @ApiModelProperty(value="Message time-to-live duration")
    private Integer ttl;
    @ApiModelProperty(value="The unit of message's time-to-live duration")
    private String ttlUnit;
    @ApiModelProperty(value="The cluster is used to create distributed tables in each node")
    private String cluster;
    @ApiModelProperty(value="Table primary key")
    private String primaryKey;

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDbName() {
        return this.dbName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getFlushInterval() {
        return this.flushInterval;
    }

    public Integer getFlushRecord() {
        return this.flushRecord;
    }

    public Integer getRetryTimes() {
        return this.retryTimes;
    }

    public Integer getIsDistributed() {
        return this.isDistributed;
    }

    public String getPartitionStrategy() {
        return this.partitionStrategy;
    }

    public String getPartitionFields() {
        return this.partitionFields;
    }

    public String getKeyFieldNames() {
        return this.keyFieldNames;
    }

    public String getEngine() {
        return this.engine;
    }

    public String getPartitionBy() {
        return this.partitionBy;
    }

    public String getOrderBy() {
        return this.orderBy;
    }

    public Integer getTtl() {
        return this.ttl;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public String getCluster() {
        return this.cluster;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFlushInterval(Integer flushInterval) {
        this.flushInterval = flushInterval;
    }

    public void setFlushRecord(Integer flushRecord) {
        this.flushRecord = flushRecord;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setIsDistributed(Integer isDistributed) {
        this.isDistributed = isDistributed;
    }

    public void setPartitionStrategy(String partitionStrategy) {
        this.partitionStrategy = partitionStrategy;
    }

    public void setPartitionFields(String partitionFields) {
        this.partitionFields = partitionFields;
    }

    public void setKeyFieldNames(String keyFieldNames) {
        this.keyFieldNames = keyFieldNames;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public void setPartitionBy(String partitionBy) {
        this.partitionBy = partitionBy;
    }

    public void setOrderBy(String orderBy) {
        this.orderBy = orderBy;
    }

    public void setTtl(Integer ttl) {
        this.ttl = ttl;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    @Override
    public String toString() {
        return "ClickHouseSinkRequest(super=" + super.toString() + ", jdbcUrl=" + this.getJdbcUrl() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", dbName=" + this.getDbName() + ", tableName=" + this.getTableName() + ", flushInterval=" + this.getFlushInterval() + ", flushRecord=" + this.getFlushRecord() + ", retryTimes=" + this.getRetryTimes() + ", isDistributed=" + this.getIsDistributed() + ", partitionStrategy=" + this.getPartitionStrategy() + ", partitionFields=" + this.getPartitionFields() + ", keyFieldNames=" + this.getKeyFieldNames() + ", engine=" + this.getEngine() + ", partitionBy=" + this.getPartitionBy() + ", orderBy=" + this.getOrderBy() + ", ttl=" + this.getTtl() + ", ttlUnit=" + this.getTtlUnit() + ", cluster=" + this.getCluster() + ", primaryKey=" + this.getPrimaryKey() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClickHouseSinkRequest)) {
            return false;
        }
        ClickHouseSinkRequest other = (ClickHouseSinkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$flushInterval = this.getFlushInterval();
        Integer other$flushInterval = other.getFlushInterval();
        if (this$flushInterval == null ? other$flushInterval != null : !((Object)this$flushInterval).equals(other$flushInterval)) {
            return false;
        }
        Integer this$flushRecord = this.getFlushRecord();
        Integer other$flushRecord = other.getFlushRecord();
        if (this$flushRecord == null ? other$flushRecord != null : !((Object)this$flushRecord).equals(other$flushRecord)) {
            return false;
        }
        Integer this$retryTimes = this.getRetryTimes();
        Integer other$retryTimes = other.getRetryTimes();
        if (this$retryTimes == null ? other$retryTimes != null : !((Object)this$retryTimes).equals(other$retryTimes)) {
            return false;
        }
        Integer this$isDistributed = this.getIsDistributed();
        Integer other$isDistributed = other.getIsDistributed();
        if (this$isDistributed == null ? other$isDistributed != null : !((Object)this$isDistributed).equals(other$isDistributed)) {
            return false;
        }
        Integer this$ttl = this.getTtl();
        Integer other$ttl = other.getTtl();
        if (this$ttl == null ? other$ttl != null : !((Object)this$ttl).equals(other$ttl)) {
            return false;
        }
        String this$jdbcUrl = this.getJdbcUrl();
        String other$jdbcUrl = other.getJdbcUrl();
        if (this$jdbcUrl == null ? other$jdbcUrl != null : !this$jdbcUrl.equals(other$jdbcUrl)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$dbName = this.getDbName();
        String other$dbName = other.getDbName();
        if (this$dbName == null ? other$dbName != null : !this$dbName.equals(other$dbName)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$partitionStrategy = this.getPartitionStrategy();
        String other$partitionStrategy = other.getPartitionStrategy();
        if (this$partitionStrategy == null ? other$partitionStrategy != null : !this$partitionStrategy.equals(other$partitionStrategy)) {
            return false;
        }
        String this$partitionFields = this.getPartitionFields();
        String other$partitionFields = other.getPartitionFields();
        if (this$partitionFields == null ? other$partitionFields != null : !this$partitionFields.equals(other$partitionFields)) {
            return false;
        }
        String this$keyFieldNames = this.getKeyFieldNames();
        String other$keyFieldNames = other.getKeyFieldNames();
        if (this$keyFieldNames == null ? other$keyFieldNames != null : !this$keyFieldNames.equals(other$keyFieldNames)) {
            return false;
        }
        String this$engine = this.getEngine();
        String other$engine = other.getEngine();
        if (this$engine == null ? other$engine != null : !this$engine.equals(other$engine)) {
            return false;
        }
        String this$partitionBy = this.getPartitionBy();
        String other$partitionBy = other.getPartitionBy();
        if (this$partitionBy == null ? other$partitionBy != null : !this$partitionBy.equals(other$partitionBy)) {
            return false;
        }
        String this$orderBy = this.getOrderBy();
        String other$orderBy = other.getOrderBy();
        if (this$orderBy == null ? other$orderBy != null : !this$orderBy.equals(other$orderBy)) {
            return false;
        }
        String this$ttlUnit = this.getTtlUnit();
        String other$ttlUnit = other.getTtlUnit();
        if (this$ttlUnit == null ? other$ttlUnit != null : !this$ttlUnit.equals(other$ttlUnit)) {
            return false;
        }
        String this$cluster = this.getCluster();
        String other$cluster = other.getCluster();
        if (this$cluster == null ? other$cluster != null : !this$cluster.equals(other$cluster)) {
            return false;
        }
        String this$primaryKey = this.getPrimaryKey();
        String other$primaryKey = other.getPrimaryKey();
        return !(this$primaryKey == null ? other$primaryKey != null : !this$primaryKey.equals(other$primaryKey));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ClickHouseSinkRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $flushInterval = this.getFlushInterval();
        result = result * 59 + ($flushInterval == null ? 43 : ((Object)$flushInterval).hashCode());
        Integer $flushRecord = this.getFlushRecord();
        result = result * 59 + ($flushRecord == null ? 43 : ((Object)$flushRecord).hashCode());
        Integer $retryTimes = this.getRetryTimes();
        result = result * 59 + ($retryTimes == null ? 43 : ((Object)$retryTimes).hashCode());
        Integer $isDistributed = this.getIsDistributed();
        result = result * 59 + ($isDistributed == null ? 43 : ((Object)$isDistributed).hashCode());
        Integer $ttl = this.getTtl();
        result = result * 59 + ($ttl == null ? 43 : ((Object)$ttl).hashCode());
        String $jdbcUrl = this.getJdbcUrl();
        result = result * 59 + ($jdbcUrl == null ? 43 : $jdbcUrl.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $dbName = this.getDbName();
        result = result * 59 + ($dbName == null ? 43 : $dbName.hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $partitionStrategy = this.getPartitionStrategy();
        result = result * 59 + ($partitionStrategy == null ? 43 : $partitionStrategy.hashCode());
        String $partitionFields = this.getPartitionFields();
        result = result * 59 + ($partitionFields == null ? 43 : $partitionFields.hashCode());
        String $keyFieldNames = this.getKeyFieldNames();
        result = result * 59 + ($keyFieldNames == null ? 43 : $keyFieldNames.hashCode());
        String $engine = this.getEngine();
        result = result * 59 + ($engine == null ? 43 : $engine.hashCode());
        String $partitionBy = this.getPartitionBy();
        result = result * 59 + ($partitionBy == null ? 43 : $partitionBy.hashCode());
        String $orderBy = this.getOrderBy();
        result = result * 59 + ($orderBy == null ? 43 : $orderBy.hashCode());
        String $ttlUnit = this.getTtlUnit();
        result = result * 59 + ($ttlUnit == null ? 43 : $ttlUnit.hashCode());
        String $cluster = this.getCluster();
        result = result * 59 + ($cluster == null ? 43 : $cluster.hashCode());
        String $primaryKey = this.getPrimaryKey();
        result = result * 59 + ($primaryKey == null ? 43 : $primaryKey.hashCode());
        return result;
    }
}

