/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group.pulsar;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import org.apache.inlong.manager.common.util.JsonTypeDefine;
import org.apache.inlong.manager.pojo.group.InlongGroupTopicInfo;

@JsonTypeDefine(value="PULSAR")
@ApiModel(value="Inlong pulsar group topic info")
public class InlongPulsarTopicInfo
extends InlongGroupTopicInfo {
    @ApiModelProperty(value="Pulsar tenant")
    private String tenant;
    @ApiModelProperty(value="Pulsar namespace")
    private String namespace;
    @ApiModelProperty(value="Pulsar topics")
    private List<String> topics;

    public InlongPulsarTopicInfo() {
        this.setMqType("PULSAR");
    }

    public static InlongPulsarTopicInfoBuilder builder() {
        return new InlongPulsarTopicInfoBuilder();
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    @Override
    public String toString() {
        return "InlongPulsarTopicInfo(tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", topics=" + this.getTopics() + ")";
    }

    public InlongPulsarTopicInfo(String tenant, String namespace, List<String> topics) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.topics = topics;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongPulsarTopicInfo)) {
            return false;
        }
        InlongPulsarTopicInfo other = (InlongPulsarTopicInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        List<String> this$topics = this.getTopics();
        List<String> other$topics = other.getTopics();
        return !(this$topics == null ? other$topics != null : !((Object)this$topics).equals(other$topics));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongPulsarTopicInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        List<String> $topics = this.getTopics();
        result = result * 59 + ($topics == null ? 43 : ((Object)$topics).hashCode());
        return result;
    }

    public static class InlongPulsarTopicInfoBuilder {
        private String tenant;
        private String namespace;
        private List<String> topics;

        InlongPulsarTopicInfoBuilder() {
        }

        public InlongPulsarTopicInfoBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public InlongPulsarTopicInfoBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public InlongPulsarTopicInfoBuilder topics(List<String> topics) {
            this.topics = topics;
            return this;
        }

        public InlongPulsarTopicInfo build() {
            return new InlongPulsarTopicInfo(this.tenant, this.namespace, this.topics);
        }

        public String toString() {
            return "InlongPulsarTopicInfo.InlongPulsarTopicInfoBuilder(tenant=" + this.tenant + ", namespace=" + this.namespace + ", topics=" + this.topics + ")";
        }
    }
}

