/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.pojo.group;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.List;
import org.apache.inlong.manager.common.auth.Authentication;
import org.apache.inlong.manager.pojo.group.BaseInlongGroup;
import org.apache.inlong.manager.pojo.group.InlongGroupExtInfo;
import org.apache.inlong.manager.pojo.group.InlongGroupRequest;
import org.apache.inlong.manager.pojo.sort.BaseSortConf;

@ApiModel(value="Inlong group info")
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, visible=true, property="mqType")
public abstract class InlongGroupInfo
extends BaseInlongGroup {
    @ApiModelProperty(value="Primary key")
    private Integer id;
    @ApiModelProperty(value="Inlong group id")
    private String inlongGroupId;
    @ApiModelProperty(value="Inlong group name")
    private String name;
    @ApiModelProperty(value="Inlong group description")
    private String description;
    @Deprecated
    @ApiModelProperty(value="MQ type, replaced by mqType")
    private String middlewareType;
    @ApiModelProperty(value="MQ type, high throughput: TUBEMQ, high consistency: PULSAR")
    private String mqType;
    @ApiModelProperty(value="MQ resource", notes="in inlong group, TubeMQ corresponds to Topic, Pulsar corresponds to Namespace")
    private String mqResource;
    @ApiModelProperty(value="Whether to enable zookeeper? 0: disable, 1: enable")
    private Integer enableZookeeper;
    @ApiModelProperty(value="Whether to enable create resource? 0: disable, 1: enable")
    private Integer enableCreateResource;
    @ApiModelProperty(value="Standard mode(include Data Ingestion and Synchronization): 0, DataSync mode(only Data Synchronization): 1")
    private Integer inlongGroupMode;
    @ApiModelProperty(value="Data report type, default is 0.\n 0: report to DataProxy and respond when the DataProxy received data.\n 1: report to DataProxy and respond after DataProxy sends data.\n 2: report to MQ and respond when the MQ received data.", notes="Current constraint is that all InLong Agents under one InlongGroup use the same type")
    private Integer dataReportType;
    @ApiModelProperty(value="Inlong cluster tag, which links to inlong_cluster table")
    private String inlongClusterTag;
    @ApiModelProperty(value="Number of access items per day, unit: 10,000 items per day")
    private Integer dailyRecords;
    @ApiModelProperty(value="Access size per day, unit: GB per day")
    private Integer dailyStorage;
    @ApiModelProperty(value="peak access per second, unit: bars per second")
    private Integer peakRecords;
    @ApiModelProperty(value="The maximum length of a single piece of data, unit: Byte")
    private Integer maxLength;
    @ApiModelProperty(value="Name of responsible person, separated by commas")
    private String inCharges;
    @ApiModelProperty(value="Name of followers, separated by commas")
    private String followers;
    @ApiModelProperty(value="Status")
    private Integer status;
    @ApiModelProperty(value="Previous status")
    private Integer previousStatus;
    @ApiModelProperty(value="Name of creator")
    private String creator;
    @ApiModelProperty(value="Name of modifier")
    private String modifier;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date createTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private Date modifyTime;
    @ApiModelProperty(value="Inlong group Extension properties")
    private List<InlongGroupExtInfo> extList;
    @JsonIgnore
    @ApiModelProperty(value="Authentication info, will transfer into extList")
    private Authentication authentication;
    @ApiModelProperty(value="Sort configuration, will transfer into extList")
    private BaseSortConf sortConf;
    @ApiModelProperty(value="Version number")
    private Integer version;

    public abstract InlongGroupRequest genRequest();

    public Integer getId() {
        return this.id;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    @Deprecated
    public String getMiddlewareType() {
        return this.middlewareType;
    }

    public String getMqType() {
        return this.mqType;
    }

    public String getMqResource() {
        return this.mqResource;
    }

    public Integer getEnableZookeeper() {
        return this.enableZookeeper;
    }

    public Integer getEnableCreateResource() {
        return this.enableCreateResource;
    }

    public Integer getInlongGroupMode() {
        return this.inlongGroupMode;
    }

    public Integer getDataReportType() {
        return this.dataReportType;
    }

    public String getInlongClusterTag() {
        return this.inlongClusterTag;
    }

    public Integer getDailyRecords() {
        return this.dailyRecords;
    }

    public Integer getDailyStorage() {
        return this.dailyStorage;
    }

    public Integer getPeakRecords() {
        return this.peakRecords;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public String getInCharges() {
        return this.inCharges;
    }

    public String getFollowers() {
        return this.followers;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Integer getPreviousStatus() {
        return this.previousStatus;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getModifier() {
        return this.modifier;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public List<InlongGroupExtInfo> getExtList() {
        return this.extList;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public BaseSortConf getSortConf() {
        return this.sortConf;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setInlongGroupId(String inlongGroupId) {
        this.inlongGroupId = inlongGroupId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Deprecated
    public void setMiddlewareType(String middlewareType) {
        this.middlewareType = middlewareType;
    }

    public void setMqType(String mqType) {
        this.mqType = mqType;
    }

    public void setMqResource(String mqResource) {
        this.mqResource = mqResource;
    }

    public void setEnableZookeeper(Integer enableZookeeper) {
        this.enableZookeeper = enableZookeeper;
    }

    public void setEnableCreateResource(Integer enableCreateResource) {
        this.enableCreateResource = enableCreateResource;
    }

    public void setInlongGroupMode(Integer inlongGroupMode) {
        this.inlongGroupMode = inlongGroupMode;
    }

    public void setDataReportType(Integer dataReportType) {
        this.dataReportType = dataReportType;
    }

    public void setInlongClusterTag(String inlongClusterTag) {
        this.inlongClusterTag = inlongClusterTag;
    }

    public void setDailyRecords(Integer dailyRecords) {
        this.dailyRecords = dailyRecords;
    }

    public void setDailyStorage(Integer dailyStorage) {
        this.dailyStorage = dailyStorage;
    }

    public void setPeakRecords(Integer peakRecords) {
        this.peakRecords = peakRecords;
    }

    public void setMaxLength(Integer maxLength) {
        this.maxLength = maxLength;
    }

    public void setInCharges(String inCharges) {
        this.inCharges = inCharges;
    }

    public void setFollowers(String followers) {
        this.followers = followers;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setPreviousStatus(Integer previousStatus) {
        this.previousStatus = previousStatus;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setExtList(List<InlongGroupExtInfo> extList) {
        this.extList = extList;
    }

    @JsonIgnore
    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setSortConf(BaseSortConf sortConf) {
        this.sortConf = sortConf;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    @Override
    public String toString() {
        return "InlongGroupInfo(id=" + this.getId() + ", inlongGroupId=" + this.getInlongGroupId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", middlewareType=" + this.getMiddlewareType() + ", mqType=" + this.getMqType() + ", mqResource=" + this.getMqResource() + ", enableZookeeper=" + this.getEnableZookeeper() + ", enableCreateResource=" + this.getEnableCreateResource() + ", inlongGroupMode=" + this.getInlongGroupMode() + ", dataReportType=" + this.getDataReportType() + ", inlongClusterTag=" + this.getInlongClusterTag() + ", dailyRecords=" + this.getDailyRecords() + ", dailyStorage=" + this.getDailyStorage() + ", peakRecords=" + this.getPeakRecords() + ", maxLength=" + this.getMaxLength() + ", inCharges=" + this.getInCharges() + ", followers=" + this.getFollowers() + ", status=" + this.getStatus() + ", previousStatus=" + this.getPreviousStatus() + ", creator=" + this.getCreator() + ", modifier=" + this.getModifier() + ", createTime=" + this.getCreateTime() + ", modifyTime=" + this.getModifyTime() + ", extList=" + this.getExtList() + ", authentication=" + this.getAuthentication() + ", sortConf=" + this.getSortConf() + ", version=" + this.getVersion() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlongGroupInfo)) {
            return false;
        }
        InlongGroupInfo other = (InlongGroupInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$id = this.getId();
        Integer other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Integer this$enableZookeeper = this.getEnableZookeeper();
        Integer other$enableZookeeper = other.getEnableZookeeper();
        if (this$enableZookeeper == null ? other$enableZookeeper != null : !((Object)this$enableZookeeper).equals(other$enableZookeeper)) {
            return false;
        }
        Integer this$enableCreateResource = this.getEnableCreateResource();
        Integer other$enableCreateResource = other.getEnableCreateResource();
        if (this$enableCreateResource == null ? other$enableCreateResource != null : !((Object)this$enableCreateResource).equals(other$enableCreateResource)) {
            return false;
        }
        Integer this$inlongGroupMode = this.getInlongGroupMode();
        Integer other$inlongGroupMode = other.getInlongGroupMode();
        if (this$inlongGroupMode == null ? other$inlongGroupMode != null : !((Object)this$inlongGroupMode).equals(other$inlongGroupMode)) {
            return false;
        }
        Integer this$dataReportType = this.getDataReportType();
        Integer other$dataReportType = other.getDataReportType();
        if (this$dataReportType == null ? other$dataReportType != null : !((Object)this$dataReportType).equals(other$dataReportType)) {
            return false;
        }
        Integer this$dailyRecords = this.getDailyRecords();
        Integer other$dailyRecords = other.getDailyRecords();
        if (this$dailyRecords == null ? other$dailyRecords != null : !((Object)this$dailyRecords).equals(other$dailyRecords)) {
            return false;
        }
        Integer this$dailyStorage = this.getDailyStorage();
        Integer other$dailyStorage = other.getDailyStorage();
        if (this$dailyStorage == null ? other$dailyStorage != null : !((Object)this$dailyStorage).equals(other$dailyStorage)) {
            return false;
        }
        Integer this$peakRecords = this.getPeakRecords();
        Integer other$peakRecords = other.getPeakRecords();
        if (this$peakRecords == null ? other$peakRecords != null : !((Object)this$peakRecords).equals(other$peakRecords)) {
            return false;
        }
        Integer this$maxLength = this.getMaxLength();
        Integer other$maxLength = other.getMaxLength();
        if (this$maxLength == null ? other$maxLength != null : !((Object)this$maxLength).equals(other$maxLength)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        Integer this$previousStatus = this.getPreviousStatus();
        Integer other$previousStatus = other.getPreviousStatus();
        if (this$previousStatus == null ? other$previousStatus != null : !((Object)this$previousStatus).equals(other$previousStatus)) {
            return false;
        }
        Integer this$version = this.getVersion();
        Integer other$version = other.getVersion();
        if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
            return false;
        }
        String this$inlongGroupId = this.getInlongGroupId();
        String other$inlongGroupId = other.getInlongGroupId();
        if (this$inlongGroupId == null ? other$inlongGroupId != null : !this$inlongGroupId.equals(other$inlongGroupId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$middlewareType = this.getMiddlewareType();
        String other$middlewareType = other.getMiddlewareType();
        if (this$middlewareType == null ? other$middlewareType != null : !this$middlewareType.equals(other$middlewareType)) {
            return false;
        }
        String this$mqType = this.getMqType();
        String other$mqType = other.getMqType();
        if (this$mqType == null ? other$mqType != null : !this$mqType.equals(other$mqType)) {
            return false;
        }
        String this$mqResource = this.getMqResource();
        String other$mqResource = other.getMqResource();
        if (this$mqResource == null ? other$mqResource != null : !this$mqResource.equals(other$mqResource)) {
            return false;
        }
        String this$inlongClusterTag = this.getInlongClusterTag();
        String other$inlongClusterTag = other.getInlongClusterTag();
        if (this$inlongClusterTag == null ? other$inlongClusterTag != null : !this$inlongClusterTag.equals(other$inlongClusterTag)) {
            return false;
        }
        String this$inCharges = this.getInCharges();
        String other$inCharges = other.getInCharges();
        if (this$inCharges == null ? other$inCharges != null : !this$inCharges.equals(other$inCharges)) {
            return false;
        }
        String this$followers = this.getFollowers();
        String other$followers = other.getFollowers();
        if (this$followers == null ? other$followers != null : !this$followers.equals(other$followers)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$modifier = this.getModifier();
        String other$modifier = other.getModifier();
        if (this$modifier == null ? other$modifier != null : !this$modifier.equals(other$modifier)) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$modifyTime = this.getModifyTime();
        Date other$modifyTime = other.getModifyTime();
        if (this$modifyTime == null ? other$modifyTime != null : !((Object)this$modifyTime).equals(other$modifyTime)) {
            return false;
        }
        List<InlongGroupExtInfo> this$extList = this.getExtList();
        List<InlongGroupExtInfo> other$extList = other.getExtList();
        if (this$extList == null ? other$extList != null : !((Object)this$extList).equals(other$extList)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        BaseSortConf this$sortConf = this.getSortConf();
        BaseSortConf other$sortConf = other.getSortConf();
        return !(this$sortConf == null ? other$sortConf != null : !((Object)this$sortConf).equals(other$sortConf));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InlongGroupInfo;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Integer $enableZookeeper = this.getEnableZookeeper();
        result = result * 59 + ($enableZookeeper == null ? 43 : ((Object)$enableZookeeper).hashCode());
        Integer $enableCreateResource = this.getEnableCreateResource();
        result = result * 59 + ($enableCreateResource == null ? 43 : ((Object)$enableCreateResource).hashCode());
        Integer $inlongGroupMode = this.getInlongGroupMode();
        result = result * 59 + ($inlongGroupMode == null ? 43 : ((Object)$inlongGroupMode).hashCode());
        Integer $dataReportType = this.getDataReportType();
        result = result * 59 + ($dataReportType == null ? 43 : ((Object)$dataReportType).hashCode());
        Integer $dailyRecords = this.getDailyRecords();
        result = result * 59 + ($dailyRecords == null ? 43 : ((Object)$dailyRecords).hashCode());
        Integer $dailyStorage = this.getDailyStorage();
        result = result * 59 + ($dailyStorage == null ? 43 : ((Object)$dailyStorage).hashCode());
        Integer $peakRecords = this.getPeakRecords();
        result = result * 59 + ($peakRecords == null ? 43 : ((Object)$peakRecords).hashCode());
        Integer $maxLength = this.getMaxLength();
        result = result * 59 + ($maxLength == null ? 43 : ((Object)$maxLength).hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        Integer $previousStatus = this.getPreviousStatus();
        result = result * 59 + ($previousStatus == null ? 43 : ((Object)$previousStatus).hashCode());
        Integer $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
        String $inlongGroupId = this.getInlongGroupId();
        result = result * 59 + ($inlongGroupId == null ? 43 : $inlongGroupId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $middlewareType = this.getMiddlewareType();
        result = result * 59 + ($middlewareType == null ? 43 : $middlewareType.hashCode());
        String $mqType = this.getMqType();
        result = result * 59 + ($mqType == null ? 43 : $mqType.hashCode());
        String $mqResource = this.getMqResource();
        result = result * 59 + ($mqResource == null ? 43 : $mqResource.hashCode());
        String $inlongClusterTag = this.getInlongClusterTag();
        result = result * 59 + ($inlongClusterTag == null ? 43 : $inlongClusterTag.hashCode());
        String $inCharges = this.getInCharges();
        result = result * 59 + ($inCharges == null ? 43 : $inCharges.hashCode());
        String $followers = this.getFollowers();
        result = result * 59 + ($followers == null ? 43 : $followers.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $modifier = this.getModifier();
        result = result * 59 + ($modifier == null ? 43 : $modifier.hashCode());
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $modifyTime = this.getModifyTime();
        result = result * 59 + ($modifyTime == null ? 43 : ((Object)$modifyTime).hashCode());
        List<InlongGroupExtInfo> $extList = this.getExtList();
        result = result * 59 + ($extList == null ? 43 : ((Object)$extList).hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        BaseSortConf $sortConf = this.getSortConf();
        result = result * 59 + ($sortConf == null ? 43 : ((Object)$sortConf).hashCode());
        return result;
    }

    public InlongGroupInfo() {
    }

    public InlongGroupInfo(Integer id, String inlongGroupId, String name, String description, String middlewareType, String mqType, String mqResource, Integer enableZookeeper, Integer enableCreateResource, Integer inlongGroupMode, Integer dataReportType, String inlongClusterTag, Integer dailyRecords, Integer dailyStorage, Integer peakRecords, Integer maxLength, String inCharges, String followers, Integer status, Integer previousStatus, String creator, String modifier, Date createTime, Date modifyTime, List<InlongGroupExtInfo> extList, Authentication authentication, BaseSortConf sortConf, Integer version) {
        this.id = id;
        this.inlongGroupId = inlongGroupId;
        this.name = name;
        this.description = description;
        this.middlewareType = middlewareType;
        this.mqType = mqType;
        this.mqResource = mqResource;
        this.enableZookeeper = enableZookeeper;
        this.enableCreateResource = enableCreateResource;
        this.inlongGroupMode = inlongGroupMode;
        this.dataReportType = dataReportType;
        this.inlongClusterTag = inlongClusterTag;
        this.dailyRecords = dailyRecords;
        this.dailyStorage = dailyStorage;
        this.peakRecords = peakRecords;
        this.maxLength = maxLength;
        this.inCharges = inCharges;
        this.followers = followers;
        this.status = status;
        this.previousStatus = previousStatus;
        this.creator = creator;
        this.modifier = modifier;
        this.createTime = createTime;
        this.modifyTime = modifyTime;
        this.extList = extList;
        this.authentication = authentication;
        this.sortConf = sortConf;
        this.version = version;
    }
}

