/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import io.airlift.compress.zstd.ZStdRawCompressor;
import io.airlift.compress.zstd.ZStdRawDecompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.compress.zstd.ZstdDecompressor;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.common.allocator.PulsarByteBufAllocator;
import org.apache.pulsar.common.compression.AirliftUtils;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.concurrent.FastThreadLocal;

public class CompressionCodecZstd
implements CompressionCodec {
    private static final int ZSTD_COMPRESSION_LEVEL = 3;
    private static final ZstdCompressor ZSTD_COMPRESSOR = new ZstdCompressor();
    private static final FastThreadLocal<ZStdRawDecompressor> ZSTD_RAW_DECOMPRESSOR = new FastThreadLocal<ZStdRawDecompressor>(){

        @Override
        protected ZStdRawDecompressor initialValue() throws Exception {
            return new ZStdRawDecompressor();
        }
    };
    private static final FastThreadLocal<ZstdDecompressor> ZSTD_DECOMPRESSOR = new FastThreadLocal<ZstdDecompressor>(){

        @Override
        protected ZstdDecompressor initialValue() throws Exception {
            return new ZstdDecompressor();
        }
    };

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = ZSTD_COMPRESSOR.maxCompressedLength(uncompressedLength);
        ByteBuf target = PulsarByteBufAllocator.DEFAULT.buffer(maxLength, maxLength);
        if (source.hasMemoryAddress() && target.hasMemoryAddress()) {
            compressedLength = ZStdRawCompressor.compress(source.memoryAddress() + (long)source.readerIndex(), source.memoryAddress() + (long)source.writerIndex(), target.memoryAddress() + (long)target.writerIndex(), target.memoryAddress() + (long)target.writerIndex() + (long)maxLength, 3);
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            ZSTD_COMPRESSOR.compress(sourceNio, targetNio);
            compressedLength = targetNio.position();
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PulsarByteBufAllocator.DEFAULT.buffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress() && uncompressed.hasMemoryAddress()) {
            ZSTD_RAW_DECOMPRESSOR.get().decompress(null, encoded.memoryAddress() + (long)encoded.readerIndex(), encoded.memoryAddress() + (long)encoded.writerIndex(), null, uncompressed.memoryAddress() + (long)uncompressed.writerIndex(), uncompressed.memoryAddress() + (long)uncompressed.writerIndex() + (long)uncompressedLength);
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            encodedNio = AirliftUtils.ensureAirliftSupported(encodedNio);
            ZSTD_DECOMPRESSOR.get().decompress(encodedNio, uncompressedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

