/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import kafka.server.DelayedDeleteRecords;
import kafka.server.DelayedFetch;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedProduce;
import kafka.server.TopicPartitionOperationKey;
import kafka.server.TopicPartitionOperationKey$;
import org.apache.kafka.common.TopicPartition;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3A!\u0001\u0002\u0001\u000f\t\tB)\u001a7bs\u0016$w\n]3sCRLwN\\:\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\"Aq\u0002\u0001B\u0001B\u0003%\u0001#\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0011\u0005EIR\"\u0001\n\u000b\u0005M!\u0012AB2p[6|gN\u0003\u0002\u0006+)\u0011acF\u0001\u0007CB\f7\r[3\u000b\u0003a\t1a\u001c:h\u0013\tQ\"C\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\u0011q\u0001!\u0011!Q\u0001\nu\tq\u0001\u001d:pIV\u001cW\rE\u0002\u001fC\rj\u0011a\b\u0006\u0003A\u0011\taa]3sm\u0016\u0014\u0018B\u0001\u0012 \u0005e!U\r\\1zK\u0012|\u0005/\u001a:bi&|g\u000eU;sO\u0006$xN]=\u0011\u0005y!\u0013BA\u0013 \u00059!U\r\\1zK\u0012\u0004&o\u001c3vG\u0016D\u0001b\n\u0001\u0003\u0002\u0003\u0006I\u0001K\u0001\u0006M\u0016$8\r\u001b\t\u0004=\u0005J\u0003C\u0001\u0010+\u0013\tYsD\u0001\u0007EK2\f\u00170\u001a3GKR\u001c\u0007\u000e\u0003\u0005.\u0001\t\u0005\t\u0015!\u0003/\u00035!W\r\\3uKJ+7m\u001c:egB\u0019a$I\u0018\u0011\u0005y\u0001\u0014BA\u0019 \u0005Q!U\r\\1zK\u0012$U\r\\3uKJ+7m\u001c:eg\")1\u0007\u0001C\u0001i\u00051A(\u001b8jiz\"R!N\u001c9si\u0002\"A\u000e\u0001\u000e\u0003\tAQa\u0004\u001aA\u0002AAQ\u0001\b\u001aA\u0002uAQa\n\u001aA\u0002!BQ!\f\u001aA\u00029BQ\u0001\u0010\u0001\u0005\u0002u\n1c\u00195fG.\fe\u000eZ\"p[BdW\r^3BY2$\u0012A\u0010\t\u0003\u0013}J!\u0001\u0011\u0006\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0005\u0002!\t!P\u0001\u0016G\",7m[!oI\u000e{W\u000e\u001d7fi\u00164U\r^2i\u0011\u0015!\u0005\u0001\"\u0001>\u0003]\u0019\u0007.Z2l\u0003:$7i\\7qY\u0016$X\r\u0015:pIV\u001cW\rC\u0003G\u0001\u0011\u0005Q(A\u000fdQ\u0016\u001c7.\u00118e\u0007>l\u0007\u000f\\3uK\u0012+G.\u001a;f%\u0016\u001cwN\u001d3t\u0011\u0015A\u0005\u0001\"\u0001J\u0003AqW/\u001c#fY\u0006LX\r\u001a#fY\u0016$X-F\u0001K!\tI1*\u0003\u0002M\u0015\t\u0019\u0011J\u001c;\t\u000b9\u0003A\u0011A%\u0002\u001f9,X\u000eR3mCf,GMR3uG\"DQ\u0001\u0015\u0001\u0005\u0002%\u000b\u0011C\\;n\t\u0016d\u0017-_3e!J|G-^2f\u0001")
public class DelayedOperations {
    private final TopicPartition topicPartition;
    private final DelayedOperationPurgatory<DelayedProduce> produce;
    private final DelayedOperationPurgatory<DelayedFetch> fetch;
    private final DelayedOperationPurgatory<DelayedDeleteRecords> deleteRecords;

    public void checkAndCompleteAll() {
        TopicPartitionOperationKey requestKey = TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition);
        this.fetch.checkAndComplete(requestKey);
        this.produce.checkAndComplete(requestKey);
        this.deleteRecords.checkAndComplete(requestKey);
    }

    public void checkAndCompleteFetch() {
        this.fetch.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public void checkAndCompleteProduce() {
        this.produce.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public void checkAndCompleteDeleteRecords() {
        this.deleteRecords.checkAndComplete(TopicPartitionOperationKey$.MODULE$.apply(this.topicPartition));
    }

    public int numDelayedDelete() {
        return this.deleteRecords.numDelayed();
    }

    public int numDelayedFetch() {
        return this.fetch.numDelayed();
    }

    public int numDelayedProduce() {
        return this.produce.numDelayed();
    }

    public DelayedOperations(TopicPartition topicPartition, DelayedOperationPurgatory<DelayedProduce> produce, DelayedOperationPurgatory<DelayedFetch> fetch, DelayedOperationPurgatory<DelayedDeleteRecords> deleteRecords2) {
        this.topicPartition = topicPartition;
        this.produce = produce;
        this.fetch = fetch;
        this.deleteRecords = deleteRecords2;
    }
}

