/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file.encryption;

import com.google.common.base.Preconditions;
import java.util.Locale;
import org.apache.flume.Context;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.file.encryption.KeyProvider;
import org.apache.flume.channel.file.encryption.KeyProviderType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyProviderFactory {
    private static final Logger logger = LoggerFactory.getLogger(KeyProviderFactory.class);

    public static KeyProvider getInstance(String keyProviderType, Context context) {
        KeyProvider.Builder provider;
        KeyProviderType type;
        Preconditions.checkNotNull((Object)keyProviderType, (Object)"key provider type must not be null");
        try {
            type = KeyProviderType.valueOf(keyProviderType.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading provider class: {}", (Object)keyProviderType);
            type = KeyProviderType.OTHER;
        }
        Class<KeyProvider.Builder> providerClass = type.getBuilderClass();
        if (providerClass == null) {
            try {
                Class<?> c = Class.forName(keyProviderType);
                if (c == null || !KeyProvider.Builder.class.isAssignableFrom(c)) {
                    String errMessage = "Unable to instantiate Builder from " + keyProviderType;
                    logger.error(errMessage);
                    throw new FlumeException(errMessage);
                }
                providerClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + keyProviderType, (Throwable)ex);
                throw new FlumeException((Throwable)ex);
            }
        }
        try {
            provider = providerClass.newInstance();
        }
        catch (InstantiationException ex) {
            String errMessage = "Cannot instantiate builder: " + keyProviderType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            String errMessage = "Cannot instantiate builder: " + keyProviderType;
            logger.error(errMessage, (Throwable)ex);
            throw new FlumeException(errMessage, (Throwable)ex);
        }
        return provider.build(context);
    }
}

