/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.jcip.annotations.GuardedBy;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.ImmutableListCopy;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.IncrementableEntryVersion;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.transaction.xa.CacheTransaction;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheTransaction
implements CacheTransaction {
    protected final GlobalTransaction tx;
    private static final Log log = LogFactory.getLog(AbstractCacheTransaction.class);
    private static final int INITIAL_LOCK_CAPACITY = 4;
    volatile boolean hasLocalOnlyModifications;
    protected volatile List<WriteCommand> modifications;
    protected Map<Object, CacheEntry> lookedUpEntries;
    protected Set<Object> affectedKeys = null;
    private final AtomicReference<Set<Object>> lockedKeys = new AtomicReference();
    @GuardedBy(value="this")
    private Map<Object, CompletableFuture<Void>> backupKeyLocks;
    protected final int topologyId;
    private Map<Object, IncrementableEntryVersion> updatedEntryVersions;
    private Map<Object, IncrementableEntryVersion> versionsSeenMap;
    private volatile boolean isMarkedForRollback;
    private final long txCreationTime;
    private volatile Flag stateTransferFlag;
    private final CompletableFuture<Void> txCompleted;

    @Override
    public final boolean isMarkedForRollback() {
        return this.isMarkedForRollback;
    }

    @Override
    public void markForRollback(boolean markForRollback) {
        this.isMarkedForRollback = markForRollback;
    }

    public AbstractCacheTransaction(GlobalTransaction tx, int topologyId, long txCreationTime) {
        this.tx = tx;
        this.topologyId = topologyId;
        this.txCreationTime = txCreationTime;
        this.txCompleted = new CompletableFuture();
    }

    @Override
    public GlobalTransaction getGlobalTransaction() {
        return this.tx;
    }

    @Override
    public final List<WriteCommand> getModifications() {
        if (this.hasLocalOnlyModifications) {
            return this.modifications.stream().filter(cmd -> !cmd.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)).collect(Collectors.toList());
        }
        return this.getAllModifications();
    }

    @Override
    public final List<WriteCommand> getAllModifications() {
        if (this.modifications instanceof ImmutableListCopy) {
            return this.modifications;
        }
        if (this.modifications == null) {
            return Collections.emptyList();
        }
        return Immutables.immutableListCopy(this.modifications);
    }

    public final void setModifications(List<WriteCommand> modifications) {
        if (modifications == null) {
            throw new IllegalArgumentException("modification list cannot be null");
        }
        ArrayList<WriteCommand> mods = new ArrayList<WriteCommand>(modifications.size());
        for (WriteCommand cmd : modifications) {
            if (cmd.hasAnyFlag(FlagBitSets.CACHE_MODE_LOCAL)) {
                this.hasLocalOnlyModifications = true;
            }
            mods.add(cmd);
        }
        this.modifications = Collections.synchronizedList(mods);
    }

    @Override
    public final boolean hasModification(Class<?> modificationClass) {
        if (this.modifications != null) {
            for (WriteCommand mod : this.getModifications()) {
                if (!modificationClass.isAssignableFrom(mod.getClass())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void freezeModifications() {
        this.modifications = this.modifications != null ? Immutables.immutableListCopy(this.modifications) : Collections.emptyList();
    }

    @Override
    public Map<Object, CacheEntry> getLookedUpEntries() {
        return this.lookedUpEntries;
    }

    @Override
    public CacheEntry lookupEntry(Object key) {
        if (this.lookedUpEntries == null) {
            return null;
        }
        return this.lookedUpEntries.get(key);
    }

    @Override
    public void removeLookedUpEntry(Object key) {
        if (this.lookedUpEntries != null) {
            this.lookedUpEntries.remove(key);
        }
    }

    @Override
    public void clearLookedUpEntries() {
        this.lookedUpEntries = null;
    }

    @Override
    public boolean ownsLock(Object key) {
        Set<Object> keys = this.lockedKeys.get();
        return keys != null && keys.contains(key);
    }

    @Override
    public void notifyOnTransactionFinished() {
        if (log.isTraceEnabled()) {
            log.tracef("Transaction %s has completed, notifying listening threads.", this.tx);
        }
        if (!this.txCompleted.isDone()) {
            this.txCompleted.complete(null);
            this.cleanupBackupLocks();
        }
    }

    @Override
    public int getTopologyId() {
        return this.topologyId;
    }

    @Override
    public synchronized void addBackupLockForKey(Object key) {
        if (this.backupKeyLocks == null) {
            this.backupKeyLocks = new HashMap<Object, CompletableFuture<Void>>();
        }
        if (log.isTraceEnabled()) {
            log.tracef("Transaction %s added backup lock: %s", this.tx, Util.toStr((Object)key));
        }
        this.backupKeyLocks.put(key, new CompletableFuture());
    }

    public void registerLockedKey(Object key) {
        Set<Object> keys = this.lockedKeys.updateAndGet(value -> value == null ? Collections.synchronizedSet(new HashSet(4)) : value);
        if (log.isTraceEnabled()) {
            log.tracef("Transaction %s added lock: %s", this.tx, Util.toStr((Object)key));
        }
        keys.add(key);
    }

    @Override
    public Set<Object> getLockedKeys() {
        Set<Object> keys = this.lockedKeys.get();
        return keys == null ? Collections.emptySet() : keys;
    }

    public synchronized Set<Object> getBackupLockedKeys() {
        return this.backupKeyLocks == null ? Collections.emptySet() : new HashSet<Object>(this.backupKeyLocks.keySet());
    }

    @Override
    public void clearLockedKeys() {
        if (log.isTraceEnabled()) {
            log.tracef("Clearing locked keys: %s", Util.toStr((Collection)this.lockedKeys.get()));
        }
        this.lockedKeys.set(null);
    }

    public Set<Object> getAffectedKeys() {
        return this.affectedKeys == null ? Collections.emptySet() : this.affectedKeys;
    }

    public void addAffectedKey(Object key) {
        this.initAffectedKeys();
        this.affectedKeys.add(key);
    }

    public void addAllAffectedKeys(Collection<?> keys) {
        this.initAffectedKeys();
        this.affectedKeys.addAll(keys);
    }

    private void initAffectedKeys() {
        if (this.affectedKeys == null) {
            this.affectedKeys = new HashSet<Object>(4);
        }
    }

    @Override
    public Map<Object, IncrementableEntryVersion> getUpdatedEntryVersions() {
        return this.updatedEntryVersions;
    }

    @Override
    public void setUpdatedEntryVersions(Map<Object, IncrementableEntryVersion> updatedEntryVersions) {
        this.updatedEntryVersions = updatedEntryVersions;
    }

    @Override
    public void addVersionRead(Object key, EntryVersion version) {
        if (version == null) {
            return;
        }
        if (this.versionsSeenMap == null) {
            this.versionsSeenMap = new HashMap<Object, IncrementableEntryVersion>();
        }
        if (!this.versionsSeenMap.containsKey(key)) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction %s read %s with version %s", this.getGlobalTransaction().globalId(), key, version);
            }
            this.versionsSeenMap.put(key, (IncrementableEntryVersion)version);
        }
    }

    @Override
    public Map<Object, IncrementableEntryVersion> getVersionsRead() {
        return this.versionsSeenMap == null ? new HashMap() : this.versionsSeenMap;
    }

    public final boolean isFromStateTransfer() {
        return this.stateTransferFlag != null;
    }

    public final Flag getStateTransferFlag() {
        return this.stateTransferFlag;
    }

    public abstract void setStateTransferFlag(Flag var1);

    @Override
    public long getCreationTime() {
        return this.txCreationTime;
    }

    @Override
    public final void addListener(CacheTransaction.TransactionCompletedListener listener) {
        this.txCompleted.thenRun(listener::onCompletion);
    }

    @Override
    public CompletableFuture<Void> getReleaseFutureForKey(Object key) {
        if (this.getLockedKeys().contains(key)) {
            return this.txCompleted;
        }
        return this.findBackupLock(key);
    }

    @Override
    public Map<Object, CompletableFuture<Void>> getReleaseFutureForKeys(Collection<Object> keys) {
        Set<Object> locked = this.getLockedKeys();
        HashMap<Object, CompletableFuture<Void>> result = null;
        for (Object key : keys) {
            if (locked.contains(key)) {
                return Collections.singletonMap(key, this.txCompleted);
            }
            CompletableFuture<Void> cf = this.findBackupLock(key);
            if (cf == null) continue;
            if (result == null) {
                result = new HashMap<Object, CompletableFuture<Void>>();
            }
            result.put(key, cf);
        }
        return result == null ? Collections.emptyMap() : result;
    }

    @Override
    public synchronized void cleanupBackupLocks() {
        if (this.backupKeyLocks != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction %s removing all backup locks: %s", this.tx, Util.toStr(this.backupKeyLocks.keySet()));
            }
            for (CompletableFuture<Void> cf : this.backupKeyLocks.values()) {
                cf.complete(null);
            }
            this.backupKeyLocks.clear();
        }
    }

    @Override
    public synchronized void removeBackupLocks(Collection<?> keys) {
        if (this.backupKeyLocks != null) {
            for (Object key : keys) {
                CompletableFuture<Void> cf = this.backupKeyLocks.remove(key);
                if (cf == null) continue;
                if (log.isTraceEnabled()) {
                    log.tracef("Transaction %s removed backup lock: %s", this.tx, Util.toStr(key));
                }
                cf.complete(null);
            }
        }
    }

    @Override
    public synchronized void removeBackupLock(Object key) {
        CompletableFuture<Void> cf;
        if (this.backupKeyLocks != null && (cf = this.backupKeyLocks.remove(key)) != null) {
            if (log.isTraceEnabled()) {
                log.tracef("Transaction %s removed backup lock: %s", this.tx, Util.toStr((Object)key));
            }
            cf.complete(null);
        }
    }

    @Override
    public void forEachLock(Consumer<Object> consumer) {
        Set<Object> locked = this.lockedKeys.get();
        if (locked != null) {
            locked.forEach(consumer);
        }
    }

    @Override
    public synchronized void forEachBackupLock(Consumer<Object> consumer) {
        if (this.backupKeyLocks != null) {
            this.backupKeyLocks.keySet().forEach(consumer);
        }
    }

    protected final void checkIfRolledBack() {
        if (this.isMarkedForRollback()) {
            throw log.transactionAlreadyRolledBack(this.getGlobalTransaction());
        }
    }

    final void internalSetStateTransferFlag(Flag stateTransferFlag) {
        this.stateTransferFlag = stateTransferFlag;
    }

    private synchronized CompletableFuture<Void> findBackupLock(Object key) {
        return this.backupKeyLocks == null ? null : this.backupKeyLocks.get(key);
    }
}

