/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commons.util.logging.TraceException;
import org.infinispan.context.InvocationContext;
import org.infinispan.interceptors.ExceptionSyncInvocationStage;
import org.infinispan.interceptors.InvocationCallback;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.impl.QueueAsyncInvocationStage;
import org.infinispan.util.concurrent.CompletableFutures;

public class SimpleAsyncInvocationStage
extends InvocationStage {
    protected final CompletableFuture<Object> future;

    public SimpleAsyncInvocationStage(CompletionStage<?> future) {
        this.future = (CompletableFuture)future;
    }

    @Override
    public Object get() throws Throwable {
        try {
            return CompletableFutures.await(this.future);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            cause.addSuppressed((Throwable)new TraceException());
            throw cause;
        }
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public CompletableFuture<Object> toCompletableFuture() {
        return this.future;
    }

    @Override
    public <C extends VisitableCommand> Object addCallback(InvocationContext ctx, C command, InvocationCallback<C> function) {
        if (this.future.isDone()) {
            Throwable throwable;
            Object rv;
            try {
                rv = this.future.getNow(null);
                throwable = null;
            }
            catch (Throwable t) {
                rv = null;
                throwable = CompletableFutures.extractException(t);
            }
            try {
                return function.apply(ctx, command, rv, throwable);
            }
            catch (Throwable t) {
                return new ExceptionSyncInvocationStage(t);
            }
        }
        return new QueueAsyncInvocationStage(ctx, command, this.future, function);
    }

    @Override
    public Object thenReturn(InvocationContext ctx, VisitableCommand command, Object returnValue) {
        if (this.future.isDone()) {
            return this.future.isCompletedExceptionally() ? this : returnValue;
        }
        return new QueueAsyncInvocationStage(ctx, command, this.future, (rCtx, rCommand, rv) -> returnValue);
    }

    public String toString() {
        return "SimpleAsyncInvocationStage(" + this.future + ')';
    }
}

