/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.manager.controller.cluster;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.inlong.tubemq.manager.controller.TubeMQResult;
import org.apache.inlong.tubemq.manager.controller.cluster.dto.ClusterDto;
import org.apache.inlong.tubemq.manager.controller.cluster.request.AddClusterReq;
import org.apache.inlong.tubemq.manager.controller.cluster.request.DeleteClusterReq;
import org.apache.inlong.tubemq.manager.controller.cluster.request.SwitchClusterReq;
import org.apache.inlong.tubemq.manager.controller.cluster.vo.ClusterVo;
import org.apache.inlong.tubemq.manager.controller.group.result.ConsumerGroupInfoRes;
import org.apache.inlong.tubemq.manager.controller.group.result.ConsumerInfoRes;
import org.apache.inlong.tubemq.manager.controller.node.request.BaseReq;
import org.apache.inlong.tubemq.manager.controller.topic.result.TopicQueryRes;
import org.apache.inlong.tubemq.manager.controller.topic.result.TopicViewRes;
import org.apache.inlong.tubemq.manager.entry.ClusterEntry;
import org.apache.inlong.tubemq.manager.entry.MasterEntry;
import org.apache.inlong.tubemq.manager.service.TubeConst;
import org.apache.inlong.tubemq.manager.service.interfaces.ClusterService;
import org.apache.inlong.tubemq.manager.service.interfaces.MasterService;
import org.apache.inlong.tubemq.manager.utils.ConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/v1/cluster"})
public class ClusterController {
    private static final Logger log = LoggerFactory.getLogger(ClusterController.class);
    private final Gson gson = new Gson();
    private final TubeMQResult result = new TubeMQResult();
    @Autowired
    private ClusterService clusterService;
    @Autowired
    private MasterService masterService;

    @PostMapping(value={""})
    @ResponseBody
    public TubeMQResult clusterMethodProxy(@RequestParam String method, @RequestBody String req) {
        switch (method) {
            case "add": {
                return this.addNewCluster((AddClusterReq)this.gson.fromJson(req, AddClusterReq.class));
            }
            case "delete": {
                return this.deleteCluster((DeleteClusterReq)this.gson.fromJson(req, DeleteClusterReq.class));
            }
            case "modify": {
                return this.changeCluster((ClusterDto)this.gson.fromJson(req, ClusterDto.class));
            }
            case "switch": {
                return this.masterService.baseRequestMaster((BaseReq)this.gson.fromJson(req, SwitchClusterReq.class));
            }
        }
        return TubeMQResult.errorResult("no such method");
    }

    private TubeMQResult changeCluster(ClusterDto clusterDto) {
        if (!clusterDto.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        return this.clusterService.modifyCluster(clusterDto);
    }

    public TubeMQResult addNewCluster(AddClusterReq req) {
        if (!req.legal()) {
            return TubeMQResult.errorResult("param illegal");
        }
        List<MasterEntry> masterEntries = req.getMasterEntries();
        for (MasterEntry masterEntry : masterEntries) {
            TubeMQResult checkResult = this.masterService.checkMasterNodeStatus(masterEntry.getIp(), masterEntry.getWebPort());
            if (checkResult.getErrCode() == TubeConst.SUCCESS_CODE.intValue()) continue;
            return TubeMQResult.errorResult("please check master ip and webPort");
        }
        this.clusterService.addClusterAndMasterNode(req);
        return new TubeMQResult();
    }

    @RequestMapping(value={""}, method={RequestMethod.GET}, produces={"application/json"})
    public TubeMQResult queryCluster(@RequestParam(required=false) Integer clusterId, @RequestParam(required=false) String clusterName, @RequestParam(required=false) String masterIp) {
        TubeMQResult result = new TubeMQResult();
        if (clusterId == null && clusterName == null && masterIp == null) {
            return this.queryAllClusterVo();
        }
        if (clusterId != null) {
            ClusterEntry clusterEntry = this.clusterService.getOneCluster(clusterId.intValue());
            if (clusterEntry == null) {
                return TubeMQResult.errorResult("no such cluster with id " + clusterId);
            }
            List<MasterEntry> masterNodes = this.masterService.getMasterNodes(clusterEntry.getClusterId());
            ClusterVo allCount = this.getCountInCluster(clusterId);
            result.setData(Lists.newArrayList((Object[])new ClusterVo[]{ConvertUtils.convertToClusterVo(clusterEntry, masterNodes, allCount)}));
            return result;
        }
        if (clusterName != null) {
            result = this.queryClusterByClusterName(clusterName);
            return result;
        }
        if (masterIp != null) {
            result = this.queryClusterByMasterIp(masterIp);
            return result;
        }
        return result;
    }

    private TubeMQResult queryAllClusterVo() {
        TubeMQResult result = new TubeMQResult();
        List<ClusterEntry> allClusters = this.clusterService.getAllClusters();
        ArrayList clusterVos = Lists.newArrayList();
        for (ClusterEntry cluster : allClusters) {
            List<MasterEntry> masterNodes = this.masterService.getMasterNodes(cluster.getClusterId());
            ClusterVo allCount = this.getCountInCluster((int)cluster.getClusterId());
            ClusterVo clusterVo = ConvertUtils.convertToClusterVo(cluster, masterNodes, allCount);
            clusterVos.add(clusterVo);
        }
        result.setData(clusterVos);
        return result;
    }

    public TubeMQResult deleteCluster(DeleteClusterReq req) {
        if (req.getClusterId() == null || StringUtils.isEmpty((CharSequence)req.getToken())) {
            return TubeMQResult.errorResult("please input clusterId and token");
        }
        MasterEntry masterNode = this.masterService.getMasterNode(req.getClusterId());
        if (!req.getToken().equals(masterNode.getToken())) {
            return TubeMQResult.errorResult("please enter the correct token");
        }
        this.clusterService.deleteCluster(req.getClusterId());
        return new TubeMQResult();
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String queryInfo(@RequestParam Map<String, String> queryBody) throws Exception {
        String url = this.masterService.getQueryUrl(queryBody);
        return this.masterService.queryMaster(url);
    }

    public ClusterVo getCountInCluster(Integer clusterId) {
        ClusterVo clusterVo = new ClusterVo();
        int brokerSize = this.getBrokerSize(clusterId);
        ClusterVo countVo = this.getTopicAndPartitionCount(clusterId);
        int consumerGroupCount = this.getConsumerGroupCount(clusterId);
        int consumerCount = this.getConsumerCount(clusterId);
        int storeCount = this.getStoreCount(clusterId);
        clusterVo.setBrokerCount(brokerSize);
        clusterVo.setTopicCount(countVo.getTopicCount());
        clusterVo.setPartitionCount(countVo.getPartitionCount());
        clusterVo.setConsumerGroupCount(consumerGroupCount);
        clusterVo.setConsumerCount(consumerCount);
        clusterVo.setStoreCount(storeCount);
        return clusterVo;
    }

    public int getBrokerSize(Integer clusterId) {
        String queryUrl = this.masterService.getQueryCountUrl(clusterId, "/webapi.htm?type=op_query&method=admin_query_broker_run_status");
        String queryData = this.masterService.queryMaster(queryUrl);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(queryData, JsonObject.class);
        JsonElement count = jsonObject.get("count");
        return (Integer)this.gson.fromJson(count, Integer.TYPE);
    }

    public ClusterVo getTopicAndPartitionCount(Integer clusterId) {
        ClusterVo clusterVo = new ClusterVo();
        String url = this.masterService.getQueryCountUrl(clusterId, "/webapi.htm?type=op_query&method=admin_query_topic_info");
        String queryMaster = this.masterService.queryMaster(url);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(queryMaster, JsonObject.class);
        JsonElement data = jsonObject.get("data");
        JsonElement dataCount = jsonObject.get("count");
        Integer topicSize = (Integer)this.gson.fromJson(dataCount, Integer.class);
        JsonArray jsonData = (JsonArray)this.gson.fromJson(data, JsonArray.class);
        int partitionCount = 0;
        List topicQueryResList = (List)this.gson.fromJson(jsonData.toString(), new TypeToken<List<TopicQueryRes>>(){}.getType());
        for (TopicQueryRes topicQueryRes : topicQueryResList) {
            String totalCfgNumPart = topicQueryRes.getTotalCfgNumPart();
            partitionCount += (int)Math.ceil(Double.parseDouble(totalCfgNumPart));
        }
        clusterVo.setTopicCount(topicSize);
        clusterVo.setPartitionCount(partitionCount);
        return clusterVo;
    }

    public int getConsumerGroupCount(Integer clusterId) {
        String queryUrl = this.masterService.getQueryCountUrl(clusterId, "/webapi.htm?type=op_query&method=admin_query_topic_authorize_control");
        int consumerGroupCount = 0;
        String groupData = this.masterService.queryMaster(queryUrl);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(groupData, JsonObject.class);
        JsonElement data = jsonObject.get("data");
        JsonArray jsonData = (JsonArray)this.gson.fromJson(data, JsonArray.class);
        List groupList = (List)this.gson.fromJson(jsonData.toString(), new TypeToken<List<ConsumerGroupInfoRes>>(){}.getType());
        for (ConsumerGroupInfoRes groupInfoRes : groupList) {
            consumerGroupCount += (int)Math.ceil(groupInfoRes.getGroupCount());
        }
        return consumerGroupCount;
    }

    public int getConsumerCount(Integer clusterId) {
        String queryUrl = this.masterService.getQueryCountUrl(clusterId, "/webapi.htm?type=op_query&method=admin_query_sub_info");
        String queryMaster = this.masterService.queryMaster(queryUrl);
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(queryMaster, JsonObject.class);
        JsonElement data = jsonObject.get("data");
        JsonArray jsonData = (JsonArray)this.gson.fromJson(data, JsonArray.class);
        int consumerCount = 0;
        List topicViewResList = (List)this.gson.fromJson(jsonData.toString(), new TypeToken<List<ConsumerInfoRes>>(){}.getType());
        for (ConsumerInfoRes consumerInfoRes : topicViewResList) {
            consumerCount = (int)Math.ceil(consumerInfoRes.getConsumerNum());
        }
        return consumerCount;
    }

    public int getStoreCount(Integer clusterId) {
        String queryUrl = this.masterService.getQueryCountUrl(clusterId, "/webapi.htm?type=op_query&method=admin_query_cluster_topic_view");
        JsonObject jsonObject = (JsonObject)this.gson.fromJson(this.masterService.queryMaster(queryUrl), JsonObject.class);
        JsonElement getData = jsonObject.get("data");
        JsonArray fromJson = (JsonArray)this.gson.fromJson(getData, JsonArray.class);
        int storeCount = 0;
        List topicViewResList = (List)this.gson.fromJson(fromJson.toString(), new TypeToken<List<TopicViewRes>>(){}.getType());
        for (TopicViewRes topicViewRes : topicViewResList) {
            storeCount += (int)Math.ceil(topicViewRes.getTotalCfgNumStore());
        }
        return storeCount;
    }

    public TubeMQResult queryClusterByClusterName(String clusterName) {
        ClusterEntry clusterEntry = this.clusterService.getOneCluster(clusterName);
        if (clusterEntry == null) {
            return TubeMQResult.errorResult("no such cluster with name " + clusterName);
        }
        List<MasterEntry> masterNodes = this.masterService.getMasterNodes(clusterEntry.getClusterId());
        ClusterVo allCount = this.getCountInCluster((int)clusterEntry.getClusterId());
        this.result.setData(Lists.newArrayList((Object[])new ClusterVo[]{ConvertUtils.convertToClusterVo(clusterEntry, masterNodes, allCount)}));
        return this.result;
    }

    public TubeMQResult queryClusterByMasterIp(String masterIp) {
        ArrayList clusterEntryList = Lists.newArrayList();
        List<MasterEntry> masterNodes = this.masterService.getMasterNodes(masterIp);
        if (CollectionUtils.isEmpty(masterNodes)) {
            return TubeMQResult.errorResult("no such cluster with ip " + masterIp);
        }
        for (MasterEntry masterNode : masterNodes) {
            ClusterEntry cluster = this.clusterService.getOneCluster(masterNode.getClusterId());
            clusterEntryList.add(cluster);
        }
        ArrayList clusterVos = Lists.newArrayList();
        for (ClusterEntry clusterEntry : clusterEntryList) {
            ClusterVo allCount = this.getCountInCluster((int)clusterEntry.getClusterId());
            ClusterVo clusterVo = ConvertUtils.convertToClusterVo(clusterEntry, masterNodes, allCount);
            clusterVos.add(clusterVo);
        }
        this.result.setData(clusterVos);
        return this.result;
    }
}

