/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.operations;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.OperationUtils;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.QueryOperationVisitor;

@Internal
public class ScalaDataStreamQueryOperation<E>
implements QueryOperation {
    @Nullable
    private final ObjectIdentifier identifier;
    private final DataStream<E> dataStream;
    private final int[] fieldIndices;
    private final ResolvedSchema resolvedSchema;

    public ScalaDataStreamQueryOperation(DataStream<E> dataStream, int[] fieldIndices, ResolvedSchema resolvedSchema) {
        this(null, dataStream, fieldIndices, resolvedSchema);
    }

    public ScalaDataStreamQueryOperation(ObjectIdentifier identifier, DataStream<E> dataStream, int[] fieldIndices, ResolvedSchema resolvedSchema) {
        this.identifier = identifier;
        this.dataStream = dataStream;
        this.resolvedSchema = resolvedSchema;
        this.fieldIndices = fieldIndices;
    }

    public DataStream<E> getDataStream() {
        return this.dataStream;
    }

    public int[] getFieldIndices() {
        return this.fieldIndices;
    }

    public ResolvedSchema getResolvedSchema() {
        return this.resolvedSchema;
    }

    public Optional<ObjectIdentifier> getIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public String asSummaryString() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        if (this.identifier != null) {
            args.put("id", this.identifier.asSummaryString());
        } else {
            args.put("id", this.dataStream.getId());
        }
        args.put("fields", this.resolvedSchema.getColumnNames());
        return OperationUtils.formatWithChildren((String)"DataStream", args, this.getChildren(), Operation::asSummaryString);
    }

    public List<QueryOperation> getChildren() {
        return Collections.emptyList();
    }

    public <T> T accept(QueryOperationVisitor<T> visitor) {
        return (T)visitor.visit((QueryOperation)this);
    }
}

