/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.plugin.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlinkUtils {
    private static final Logger log = LoggerFactory.getLogger(FlinkUtils.class);
    public static final String BASE_DIRECTORY = "config";
    public static final List<String> FLINK_VERSION_COLLECTION = Collections.singletonList("Flink-1.13");

    public static String getLatestFlinkVersion(String[] supportedFlink) {
        if (Objects.isNull(supportedFlink)) {
            return null;
        }
        Arrays.sort(supportedFlink, Collections.reverseOrder());
        String latestFinkVersion = null;
        for (String flinkVersion : supportedFlink) {
            latestFinkVersion = FLINK_VERSION_COLLECTION.stream().filter(v -> v.equals(flinkVersion)).findFirst().orElse(null);
            if (!Objects.nonNull(latestFinkVersion)) continue;
            return latestFinkVersion;
        }
        return latestFinkVersion;
    }

    public static String getExceptionStackMsg(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
        return stringWriter.getBuffer().toString();
    }

    public static String findFile(String baseDirName, String pattern) {
        List<String> files = FlinkUtils.listFiles(baseDirName, pattern, 1);
        if (CollectionUtils.isEmpty(files)) {
            return null;
        }
        return files.get(0);
    }

    public static List<String> listFiles(String baseDirName, String pattern, int limit) {
        ArrayList<String> result = new ArrayList<String>();
        File baseDir = new File(baseDirName);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            log.error("baseDirName find fail :{}", (Object)baseDirName);
            return result;
        }
        File[] files = baseDir.listFiles();
        if (files == null || files.length == 0) {
            log.info("baseDirName is empty");
            return result;
        }
        File[] fileArray = files;
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            File file;
            File tempFile = file = fileArray[i];
            String tempName = tempFile.getName();
            Pattern jarPathPattern = Pattern.compile(pattern);
            Matcher matcher = jarPathPattern.matcher(tempName);
            boolean matches = matcher.matches();
            if (matches) {
                result.add(tempFile.getAbsoluteFile().toString());
            }
            if (limit <= 0 || result.size() < limit) continue;
            return result;
        }
        return result;
    }

    public static String getValue(String key, String defaultValue) {
        return StringUtils.isNotEmpty((CharSequence)key) ? key : defaultValue;
    }

    public static String getConfigDirectory(String name) {
        return BASE_DIRECTORY + File.separator + name;
    }

    public static boolean writeConfigToFile(String configJobDirectory, String configFileName, String content) {
        File file = new File(configJobDirectory);
        if (!file.exists()) {
            file.mkdirs();
        }
        String filePath = configJobDirectory + File.separator + configFileName;
        try {
            FileWriter fileWriter = new FileWriter(filePath);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(content);
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException e) {
            log.error("saveConfigToLocal failed", (Throwable)e);
            return false;
        }
        return true;
    }

    public static boolean deleteConfigFile(String name) {
        String configDirectory = FlinkUtils.getConfigDirectory(name);
        File file = new File(configDirectory);
        if (file.exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException e) {
                log.error("delete {} failed", (Object)configDirectory, (Object)e);
                return false;
            }
        }
        return true;
    }
}

