/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.protocol;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.tubemq.corebase.utils.ServiceStatusHolder;
import org.apache.inlong.tubemq.corerpc.RequestWrapper;
import org.apache.inlong.tubemq.corerpc.ResponseWrapper;
import org.apache.inlong.tubemq.corerpc.codec.PbEnDecoder;
import org.apache.inlong.tubemq.corerpc.exception.ServiceStoppingException;
import org.apache.inlong.tubemq.corerpc.exception.StandbyException;
import org.apache.inlong.tubemq.corerpc.protocol.Protocol;
import org.apache.inlong.tubemq.corerpc.server.RequestContext;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcProtocol
implements Protocol {
    public static final int RPC_PROTOCOL_TCP = 10;
    public static final int RPC_PROTOCOL_TLS = 11;
    public static final int RPC_PROTOCOL_VERSION_OLD_1 = 1;
    public static final int RPC_PROTOCOL_VERSION_TUBEMQ = 2;
    public static final int RPC_PROTOCOL_VERSION = 3;
    private static final Logger logger = LoggerFactory.getLogger(RpcProtocol.class);
    private final Map<Integer, Object> processors = new HashMap<Integer, Object>();
    private final Map<Integer, Method> cacheMethods = new HashMap<Integer, Method>();
    private final Map<Integer, ExecutorService> threadPools = new HashMap<Integer, ExecutorService>();
    private boolean isOverTLS = false;

    @Override
    public void registerService(boolean isOverTLS, String serviceName, Object instance, ExecutorService threadPool) throws Exception {
        Method[] methods;
        this.isOverTLS = isOverTLS;
        int serviceId = PbEnDecoder.getServiceIdByServiceName(serviceName);
        this.processors.put(serviceId, instance);
        this.threadPools.put(serviceId, threadPool);
        Class<?> instanceClass = instance.getClass();
        for (Method method : methods = instanceClass.getMethods()) {
            try {
                String methodName = method.getName();
                int methodId = PbEnDecoder.getMethIdByName(methodName);
                this.cacheMethods.put(methodId, method);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeService(String serviceName) throws Exception {
        Method[] methods;
        int serviceId = PbEnDecoder.getServiceIdByServiceName(serviceName);
        Object instance = this.processors.remove(serviceId);
        Class<?> instanceClass = instance.getClass();
        for (Method method : methods = instanceClass.getMethods()) {
            try {
                String methodName = method.getName();
                int methodId = PbEnDecoder.getMethIdByName(methodName);
                this.cacheMethods.remove(methodId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeAllService() {
        this.processors.clear();
        this.cacheMethods.clear();
        for (ExecutorService executorService : this.threadPools.values()) {
            if (executorService == null) continue;
            executorService.shutdown();
            try {
                while (!executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                    logger.warn("threadpool not stop yet,try again");
                }
                logger.warn("threadpool stop success...");
            }
            catch (InterruptedException e) {
                logger.warn("threadpool stop has been InterruptedException...");
            }
        }
    }

    @Override
    public void handleRequest(RequestContext context, String rmtAddress) throws Exception {
        ResponseWrapper responseWrapper = null;
        RequestWrapper requestWrapper = context.getRequest();
        if (System.currentTimeMillis() - context.getReceiveTime() > requestWrapper.getTimeout()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Timeout when request arrived, so give up processing this request from : {}", (Object)rmtAddress);
            }
            return;
        }
        if (ServiceStatusHolder.isServiceStopped()) {
            context.write(new ResponseWrapper(1, requestWrapper.getSerialNo(), requestWrapper.getServiceType(), requestWrapper.getProtocolVersion(), 3, new ServiceStoppingException("service is stopping...")));
        }
        Method method = null;
        StringBuilder sBuilder = new StringBuilder(512);
        try {
            if (!PbEnDecoder.isValidServiceTypeAndMethod(requestWrapper.getServiceType(), requestWrapper.getMethodId(), sBuilder)) {
                throw new Exception(sBuilder.toString());
            }
            Object processor = this.processors.get(requestWrapper.getServiceType());
            if (processor == null) {
                throw new Exception(sBuilder.append("No service ").append(requestWrapper.getServiceType()).append(" found on the server").toString());
            }
            method = this.cacheMethods.get(requestWrapper.getMethodId());
            if (method == null) {
                throw new Exception(sBuilder.append("No method ").append(requestWrapper.getMethodId()).append(" in service ").append(requestWrapper.getServiceType()).append(" found on the server").toString());
            }
            Object result = method.invoke(processor, requestWrapper.getRequestData(), rmtAddress, this.isOverTLS);
            responseWrapper = new ResponseWrapper(1, requestWrapper.getSerialNo(), requestWrapper.getServiceType(), 3, requestWrapper.getMethodId(), result);
        }
        catch (Throwable e2) {
            String errorClass = null;
            String errorInfo = null;
            if (e2.getCause() != null && e2.getCause() instanceof StandbyException) {
                errorClass = e2.getCause().getClass().getName();
                errorInfo = e2.getCause().getMessage();
            } else {
                errorClass = e2.getClass().getName();
                errorInfo = e2.getMessage();
            }
            errorClass = MixUtils.replaceClassNamePrefix(errorClass, true, requestWrapper.getProtocolVersion());
            responseWrapper = new ResponseWrapper(1, requestWrapper.getSerialNo(), requestWrapper.getServiceType(), 3, errorClass, errorInfo);
        }
        try {
            context.write(responseWrapper);
        }
        catch (Exception e) {
            logger.error("Write response error!", e);
        }
    }
}

