/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import com.google.protobuf.Message;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.apache.inlong.tubemq.corebase.protobuf.generated.RPCProtos;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corerpc.RequestWrapper;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcConstants;
import org.apache.inlong.tubemq.corerpc.RpcDataPack;
import org.apache.inlong.tubemq.corerpc.codec.PbEnDecoder;
import org.apache.inlong.tubemq.corerpc.exception.ServerNotReadyException;
import org.apache.inlong.tubemq.corerpc.netty.ByteBufferInputStream;
import org.apache.inlong.tubemq.corerpc.netty.ByteBufferOutputStream;
import org.apache.inlong.tubemq.corerpc.netty.EventLoopUtil;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolDecoder;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolEncoder;
import org.apache.inlong.tubemq.corerpc.netty.NettyRequestContext;
import org.apache.inlong.tubemq.corerpc.protocol.Protocol;
import org.apache.inlong.tubemq.corerpc.protocol.ProtocolFactory;
import org.apache.inlong.tubemq.corerpc.server.ServiceRpcServer;
import org.apache.inlong.tubemq.corerpc.utils.MixUtils;
import org.apache.inlong.tubemq.corerpc.utils.TSSLEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyRpcServer
implements ServiceRpcServer {
    private static final Logger logger = LoggerFactory.getLogger(NettyRpcServer.class);
    private static final ConcurrentHashMap<String, AtomicLong> errParseAddrMap = new ConcurrentHashMap();
    private static AtomicLong lastParseTime = new AtomicLong(0L);
    private final ConcurrentHashMap<Integer, Protocol> protocols = new ConcurrentHashMap();
    private ServerBootstrap bootstrap;
    private EventLoopGroup acceptorGroup;
    private EventLoopGroup workerGroup;
    private boolean enableBusyWait;
    private AtomicBoolean started = new AtomicBoolean(false);
    private int protocolType = 10;
    private boolean isOverTLS;
    private String keyStorePath = "";
    private String keyStorePassword = "";
    private boolean needTwoWayAuthentic = false;
    private String trustStorePath = "";
    private String trustStorePassword = "";

    public NettyRpcServer(RpcConfig conf) throws Exception {
        int nettyRecvBuf;
        this.isOverTLS = conf.getBoolean("tcp.tls", false);
        if (this.isOverTLS) {
            this.protocolType = 11;
            this.keyStorePath = conf.getString("tls.keystore.path");
            this.keyStorePassword = conf.getString("tls.keystore.password");
            this.needTwoWayAuthentic = conf.getBoolean("tls.twoway.authentic", false);
            if (this.needTwoWayAuthentic) {
                this.trustStorePath = conf.getString("tls.truststore.path");
                this.trustStorePassword = conf.getString("tls.truststore.password");
            }
            if (this.keyStorePath == null || this.keyStorePassword == null) {
                throw new Exception(new StringBuilder(512).append("Required parameters: ").append("tls.keystore.path").append(" or ").append("tls.keystore.password").append(" for TLS!").toString());
            }
            if (this.needTwoWayAuthentic && (this.trustStorePath == null || this.trustStorePassword == null)) {
                throw new Exception(new StringBuilder(512).append("Required parameters: ").append("tls.truststore.path").append(" or ").append("tls.truststore.password").append(" for TLS!").toString());
            }
        }
        this.enableBusyWait = conf.getBoolean("rpc.netty.enable.busy.wait", false);
        int bossCount = conf.getInt("rpc.netty.boss.count", 1);
        int workerCount = conf.getInt("rpc.netty.worker.count", RpcConstants.CFG_DEFAULT_SERVER_WORKER_COUNT);
        this.acceptorGroup = EventLoopUtil.newEventLoopGroup(bossCount, false, new DefaultThreadFactory("tcpSource-nettyBoss-threadGroup"));
        this.workerGroup = EventLoopUtil.newEventLoopGroup(workerCount, this.enableBusyWait, new DefaultThreadFactory("tcpSource-nettyWorker-threadGroup"));
        this.bootstrap = new ServerBootstrap();
        this.bootstrap.channel(EventLoopUtil.getServerSocketChannelClass(this.workerGroup));
        EventLoopUtil.enableTriggeredMode(this.bootstrap);
        this.bootstrap.group(this.acceptorGroup, this.workerGroup);
        this.bootstrap.childOption(ChannelOption.TCP_NODELAY, conf.getBoolean("rpc.tcp.nodelay", true));
        this.bootstrap.childOption(ChannelOption.SO_REUSEADDR, conf.getBoolean("rpc.tcp.reuseaddress", true));
        int nettyWriteHighMark = conf.getInt("rpc.netty.write.highmark", 65536);
        int nettyWriteLowMark = conf.getInt("rpc.netty.write.lowmark", 32768);
        this.bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(nettyWriteLowMark, nettyWriteHighMark));
        int nettySendBuf = conf.getInt("rpc.netty.send.buffer", -1);
        if (nettySendBuf > 0) {
            this.bootstrap.childOption(ChannelOption.SO_SNDBUF, nettySendBuf);
        }
        if ((nettyRecvBuf = conf.getInt("rpc.netty.receive.buffer", -1)) > 0) {
            this.bootstrap.childOption(ChannelOption.SO_RCVBUF, nettyRecvBuf);
        }
    }

    @Override
    public void start(int listenPort) throws Exception {
        if (this.started.get()) {
            return;
        }
        this.bootstrap.childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel socketChannel) {
                if (NettyRpcServer.this.isOverTLS) {
                    try {
                        SSLEngine sslEngine = TSSLEngineUtil.createSSLEngine(NettyRpcServer.this.keyStorePath, NettyRpcServer.this.trustStorePath, NettyRpcServer.this.keyStorePassword, NettyRpcServer.this.trustStorePassword, false, NettyRpcServer.this.needTwoWayAuthentic);
                        socketChannel.pipeline().addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    catch (Throwable t) {
                        logger.error("TLS NettyRpcServer init SSLEngine error, system auto exit!", t);
                        System.exit(1);
                    }
                }
                socketChannel.pipeline().addLast("protocolEncoder", (ChannelHandler)new NettyProtocolDecoder());
                socketChannel.pipeline().addLast("protocolDecoder", (ChannelHandler)new NettyProtocolEncoder());
                socketChannel.pipeline().addLast("serverHandler", (ChannelHandler)new NettyServerHandler(NettyRpcServer.this.protocolType));
            }
        });
        this.bootstrap.bind(new InetSocketAddress(listenPort)).sync();
        this.started.set(true);
        if (this.isOverTLS) {
            logger.info(new StringBuilder(256).append("TLS RpcServer started, listen port: ").append(listenPort).toString());
        } else {
            logger.info(new StringBuilder(256).append("TCP RpcServer started, listen port: ").append(listenPort).toString());
        }
    }

    @Override
    public void publishService(String serviceName, Object serviceInstance, ExecutorService threadPool) throws Exception {
        Protocol protocol = this.protocols.get(this.protocolType);
        if (protocol == null) {
            if (ProtocolFactory.getProtocol(this.protocolType) == null) {
                throw new Exception(new StringBuilder(256).append("Invalid protocol type ").append(this.protocolType).append("! You have to register you new protocol before publish service.").toString());
            }
            protocol = ProtocolFactory.getProtocolInstance(this.protocolType);
            this.protocols.put(this.protocolType, protocol);
        }
        protocol.registerService(this.isOverTLS, serviceName, serviceInstance, threadPool);
    }

    @Override
    public void removeService(int protocolType, String serviceName) throws Exception {
        Protocol protocol = this.protocols.get(protocolType);
        if (protocol != null) {
            protocol.removeService(serviceName);
        }
    }

    @Override
    public void removeAllService(int protocolType) throws Exception {
        Protocol protocol = this.protocols.get(protocolType);
        if (protocol != null) {
            protocol.removeAllService();
        }
    }

    @Override
    public boolean isServiceStarted() {
        return this.started.get();
    }

    @Override
    public void stop() throws Exception {
        if (!this.started.get()) {
            return;
        }
        if (this.started.compareAndSet(true, false)) {
            logger.info("Stopping RpcServer...");
            logger.info("RpcServer stop successfully.");
        }
    }

    private class NettyServerHandler
    extends ChannelInboundHandlerAdapter {
        private int protocolType = 10;

        public NettyServerHandler(int protocolType) {
            this.protocolType = protocolType;
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
            if (!(e.getCause() instanceof IOException)) {
                logger.error("catch some exception not IOException {}", e);
            }
            ctx.fireExceptionCaught(e);
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            RPCProtos.RequestBody rpcRequestBody;
            RPCProtos.RequestHeader requestHeader;
            RPCProtos.RpcConnHeader connHeader;
            logger.debug("server message receive!");
            if (!(msg instanceof RpcDataPack)) {
                return;
            }
            logger.debug("server RpcDataPack message receive!");
            RpcDataPack dataPack = (RpcDataPack)msg;
            int rmtVersion = 3;
            Channel channel = ctx.channel();
            if (channel == null) {
                return;
            }
            String rmtaddrIp = AddressUtils.getRemoteAddressIP(channel);
            try {
                if (!NettyRpcServer.this.isServiceStarted()) {
                    throw new ServerNotReadyException("RpcServer is not running yet");
                }
                List<ByteBuffer> req = dataPack.getDataLst();
                ByteBufferInputStream dis = new ByteBufferInputStream(req);
                connHeader = RPCProtos.RpcConnHeader.parseDelimitedFrom(dis);
                requestHeader = RPCProtos.RequestHeader.parseDelimitedFrom(dis);
                rmtVersion = requestHeader.getProtocolVer();
                rpcRequestBody = RPCProtos.RequestBody.parseDelimitedFrom(dis);
            }
            catch (Throwable e1) {
                List<ByteBuffer> res;
                if (!(e1 instanceof ServerNotReadyException) && rmtaddrIp != null) {
                    AtomicLong count = (AtomicLong)errParseAddrMap.get(rmtaddrIp);
                    if (count == null) {
                        AtomicLong tmpCount = new AtomicLong(0L);
                        count = errParseAddrMap.putIfAbsent(rmtaddrIp, tmpCount);
                        if (count == null) {
                            count = tmpCount;
                        }
                    }
                    count.incrementAndGet();
                    long befTime = lastParseTime.get();
                    long curTime = System.currentTimeMillis();
                    if (curTime - befTime > 180000L && lastParseTime.compareAndSet(befTime, System.currentTimeMillis())) {
                        logger.warn(new StringBuilder(512).append("[Abnormal Visit] Abnormal Message Content visit list is :").append(errParseAddrMap).toString());
                        errParseAddrMap.clear();
                    }
                }
                if ((res = this.prepareResponse(null, rmtVersion, RPCProtos.ResponseHeader.Status.FATAL, e1.getClass().getName(), new StringBuilder(512).append("IPC server unable to read call parameters:").append(e1.getMessage()).toString())) != null) {
                    dataPack.setDataLst(res);
                    channel.writeAndFlush(dataPack);
                }
                return;
            }
            try {
                RequestWrapper requestWrapper = new RequestWrapper(requestHeader.getServiceType(), this.protocolType, requestHeader.getProtocolVer(), connHeader.getFlag(), rpcRequestBody.getTimeout());
                requestWrapper.setMethodId(rpcRequestBody.getMethod());
                requestWrapper.setRequestData(PbEnDecoder.pbDecode(true, rpcRequestBody.getMethod(), rpcRequestBody.getRequest().toByteArray()));
                requestWrapper.setSerialNo(dataPack.getSerialNo());
                NettyRequestContext context = new NettyRequestContext(requestWrapper, ctx, System.currentTimeMillis());
                ((Protocol)NettyRpcServer.this.protocols.get(this.protocolType)).handleRequest(context, rmtaddrIp);
            }
            catch (Throwable ee) {
                List<ByteBuffer> res = this.prepareResponse(null, rmtVersion, RPCProtos.ResponseHeader.Status.FATAL, ee.getClass().getName(), new StringBuilder(512).append("IPC server handle request error :").append(ee.getMessage()).toString());
                if (res != null) {
                    dataPack.setDataLst(res);
                    ctx.channel().writeAndFlush(dataPack);
                }
                return;
            }
        }

        protected List<ByteBuffer> prepareResponse(Object value, int rmtVersion, RPCProtos.ResponseHeader.Status status, String errorClass, String error) {
            ByteBufferOutputStream buf = new ByteBufferOutputStream();
            DataOutputStream out = new DataOutputStream(buf);
            errorClass = MixUtils.replaceClassNamePrefix(errorClass, true, rmtVersion);
            try {
                RPCProtos.RpcConnHeader.Builder connBuilder = RPCProtos.RpcConnHeader.newBuilder();
                connBuilder.setFlag(1);
                connBuilder.build().writeDelimitedTo(out);
                RPCProtos.ResponseHeader.Builder builder = RPCProtos.ResponseHeader.newBuilder();
                builder.setStatus(status);
                builder.build().writeDelimitedTo(out);
                if (error != null) {
                    RPCProtos.RspExceptionBody.Builder b = RPCProtos.RspExceptionBody.newBuilder();
                    b.setExceptionName(errorClass);
                    b.setStackTrace(error);
                    b.build().writeDelimitedTo(out);
                } else if (value != null) {
                    ((Message)value).writeDelimitedTo(out);
                }
            }
            catch (IOException e) {
                logger.warn(new StringBuilder(512).append("Exception while creating response ").append(e).toString());
            }
            return buf.getBufferList();
        }
    }
}

