/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.corebase.utils.AddressUtils;
import org.apache.inlong.tubemq.corerpc.RpcDataPack;
import org.apache.inlong.tubemq.corerpc.exception.UnknownProtocolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyProtocolDecoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger logger = LoggerFactory.getLogger(NettyProtocolDecoder.class);
    private static final ConcurrentHashMap<String, AtomicLong> errProtolAddrMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AtomicLong> errSizeAddrMap = new ConcurrentHashMap();
    private static AtomicLong lastProtolTime = new AtomicLong(0L);
    private static AtomicLong lastSizeTime = new AtomicLong(0L);
    private boolean packHeaderRead = false;
    private int listSize;
    private List<RpcDataPack> rpcDataPackList = new ArrayList<RpcDataPack>();
    private RpcDataPack dataPack;
    private ByteBuf lastByteBuf;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        buffer = this.convertToNewBuf(buffer);
        while (buffer.readableBytes() > 0) {
            if (!this.packHeaderRead) {
                if (buffer.readableBytes() < 12) {
                    this.saveRemainedByteBuf(buffer);
                    break;
                }
                int frameToken = buffer.readInt();
                this.filterIllegalPkgToken(frameToken, -8391426, ctx.channel());
                int serialNo = buffer.readInt();
                int tmpListSize = buffer.readInt();
                this.filterIllegalPackageSize(true, tmpListSize, 3584, ctx.channel());
                this.listSize = tmpListSize;
                this.dataPack = new RpcDataPack(serialNo, new ArrayList<ByteBuffer>(this.listSize));
                this.packHeaderRead = true;
            }
            if (buffer.readableBytes() < 4) {
                this.saveRemainedByteBuf(buffer);
                break;
            }
            buffer.markReaderIndex();
            int length = buffer.readInt();
            if (buffer.readableBytes() < length) {
                buffer.resetReaderIndex();
                this.saveRemainedByteBuf(buffer);
                break;
            }
            ByteBuffer bb = ByteBuffer.allocate(length);
            buffer.readBytes(bb);
            bb.flip();
            this.dataPack.getDataLst().add(bb);
            if (this.dataPack.getDataLst().size() != this.listSize) continue;
            this.packHeaderRead = false;
            this.rpcDataPackList.add(this.dataPack);
        }
        if (this.rpcDataPackList.size() > 0) {
            out.addAll(this.rpcDataPackList);
            this.rpcDataPackList.clear();
        }
    }

    private void saveRemainedByteBuf(ByteBuf byteBuf) {
        if (byteBuf != null && byteBuf.readableBytes() > 0) {
            this.lastByteBuf = Unpooled.copiedBuffer(byteBuf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuf convertToNewBuf(ByteBuf byteBuf) {
        ByteBuf newByteBuf = byteBuf;
        int totalReadBytes = byteBuf.readableBytes();
        if (this.lastByteBuf != null) {
            try {
                newByteBuf = Unpooled.buffer(totalReadBytes += this.lastByteBuf.readableBytes());
                newByteBuf.writeBytes(this.lastByteBuf);
                newByteBuf.writeBytes(byteBuf);
            }
            finally {
                ReferenceCountUtil.release(this.lastByteBuf);
            }
            this.lastByteBuf = null;
        }
        return newByteBuf;
    }

    private void filterIllegalPkgToken(int inParamValue, int allowTokenVal, Channel channel) throws UnknownProtocolException {
        if (inParamValue != allowTokenVal) {
            String rmtaddrIp = AddressUtils.getRemoteAddressIP(channel);
            if (rmtaddrIp != null) {
                AtomicLong tmpCount;
                AtomicLong count = errProtolAddrMap.get(rmtaddrIp);
                if (count == null && (count = errProtolAddrMap.putIfAbsent(rmtaddrIp, tmpCount = new AtomicLong(0L))) == null) {
                    count = tmpCount;
                }
                count.incrementAndGet();
                long befTime = lastProtolTime.get();
                long curTime = System.currentTimeMillis();
                if (curTime - befTime > 180000L && lastProtolTime.compareAndSet(befTime, System.currentTimeMillis())) {
                    logger.warn("[Abnormal Visit] OSS Tube  [inParamValue = {} vs allowTokenVal = {}] visit list is : {}", inParamValue, allowTokenVal, errProtolAddrMap.toString());
                    errProtolAddrMap.clear();
                }
            }
            throw new UnknownProtocolException(new StringBuilder(256).append("Unknown protocol exception for message frame, channel.address = ").append(channel.remoteAddress().toString()).toString());
        }
    }

    private void filterIllegalPackageSize(boolean isFrameSize, int inParamValue, int allowSize, Channel channel) throws UnknownProtocolException {
        if (inParamValue < 0 || inParamValue > allowSize) {
            String rmtaddrIp = AddressUtils.getRemoteAddressIP(channel);
            if (rmtaddrIp != null) {
                AtomicLong tmpCount;
                AtomicLong count = errSizeAddrMap.get(rmtaddrIp);
                if (count == null && (count = errSizeAddrMap.putIfAbsent(rmtaddrIp, tmpCount = new AtomicLong(0L))) == null) {
                    count = tmpCount;
                }
                count.incrementAndGet();
                long befTime = lastSizeTime.get();
                long curTime = System.currentTimeMillis();
                if (curTime - befTime > 180000L && lastSizeTime.compareAndSet(befTime, System.currentTimeMillis())) {
                    logger.warn("[Abnormal Visit] Abnormal BodySize visit list is :" + errSizeAddrMap.toString());
                    errSizeAddrMap.clear();
                }
            }
            StringBuilder sBuilder = new StringBuilder(256).append("Unknown protocol exception for message listSize! channel.address = ").append(channel.remoteAddress().toString());
            if (isFrameSize) {
                sBuilder.append(", Max list size=").append(allowSize).append(", request's list size=").append(inParamValue);
            } else {
                sBuilder.append(", Max buffer size=").append(allowSize).append(", request's buffer size=").append(inParamValue);
            }
            throw new UnknownProtocolException(sBuilder.toString());
        }
    }
}

