/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc.netty;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import org.apache.inlong.tubemq.corebase.cluster.NodeAddrInfo;
import org.apache.inlong.tubemq.corerpc.RpcConfig;
import org.apache.inlong.tubemq.corerpc.RpcConstants;
import org.apache.inlong.tubemq.corerpc.client.Client;
import org.apache.inlong.tubemq.corerpc.client.ClientFactory;
import org.apache.inlong.tubemq.corerpc.exception.LocalConnException;
import org.apache.inlong.tubemq.corerpc.netty.EventLoopUtil;
import org.apache.inlong.tubemq.corerpc.netty.NettyClient;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolDecoder;
import org.apache.inlong.tubemq.corerpc.netty.NettyProtocolEncoder;
import org.apache.inlong.tubemq.corerpc.utils.TSSLEngineUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyClientFactory
implements ClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(NettyClientFactory.class);
    protected final ConcurrentHashMap<String, Client> clients = new ConcurrentHashMap();
    protected AtomicBoolean shutdown = new AtomicBoolean(true);
    private EventLoopGroup eventLoopGroup;
    private AtomicInteger workerIdCounter = new AtomicInteger(0);
    private boolean enableTLS = false;
    private boolean needTwoWayAuthentic = false;
    private String keyStorePath;
    private String keyStorePassword;
    private String trustStorePath;
    private String trustStorePassword;

    public void configure(RpcConfig conf) throws IllegalArgumentException {
        if (this.shutdown.compareAndSet(true, false)) {
            this.enableTLS = conf.getBoolean("tcp.tls", false);
            this.needTwoWayAuthentic = conf.getBoolean("tls.twoway.authentic", false);
            if (this.enableTLS) {
                this.trustStorePath = conf.getString("tls.truststore.path");
                this.trustStorePassword = conf.getString("tls.truststore.password");
                if (this.needTwoWayAuthentic) {
                    this.keyStorePath = conf.getString("tls.keystore.path");
                    this.keyStorePassword = conf.getString("tls.keystore.password");
                } else {
                    this.keyStorePath = null;
                    this.keyStorePassword = null;
                }
            } else {
                this.keyStorePath = null;
                this.keyStorePassword = null;
                this.trustStorePath = null;
                this.trustStorePassword = null;
            }
            int workerCount = conf.getInt("rpc.netty.worker.count", RpcConstants.CFG_DEFAULT_CLIENT_WORKER_COUNT);
            String threadName = new StringBuilder(256).append(conf.getString("rpc.netty.worker.thread.name", "tube_rpc_netty_worker-")).append(this.workerIdCounter.incrementAndGet()).toString();
            this.eventLoopGroup = EventLoopUtil.newEventLoopGroup(workerCount, conf.getBoolean("rpc.netty.enable.busy.wait", false), new DefaultThreadFactory(threadName, Thread.currentThread().isDaemon()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Client getClient(NodeAddrInfo addressInfo, RpcConfig conf) throws Exception {
        Client client = this.clients.get(addressInfo.getHostPortStr());
        if (client != null && client.isReady()) {
            return client;
        }
        NettyClientFactory nettyClientFactory = this;
        synchronized (nettyClientFactory) {
            client = this.clients.get(addressInfo.getHostPortStr());
            if (client != null && client.isReady()) {
                return client;
            }
            if (client != null) {
                client = this.clients.remove(addressInfo.getHostPortStr());
                if (client != null) {
                    client.close();
                }
                client = null;
            }
            int connectTimeout = conf.getInt("rpc.connect.timeout", 3000);
            try {
                client = this.createClient(addressInfo, connectTimeout, conf);
                Client existClient = this.clients.putIfAbsent(addressInfo.getHostPortStr(), client);
                if (existClient != null) {
                    client.close(false);
                    client = existClient;
                }
            }
            catch (Exception e) {
                if (client != null) {
                    client.close(false);
                }
                throw e;
            }
            catch (Throwable ee) {
                if (client != null) {
                    client.close(false);
                }
                throw new Exception(ee);
            }
        }
        return client;
    }

    @Override
    public Client removeClient(NodeAddrInfo addressInfo) {
        return this.clients.remove(addressInfo.getHostPortStr());
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public void shutdown() {
        if (this.shutdown.compareAndSet(false, true)) {
            try {
                if (!this.clients.isEmpty()) {
                    for (String key : this.clients.keySet()) {
                        Client client;
                        if (key == null || (client = this.clients.remove(key)) == null) continue;
                        client.close();
                    }
                }
                if (this.eventLoopGroup != null && !this.eventLoopGroup.isShutdown()) {
                    this.eventLoopGroup.shutdownGracefully();
                }
            }
            catch (Exception e) {
                logger.error("has exception ", e);
            }
        }
    }

    private Client createClient(final NodeAddrInfo addressInfo, int connectTimeout, final RpcConfig conf) throws Exception {
        final NettyClient client = new NettyClient(this, connectTimeout);
        Bootstrap clientBootstrap = new Bootstrap();
        clientBootstrap.group(this.eventLoopGroup);
        clientBootstrap.channel(EventLoopUtil.getClientSocketChannelClass(this.eventLoopGroup));
        clientBootstrap.option(ChannelOption.TCP_NODELAY, true);
        clientBootstrap.option(ChannelOption.SO_REUSEADDR, true);
        clientBootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectTimeout);
        int nettyWriteHighMark = conf.getInt("rpc.netty.write.highmark", 65536);
        int nettyWriteLowMark = conf.getInt("rpc.netty.write.lowmark", 32768);
        clientBootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, new WriteBufferWaterMark(nettyWriteLowMark, nettyWriteHighMark));
        clientBootstrap.handler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel socketChannel) throws Exception {
                ChannelPipeline pipeline = socketChannel.pipeline();
                if (NettyClientFactory.this.enableTLS) {
                    try {
                        SSLEngine sslEngine = TSSLEngineUtil.createSSLEngine(NettyClientFactory.this.keyStorePath, NettyClientFactory.this.trustStorePath, NettyClientFactory.this.keyStorePassword, NettyClientFactory.this.trustStorePassword, true, NettyClientFactory.this.needTwoWayAuthentic);
                        pipeline.addLast("ssl", (ChannelHandler)new SslHandler(sslEngine));
                    }
                    catch (Throwable t) {
                        logger.error(new StringBuilder(256).append("Create SSLEngine to connection ").append(addressInfo.getHostPortStr()).append(" failure!").toString(), t);
                        throw new Exception(t);
                    }
                }
                pipeline.addLast("protocolEncoder", (ChannelHandler)new NettyProtocolEncoder());
                pipeline.addLast("protocolDecoder", (ChannelHandler)new NettyProtocolDecoder());
                pipeline.addLast("readTimeoutHandler", (ChannelHandler)new ReadTimeoutHandler(conf.getLong("rpc.connect.read.idle.duration", 300000L), TimeUnit.MILLISECONDS));
                pipeline.addLast("clientHandler", (ChannelHandler)new NettyClient.NettyClientHandler(client));
            }
        });
        ChannelFuture future = clientBootstrap.connect(new InetSocketAddress(addressInfo.getHost(), addressInfo.getPort()));
        future.awaitUninterruptibly(connectTimeout);
        if (!future.isDone()) {
            future.cancel(false);
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" timeout!").toString());
        }
        if (future.isCancelled()) {
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" cancelled by user!").toString());
        }
        if (!future.isSuccess()) {
            throw new LocalConnException(new StringBuilder(256).append("Create connection to ").append(addressInfo.getHostPortStr()).append(" error").toString(), future.cause());
        }
        client.setChannel(future.channel(), addressInfo);
        return client;
    }
}

