/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corerpc;

import java.util.HashMap;
import java.util.Map;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;

public class RpcConfig {
    private final Map<String, Object> params = new HashMap<String, Object>();

    public void put(String key, Object value) {
        this.params.put(key, value);
    }

    public String getString(String key) {
        Object value = this.params.get(key);
        return value == null ? null : String.valueOf(value);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (TStringUtils.isNotBlank(value)) {
            return value.trim();
        }
        return defaultValue;
    }

    public int getInt(String key, int defaultValue) {
        String value = this.getString(key);
        if (TStringUtils.isNotBlank(value)) {
            return Integer.parseInt(value.trim());
        }
        return defaultValue;
    }

    public double getDouble(String key, double defaultValue) {
        String value = this.getString(key);
        if (TStringUtils.isNotBlank(value)) {
            return Double.parseDouble(value.trim());
        }
        return defaultValue;
    }

    public long getLong(String key, long defaultValue) {
        String value = this.getString(key);
        if (TStringUtils.isNotBlank(value)) {
            return Long.parseLong(value.trim());
        }
        return defaultValue;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.getString(key);
        if (TStringUtils.isNotBlank(value)) {
            return Boolean.parseBoolean(value.trim());
        }
        return defaultValue;
    }
}

