/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.corebase.policies;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlItem;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlResult;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowCtrlRuleHandler {
    private final boolean isDefaultHandler;
    private final String flowCtrlName;
    private static final Logger logger = LoggerFactory.getLogger(FlowCtrlRuleHandler.class);
    private final TimeZone timeZone = TimeZone.getTimeZone("GMT+8:00");
    private final ReentrantLock writeLock = new ReentrantLock();
    private AtomicLong flowCtrlId = new AtomicLong(-2L);
    private AtomicInteger qryPriorityId = new AtomicInteger(-2);
    private String strFlowCtrlInfo;
    private AtomicInteger minZeroCnt = new AtomicInteger(Integer.MAX_VALUE);
    private AtomicLong minDataLimitDlt = new AtomicLong(Long.MAX_VALUE);
    private AtomicInteger dataLimitStartTime = new AtomicInteger(2500);
    private AtomicInteger dataLimitEndTime = new AtomicInteger(-2);
    private FlowCtrlItem filterCtrlItem = new FlowCtrlItem(3, -2, -2, -2);
    private long lastUpdateTime = System.currentTimeMillis();
    private Map<Integer, List<FlowCtrlItem>> flowCtrlRuleSet = new ConcurrentHashMap<Integer, List<FlowCtrlItem>>();

    public FlowCtrlRuleHandler(boolean isDefault) {
        this.isDefaultHandler = isDefault;
        this.flowCtrlName = this.isDefaultHandler ? "Default_FlowCtrl" : "Group_FlowCtrl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFlowCtrlInfo(int qryPriorityId, long flowCtrlId, String flowCtrlInfo, StringBuilder strBuff) throws Exception {
        long befFlowCtrlId;
        if (flowCtrlId == this.flowCtrlId.get()) {
            return;
        }
        int befQryPriorityId = -2;
        Map<Integer, List<FlowCtrlItem>> flowCtrlItemsMap = null;
        if (TStringUtils.isNotBlank(flowCtrlInfo)) {
            flowCtrlItemsMap = this.parseFlowCtrlInfo(flowCtrlInfo);
        }
        this.writeLock.lock();
        try {
            befFlowCtrlId = this.flowCtrlId.getAndSet(flowCtrlId);
            this.strFlowCtrlInfo = flowCtrlInfo;
            this.clearStatisData();
            if (flowCtrlItemsMap == null || flowCtrlItemsMap.isEmpty()) {
                this.flowCtrlRuleSet.clear();
            } else {
                this.flowCtrlRuleSet = flowCtrlItemsMap;
                this.initialStatisData();
            }
            if (qryPriorityId != -2 && qryPriorityId != this.qryPriorityId.get()) {
                befQryPriorityId = this.qryPriorityId.getAndSet(qryPriorityId);
            }
            this.lastUpdateTime = System.currentTimeMillis();
        }
        finally {
            this.writeLock.unlock();
        }
        strBuff.append("[Flow Ctrl] Update ").append(this.flowCtrlName).append(", flowId from ").append(befFlowCtrlId).append(" to ").append(flowCtrlId);
        if (qryPriorityId != -2 && qryPriorityId != befQryPriorityId) {
            strBuff.append(", qryPriorityId from ").append(befQryPriorityId).append(" to ").append(qryPriorityId);
        }
        logger.info(strBuff.toString());
        strBuff.delete(0, strBuff.length());
    }

    public FlowCtrlResult getCurDataLimit(long lastDataDlt) {
        Calendar rightNow = Calendar.getInstance(this.timeZone);
        int hour = rightNow.get(11);
        int minu = rightNow.get(12);
        int curTime = hour * 100 + minu;
        if (lastDataDlt < this.minDataLimitDlt.get() || curTime < this.dataLimitStartTime.get() || curTime > this.dataLimitEndTime.get()) {
            return null;
        }
        List<FlowCtrlItem> flowCtrlItemList = this.flowCtrlRuleSet.get(0);
        if (flowCtrlItemList == null || flowCtrlItemList.isEmpty()) {
            return null;
        }
        for (FlowCtrlItem flowCtrlItem : flowCtrlItemList) {
            FlowCtrlResult flowCtrlResult;
            if (flowCtrlItem == null || (flowCtrlResult = flowCtrlItem.getDataLimit(lastDataDlt, hour, minu)) == null) continue;
            return flowCtrlResult;
        }
        return null;
    }

    public int getNormFreqInMs() {
        return this.filterCtrlItem.getFreqLtInMs();
    }

    public int getMinDataFreqInMs() {
        return this.filterCtrlItem.getZeroCnt();
    }

    public FlowCtrlItem getFilterCtrlItem() {
        return this.filterCtrlItem;
    }

    private void initialStatisData() {
        this.initialDataLimitStatisInfo();
        this.initialFreqLimitStatisInfo();
        this.initialLowFetchLimitStatisInfo();
    }

    private void initialDataLimitStatisInfo() {
        List<FlowCtrlItem> flowCtrlItemList = this.flowCtrlRuleSet.get(0);
        if (flowCtrlItemList != null && !flowCtrlItemList.isEmpty()) {
            for (FlowCtrlItem flowCtrlItem : flowCtrlItemList) {
                if (flowCtrlItem == null || flowCtrlItem.getType() != 0) continue;
                if (flowCtrlItem.getDltInM() < this.minDataLimitDlt.get()) {
                    this.minDataLimitDlt.set(flowCtrlItem.getDltInM());
                }
                if (flowCtrlItem.getStartTime() < this.dataLimitStartTime.get()) {
                    this.dataLimitStartTime.set(flowCtrlItem.getStartTime());
                }
                if (flowCtrlItem.getEndTime() <= this.dataLimitEndTime.get()) continue;
                this.dataLimitEndTime.set(flowCtrlItem.getEndTime());
            }
        }
    }

    private void initialFreqLimitStatisInfo() {
        List<FlowCtrlItem> flowCtrlItemList = this.flowCtrlRuleSet.get(1);
        if (flowCtrlItemList != null && !flowCtrlItemList.isEmpty()) {
            for (FlowCtrlItem flowCtrlItem : flowCtrlItemList) {
                if (flowCtrlItem == null || flowCtrlItem.getType() != 1 || flowCtrlItem.getZeroCnt() >= this.minZeroCnt.get()) continue;
                this.minZeroCnt.set(flowCtrlItem.getZeroCnt());
            }
        }
    }

    private void initialLowFetchLimitStatisInfo() {
        List<FlowCtrlItem> flowCtrlItemList = this.flowCtrlRuleSet.get(3);
        if (flowCtrlItemList != null && !flowCtrlItemList.isEmpty()) {
            for (FlowCtrlItem flowCtrlItem : flowCtrlItemList) {
                if (flowCtrlItem == null || flowCtrlItem.getType() != 3) continue;
                this.filterCtrlItem = new FlowCtrlItem(3, (int)flowCtrlItem.getDataLtInSZ(), flowCtrlItem.getFreqLtInMs(), flowCtrlItem.getZeroCnt());
            }
        }
    }

    private void clearStatisData() {
        this.minZeroCnt.set(Integer.MAX_VALUE);
        this.minDataLimitDlt.set(Long.MAX_VALUE);
        this.dataLimitStartTime.set(2500);
        this.dataLimitEndTime.set(-2);
        this.filterCtrlItem = new FlowCtrlItem(3, -2, -2, -2);
    }

    public int getMinZeroCnt() {
        return this.minZeroCnt.get();
    }

    public int getCurFreqLimitTime(int msgZeroCnt, int rcmVal) {
        if (msgZeroCnt < this.minZeroCnt.get()) {
            return rcmVal;
        }
        List<FlowCtrlItem> flowCtrlItemList = this.flowCtrlRuleSet.get(1);
        if (flowCtrlItemList == null || flowCtrlItemList.isEmpty()) {
            return rcmVal;
        }
        for (FlowCtrlItem flowCtrlItem : flowCtrlItemList) {
            int ruleVal;
            if (flowCtrlItem == null || (ruleVal = flowCtrlItem.getFreLimit(msgZeroCnt)) < 0) continue;
            return ruleVal;
        }
        return rcmVal;
    }

    public int getQryPriorityId() {
        return this.qryPriorityId.get();
    }

    public void setQryPriorityId(int qryPriorityId) {
        this.qryPriorityId.set(qryPriorityId);
    }

    public long getFlowCtrlId() {
        return this.flowCtrlId.get();
    }

    public void clear() {
        this.writeLock.lock();
        try {
            this.strFlowCtrlInfo = "";
            this.flowCtrlRuleSet.clear();
            this.flowCtrlId.set(-2L);
            this.qryPriorityId.set(-2);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public Map<Integer, List<FlowCtrlItem>> parseFlowCtrlInfo(String flowCtrlInfo) throws Exception {
        ConcurrentHashMap<Integer, List<FlowCtrlItem>> flowCtrlMap = new ConcurrentHashMap<Integer, List<FlowCtrlItem>>();
        if (TStringUtils.isBlank(flowCtrlInfo)) {
            throw new Exception("Parsing error, flowCtrlInfo value is blank!");
        }
        JsonArray objArray = null;
        try {
            objArray = JsonParser.parseString(flowCtrlInfo).getAsJsonArray();
        }
        catch (Throwable e1) {
            throw new Exception("Parse flowCtrlInfo value failure", e1);
        }
        if (objArray == null) {
            throw new Exception("Parsing error, flowCtrlInfo value must be valid json format!");
        }
        if (objArray.size() == 0) {
            return flowCtrlMap;
        }
        try {
            for (int i = 0; i < objArray.size(); ++i) {
                List<FlowCtrlItem> flowCtrlItemList;
                JsonElement jsonItem = objArray.get(i);
                if (jsonItem == null) continue;
                int recordNo = i + 1;
                JsonObject jsonObject = jsonItem.getAsJsonObject();
                if (!jsonObject.has("type")) {
                    throw new Exception(new StringBuilder(512).append("FIELD type is required in record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                int typeVal = jsonObject.get("type").getAsInt();
                if (typeVal < 0 || typeVal > 3) {
                    throw new Exception(new StringBuilder(512).append("the value of FIELD type must in [0,1,3] in record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                switch (typeVal) {
                    case 1: {
                        flowCtrlItemList = this.parseFreqLimit(recordNo, typeVal, jsonObject);
                        break;
                    }
                    case 2: {
                        flowCtrlItemList = null;
                        break;
                    }
                    case 3: {
                        flowCtrlItemList = this.parseLowFetchLimit(recordNo, typeVal, jsonObject);
                        break;
                    }
                    default: {
                        typeVal = 0;
                        flowCtrlItemList = this.parseDataLimit(recordNo, typeVal, jsonObject);
                    }
                }
                if (flowCtrlItemList == null || flowCtrlItemList.isEmpty()) continue;
                flowCtrlMap.put(typeVal, flowCtrlItemList);
            }
        }
        catch (Throwable e2) {
            throw new Exception(new StringBuilder(512).append("Parse flowCtrlInfo value failure, ").append(e2.getMessage()).toString());
        }
        return flowCtrlMap;
    }

    private List<FlowCtrlItem> parseDataLimit(int recordNo, int typeVal, JsonObject jsonObject) throws Exception {
        if (jsonObject == null || jsonObject.get("type").getAsInt() != 0) {
            throw new Exception(new StringBuilder(512).append("parse data_limit rule failure in record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (!jsonObject.has("rule")) {
            throw new Exception(new StringBuilder(512).append("FIELD rule is required in data_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        JsonArray ruleArray = jsonObject.get("rule").getAsJsonArray();
        if (ruleArray == null) {
            throw new Exception(new StringBuilder(512).append("emtpy rule define in data_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        ArrayList<FlowCtrlItem> flowCtrlItems = new ArrayList<FlowCtrlItem>();
        for (int index = 0; index < ruleArray.size(); ++index) {
            int endTime;
            int itemNo = index + 1;
            JsonObject ruleObject = ruleArray.get(index).getAsJsonObject();
            int startTime = this.validAndGetTimeValue(ruleObject, "start", itemNo, recordNo);
            if (startTime >= (endTime = this.validAndGetTimeValue(ruleObject, "end", itemNo, recordNo))) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD start must lower than the value FIELD end ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            if (!ruleObject.has("dltInM")) {
                throw new Exception(new StringBuilder(512).append("FIELD dltInM is required in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            long dltVal = ruleObject.get("dltInM").getAsLong();
            if (dltVal <= 20L) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD dltInM must be greater than 20 ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            if (!ruleObject.has("limitInM")) {
                throw new Exception(new StringBuilder(512).append("FIELD limitInM is required in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            long dataLimitInM = ruleObject.get("limitInM").getAsLong();
            if (dataLimitInM < 0L) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD limitInM must be greater than or equal to 0 ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            dataLimitInM = dataLimitInM * 1024L * 1024L;
            if (!ruleObject.has("freqInMs")) {
                throw new Exception(new StringBuilder(512).append("FIELD freqInMs is required in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            int freqInMs = ruleObject.get("freqInMs").getAsInt();
            if (freqInMs < 200) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD freqInMs must be greater than or equal to 200 ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            flowCtrlItems.add(new FlowCtrlItem(typeVal, startTime, endTime, dltVal, dataLimitInM, freqInMs));
        }
        if (flowCtrlItems.isEmpty()) {
            throw new Exception(new StringBuilder(512).append("not found valid rule define in data_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        Collections.sort(flowCtrlItems, new Comparator<FlowCtrlItem>(){

            @Override
            public int compare(FlowCtrlItem o1, FlowCtrlItem o2) {
                if (o1.getStartTime() > o2.getStartTime()) {
                    return 1;
                }
                if (o1.getStartTime() < o2.getStartTime()) {
                    return -1;
                }
                return 0;
            }
        });
        return flowCtrlItems;
    }

    private List<FlowCtrlItem> parseFreqLimit(int recordNo, int typeVal, JsonObject jsonObject) throws Exception {
        if (jsonObject == null || jsonObject.get("type").getAsInt() != 1) {
            throw new Exception(new StringBuilder(512).append("parse freq_limit rule failure in record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (!jsonObject.has("rule")) {
            throw new Exception(new StringBuilder(512).append("FIELD rule is required in freq_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        JsonArray ruleArray = jsonObject.get("rule").getAsJsonArray();
        if (ruleArray == null) {
            throw new Exception(new StringBuilder(512).append("emtpy rule define in freq_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        ArrayList<FlowCtrlItem> flowCtrlItems = new ArrayList<FlowCtrlItem>();
        for (int index = 0; index < ruleArray.size(); ++index) {
            int itemNo = index + 1;
            JsonObject ruleObject = ruleArray.get(index).getAsJsonObject();
            if (!ruleObject.has("zeroCnt")) {
                throw new Exception(new StringBuilder(512).append("FIELD zeroCnt is required in freq_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            int zeroCnt = ruleObject.get("zeroCnt").getAsInt();
            if (zeroCnt < 1) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD zeroCnt must be greater than or equal to 1 ").append("in freq_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            if (!ruleObject.has("freqInMs")) {
                throw new Exception(new StringBuilder(512).append("FIELD freqInMs is required in freq_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            int freqInMs = ruleObject.get("freqInMs").getAsInt();
            if (freqInMs < 0) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD freqInMs must be greater than or equal to 0 ").append("in freq_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            flowCtrlItems.add(new FlowCtrlItem(typeVal, zeroCnt, freqInMs));
        }
        if (flowCtrlItems.isEmpty()) {
            throw new Exception(new StringBuilder(512).append("not found valid rule define in freq_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        Collections.sort(flowCtrlItems, new Comparator<FlowCtrlItem>(){

            @Override
            public int compare(FlowCtrlItem o1, FlowCtrlItem o2) {
                if (o1.getZeroCnt() > o2.getZeroCnt()) {
                    return -1;
                }
                if (o1.getZeroCnt() < o2.getZeroCnt()) {
                    return 1;
                }
                return 0;
            }
        });
        return flowCtrlItems;
    }

    private List<FlowCtrlItem> parseLowFetchLimit(int recordNo, int typeVal, JsonObject jsonObject) throws Exception {
        if (jsonObject == null || jsonObject.get("type").getAsInt() != 3) {
            throw new Exception(new StringBuilder(512).append("parse low_fetch_limit rule failure in record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (!jsonObject.has("rule")) {
            throw new Exception(new StringBuilder(512).append("FIELD rule is required in low_fetch_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        JsonArray ruleArray = jsonObject.get("rule").getAsJsonArray();
        if (ruleArray == null) {
            throw new Exception(new StringBuilder(512).append("emtpy rule define in low_fetch_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (ruleArray.size() > 1) {
            throw new Exception(new StringBuilder(512).append("only allow set one rule in low_fetch_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        ArrayList<FlowCtrlItem> flowCtrlItems = new ArrayList<FlowCtrlItem>();
        for (int index = 0; index < ruleArray.size(); ++index) {
            int itemNo = index + 1;
            JsonObject ruleObject = ruleArray.get(index).getAsJsonObject();
            int normfreqInMs = 0;
            int filterFreqInMs = 0;
            int minDataFilterFreqInMs = 0;
            if (ruleObject.has("filterFreqInMs") || ruleObject.has("minDataFilterFreqInMs")) {
                if (!ruleObject.has("filterFreqInMs")) {
                    throw new Exception(new StringBuilder(512).append("FIELD filterFreqInMs is required ").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                filterFreqInMs = ruleObject.get("filterFreqInMs").getAsInt();
                if (filterFreqInMs < 0 || filterFreqInMs > 300000) {
                    throw new Exception(new StringBuilder(512).append("the value of FIELD filterFreqInMs must in [0, 300000] ").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                if (!ruleObject.has("minDataFilterFreqInMs")) {
                    throw new Exception(new StringBuilder(512).append("FIELD minDataFilterFreqInMs is required ").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                minDataFilterFreqInMs = ruleObject.get("minDataFilterFreqInMs").getAsInt();
                if (minDataFilterFreqInMs < 0 || minDataFilterFreqInMs > 300000) {
                    throw new Exception(new StringBuilder(512).append("the value of FIELD minDataFilterFreqInMs must in [0, 300000] ").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
                if (minDataFilterFreqInMs < filterFreqInMs) {
                    throw new Exception(new StringBuilder(512).append("the value of FIELD minDataFilterFreqInMs must be greater ").append("than or equal to the value of FIELD filterFreqInMs").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
                }
            }
            if (ruleObject.has("normFreqInMs") && ((normfreqInMs = ruleObject.get("normFreqInMs").getAsInt()) < 0 || normfreqInMs > 300000)) {
                throw new Exception(new StringBuilder(512).append("the value of FIELD normFreqInMs must in [0, 300000] ").append("in low_fetch_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
            }
            flowCtrlItems.add(new FlowCtrlItem(typeVal, normfreqInMs, filterFreqInMs, minDataFilterFreqInMs));
        }
        if (flowCtrlItems.isEmpty()) {
            throw new Exception(new StringBuilder(512).append("not found valid rule define in low_fetch_limit record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        Collections.sort(flowCtrlItems, new Comparator<FlowCtrlItem>(){

            @Override
            public int compare(FlowCtrlItem o1, FlowCtrlItem o2) {
                if (o1.getFreqLtInMs() > o2.getFreqLtInMs()) {
                    return -1;
                }
                if (o1.getFreqLtInMs() < o2.getFreqLtInMs()) {
                    return 1;
                }
                return 0;
            }
        });
        return flowCtrlItems;
    }

    public String toString() {
        return this.strFlowCtrlInfo;
    }

    private int validAndGetTimeValue(JsonObject ruleObject, String fieldName, int itemNo, int recordNo) throws Exception {
        if (!ruleObject.has(fieldName)) {
            throw new Exception(new StringBuilder(512).append("FIELD ").append(fieldName).append(" is required ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        String strTimeVal = ruleObject.get(fieldName).getAsString();
        if (TStringUtils.isBlank(strTimeVal)) {
            throw new Exception(new StringBuilder(512).append("the value of FIELD ").append(fieldName).append(" is null or blank in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        int timeHour = 0;
        int timeMin = 0;
        String[] startItems = strTimeVal.split(":");
        if (startItems.length != 2 || TStringUtils.isBlank(startItems[0]) || TStringUtils.isBlank(startItems[1])) {
            throw new Exception(new StringBuilder(512).append("illegal format, the value of FIELD ").append(fieldName).append(" must be 'aa:bb' and 'aa','bb' must be int value ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        try {
            timeHour = Integer.parseInt(startItems[0]);
        }
        catch (Throwable e2) {
            throw new Exception(new StringBuilder(512).append("illegal format, the value of FIELD ").append(fieldName).append(" must be 'aa:bb' and 'aa' must be int value ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        try {
            timeMin = Integer.parseInt(startItems[1]);
        }
        catch (Throwable e2) {
            throw new Exception(new StringBuilder(512).append("illegal format, the value of FIELD ").append(fieldName).append(" must be 'aa:bb' and 'bb' must be int value ").append("in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (timeHour < 0 || timeHour > 24) {
            throw new Exception(new StringBuilder(512).append("illegal value, the value of FIELD ").append(fieldName).append("-hour value must in [0,23] in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        if (timeMin < 0 || timeMin > 59) {
            throw new Exception(new StringBuilder(512).append("illegal value, the value of FIELD ").append(fieldName).append("-minute value must in [0,59] in data_limit item(").append(itemNo).append(").record(").append(recordNo).append(") of flowCtrlInfo value!").toString());
        }
        return timeHour * 100 + timeMin;
    }
}

