/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.consumer;

import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.consumer.ConsumeOffsetInfo;
import org.apache.inlong.tubemq.client.consumer.PartitionExt;
import org.apache.inlong.tubemq.client.consumer.PartitionSelectResult;
import org.apache.inlong.tubemq.corebase.cluster.BrokerInfo;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.apache.inlong.tubemq.corebase.cluster.SubscribeInfo;
import org.apache.inlong.tubemq.corebase.policies.FlowCtrlRuleHandler;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientBroker;
import org.apache.inlong.tubemq.corebase.protobuf.generated.ClientMaster;
import org.apache.inlong.tubemq.corebase.rv.ProcessResult;
import org.apache.inlong.tubemq.corebase.utils.DataConverterUtil;
import org.apache.inlong.tubemq.corebase.utils.TStringUtils;
import org.apache.inlong.tubemq.corebase.utils.ThreadUtils;
import org.apache.inlong.tubemq.corebase.utils.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RmtDataCache
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RmtDataCache.class);
    private static final AtomicLong refCont = new AtomicLong(0L);
    private static Timer timer;
    private final ConsumerConfig consumerConfig;
    private final AtomicLong lstRegMasterTime = new AtomicLong(0L);
    private final AtomicBoolean isCurGroupCtrl = new AtomicBoolean(false);
    private final AtomicLong lastCheckTime = new AtomicLong(0L);
    private final FlowCtrlRuleHandler groupFlowCtrlRuleHandler = new FlowCtrlRuleHandler(false);
    private final FlowCtrlRuleHandler defFlowCtrlRuleHandler = new FlowCtrlRuleHandler(true);
    private long lastEmptyBrokerPrintTime = 0L;
    private long lastEmptyTopicPrintTime = 0L;
    private long lastBrokerUpdatedTime = System.currentTimeMillis();
    private final AtomicLong lstBrokerConfigId = new AtomicLong(-2L);
    private Map<Integer, BrokerInfo> brokersMap = new ConcurrentHashMap<Integer, BrokerInfo>();
    private final AtomicBoolean nextWithAuthInfo2M = new AtomicBoolean(false);
    private final ConcurrentHashMap<Integer, AtomicBoolean> nextWithAuthInfo2BMap = new ConcurrentHashMap();
    private final AtomicLong reqMaxOffsetCsmId = new AtomicLong(-2L);
    private final AtomicBoolean csmFromMaxOffset = new AtomicBoolean(false);
    private final AtomicLong topicMetaInfoId = new AtomicLong(-2L);
    private final Set<String> metaInfoSet = new TreeSet<String>();
    private ConcurrentHashMap<String, Tuple2<Partition, Integer>> configuredPartInfoMap = new ConcurrentHashMap();
    private final AtomicLong topicMetaUpdatedTime = new AtomicLong(-2L);
    private boolean isFirstReport = true;
    private long reportIntCount = 0L;
    private final long maxReportTimes;
    private final AtomicInteger waitCont = new AtomicInteger(0);
    private final ConcurrentHashMap<String, Timeout> timeouts = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<String> indexPartition = new ConcurrentLinkedQueue();
    private volatile long lstReportTime = 0L;
    private final AtomicLong partMapChgTime = new AtomicLong(0L);
    private final ConcurrentHashMap<String, PartitionExt> partitionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> partitionUsedMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConsumeOffsetInfo> partitionOffsetMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Long> partitionFrozenMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<Partition>> topicPartitionConMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<BrokerInfo, ConcurrentLinkedQueue<Partition>> brokerPartitionConMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Integer> partRegisterBookMap = new ConcurrentHashMap();
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private CountDownLatch dataProcessSync = new CountDownLatch(0);

    public RmtDataCache(ConsumerConfig consumerConfig, List<Partition> partitionList) {
        this.consumerConfig = consumerConfig;
        if (refCont.incrementAndGet() == 1L) {
            timer = new HashedWheelTimer();
        }
        this.maxReportTimes = (long)consumerConfig.getMaxSubInfoReportIntvlTimes() * 10L;
        HashMap<Partition, ConsumeOffsetInfo> tmpPartOffsetMap = new HashMap<Partition, ConsumeOffsetInfo>();
        if (partitionList != null) {
            for (Partition partition : partitionList) {
                tmpPartOffsetMap.put(partition, new ConsumeOffsetInfo(partition.getPartitionKey(), -2L, -2L));
            }
        }
        this.addPartitionsInfo(tmpPartOffsetMap);
    }

    public void bookBrokerRequireAuthInfo(int brokerId, ClientBroker.HeartBeatResponseB2C heartBeatResponseV2) {
        if (!heartBeatResponseV2.hasRequireAuth()) {
            return;
        }
        AtomicBoolean authStatus = this.nextWithAuthInfo2BMap.get(brokerId);
        if (authStatus == null) {
            AtomicBoolean tmpAuthStatus = new AtomicBoolean(false);
            authStatus = this.nextWithAuthInfo2BMap.putIfAbsent(brokerId, tmpAuthStatus);
            if (authStatus == null) {
                authStatus = tmpAuthStatus;
            }
        }
        authStatus.set(heartBeatResponseV2.getRequireAuth());
    }

    public void updOpsTaskInfo(ClientMaster.OpsTaskInfo opsTaskInfo, StringBuilder strBuff) {
        if (opsTaskInfo == null) {
            return;
        }
        if (opsTaskInfo.hasGroupFlowCheckId() && opsTaskInfo.getGroupFlowCheckId() >= 0L && opsTaskInfo.getGroupFlowCheckId() != this.groupFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.groupFlowCtrlRuleHandler.updateFlowCtrlInfo(opsTaskInfo.getQryPriorityId(), opsTaskInfo.getGroupFlowCheckId(), opsTaskInfo.getGroupFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse group flowCtrl rules failure", e1);
            }
        }
        if (opsTaskInfo.hasDefFlowCheckId() && opsTaskInfo.getDefFlowCheckId() >= 0L && opsTaskInfo.getDefFlowCheckId() != this.defFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.defFlowCtrlRuleHandler.updateFlowCtrlInfo(-2, opsTaskInfo.getDefFlowCheckId(), opsTaskInfo.getDefFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse default flowCtrl rules failure", e1);
            }
        }
        if (opsTaskInfo.hasCsmFrmMaxOffsetCtrlId() && opsTaskInfo.getCsmFrmMaxOffsetCtrlId() >= 0L && this.reqMaxOffsetCsmId.get() != opsTaskInfo.getCsmFrmMaxOffsetCtrlId()) {
            this.reqMaxOffsetCsmId.set(opsTaskInfo.getCsmFrmMaxOffsetCtrlId());
            if (opsTaskInfo.getCsmFrmMaxOffsetCtrlId() > this.lstRegMasterTime.get()) {
                this.csmFromMaxOffset.set(true);
            }
        }
        if (opsTaskInfo.hasRequireAuth()) {
            this.storeMasterAuthRequire(opsTaskInfo.getRequireAuth());
        }
    }

    public void updFlowCtrlInfoInfo(ClientMaster.RegisterResponseM2C response, StringBuilder strBuff) {
        if (response == null) {
            return;
        }
        if (response.hasGroupFlowCheckId() && response.getGroupFlowCheckId() >= 0L && response.getGroupFlowCheckId() != this.groupFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.groupFlowCtrlRuleHandler.updateFlowCtrlInfo(response.getQryPriorityId(), response.getGroupFlowCheckId(), response.getGroupFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse group flowCtrl rules failure", e1);
            }
        }
        if (response.hasDefFlowCheckId() && response.getDefFlowCheckId() >= 0L && response.getDefFlowCheckId() != this.defFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.defFlowCtrlRuleHandler.updateFlowCtrlInfo(-2, response.getDefFlowCheckId(), response.getDefFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse default flowCtrl rules failure", e1);
            }
        }
    }

    public void updFlowCtrlInfoInfo(ClientMaster.HeartResponseM2C response, StringBuilder strBuff) {
        if (response == null) {
            return;
        }
        if (response.hasGroupFlowCheckId() && response.getGroupFlowCheckId() >= 0L && response.getGroupFlowCheckId() != this.groupFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.groupFlowCtrlRuleHandler.updateFlowCtrlInfo(response.getQryPriorityId(), response.getGroupFlowCheckId(), response.getGroupFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse group flowCtrl rules failure", e1);
            }
        }
        if (response.hasDefFlowCheckId() && response.getDefFlowCheckId() >= 0L && response.getDefFlowCheckId() != this.defFlowCtrlRuleHandler.getFlowCtrlId()) {
            try {
                this.defFlowCtrlRuleHandler.updateFlowCtrlInfo(-2, response.getDefFlowCheckId(), response.getDefFlowControlInfo(), strBuff);
            }
            catch (Exception e1) {
                logger.warn("[Remote Data Cache] found parse default flowCtrl rules failure", e1);
            }
        }
    }

    public boolean isCsmFromMaxOffset() {
        if (this.csmFromMaxOffset.get()) {
            return this.csmFromMaxOffset.compareAndSet(true, false);
        }
        return false;
    }

    public int getQryPriorityId() {
        return this.groupFlowCtrlRuleHandler.getQryPriorityId();
    }

    public long getDefFlowCtrlId() {
        return this.defFlowCtrlRuleHandler.getFlowCtrlId();
    }

    public long getGroupFlowCtrlId() {
        return this.groupFlowCtrlRuleHandler.getFlowCtrlId();
    }

    public void storeTopicMetaInfo(long curTopicMetaInfoId, List<String> curMetaInfoSet) {
        if (curTopicMetaInfoId < 0L || curTopicMetaInfoId == this.topicMetaInfoId.get()) {
            return;
        }
        if (curMetaInfoSet == null || curMetaInfoSet.isEmpty()) {
            return;
        }
        ConcurrentHashMap<String, Tuple2<Partition, Integer>> curConfMetaInfoMap = new ConcurrentHashMap<String, Tuple2<Partition, Integer>>();
        for (String metaInfo : curMetaInfoSet) {
            String[] strPartInfoSet;
            if (TStringUtils.isBlank(metaInfo)) continue;
            String[] strInfo = metaInfo.split("#");
            for (String partStr : strPartInfoSet = strInfo[1].split(",")) {
                String[] strPartInfo = partStr.split(":");
                BrokerInfo brokerInfo = this.brokersMap.get(Integer.parseInt(strPartInfo[0]));
                if (brokerInfo == null) continue;
                int storeId = Integer.parseInt(strPartInfo[1]);
                int partCnt = Integer.parseInt(strPartInfo[2]);
                int statusId = Integer.parseInt(strPartInfo[3]);
                for (int j = 0; j < storeId; ++j) {
                    int baseValue = j * 10000;
                    for (int i = 0; i < partCnt; ++i) {
                        Partition partition = new Partition(brokerInfo, strInfo[0], baseValue + i);
                        curConfMetaInfoMap.put(partition.getPartitionKey(), new Tuple2<Partition, Integer>(partition, statusId));
                    }
                }
            }
        }
        if (curConfMetaInfoMap.isEmpty()) {
            return;
        }
        this.metaInfoSet.clear();
        this.metaInfoSet.addAll(curMetaInfoSet);
        this.configuredPartInfoMap = curConfMetaInfoMap;
        this.topicMetaUpdatedTime.set(System.currentTimeMillis());
        this.topicMetaInfoId.set(curTopicMetaInfoId);
    }

    public Map<String, Boolean> getConfPartMetaInfo() {
        HashMap<String, Boolean> configMap = new HashMap<String, Boolean>();
        for (Map.Entry<String, Tuple2<Partition, Integer>> entry : this.configuredPartInfoMap.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            configMap.put(entry.getKey(), entry.getValue().getF1() == 1);
        }
        return configMap;
    }

    public boolean isPartSubscribable(String partitionKey) {
        Tuple2<Partition, Integer> partConfig = this.configuredPartInfoMap.get(partitionKey);
        if (partConfig == null || partConfig.getF0() == null || partConfig.getF1() == null) {
            return false;
        }
        return partConfig.getF1() == 1;
    }

    public boolean getSubscribablePartition(String partitionKey, ProcessResult result, StringBuilder sBuffer) {
        Tuple2<Partition, Integer> partStatusInfo = this.configuredPartInfoMap.get(partitionKey);
        if (partStatusInfo == null) {
            result.setFailResult(404, sBuffer.append("PartitionKey ").append(partitionKey).append(" not found in partition-meta Information set!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        if (partStatusInfo.getF1() != 1) {
            result.setFailResult(422, sBuffer.append("PartitionKey ").append(partitionKey).append(" not available for subscription now!").toString());
            sBuffer.delete(0, sBuffer.length());
            return result.isSuccess();
        }
        result.setSuccResult(partStatusInfo.getF0());
        return true;
    }

    public void updateReg2MasterTime() {
        this.lstRegMasterTime.set(System.currentTimeMillis());
    }

    public long getRegMasterTime() {
        return this.lstRegMasterTime.get();
    }

    public void updateBrokerInfoList(long pkgCheckSum, List<String> pkgBrokerInfos, StringBuilder sBuilder) {
        if (pkgCheckSum != this.lstBrokerConfigId.get() && pkgBrokerInfos != null) {
            this.brokersMap = DataConverterUtil.convertBrokerInfo(pkgBrokerInfos, this.consumerConfig.isTlsEnable());
            this.lstBrokerConfigId.set(pkgCheckSum);
            this.lastBrokerUpdatedTime = System.currentTimeMillis();
            if (pkgBrokerInfos.isEmpty()) {
                if (System.currentTimeMillis() - this.lastEmptyBrokerPrintTime > 60000L) {
                    logger.warn(sBuilder.append("[Meta Info] Found empty brokerList, changed checksum is ").append(this.lstBrokerConfigId).toString());
                    sBuilder.delete(0, sBuilder.length());
                    this.lastEmptyBrokerPrintTime = System.currentTimeMillis();
                }
            } else {
                logger.info(sBuilder.append("[Meta Info] Changed brokerList checksum is ").append(this.lstBrokerConfigId).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
    }

    public void storeMasterAuthRequire(boolean requireAuth) {
        this.nextWithAuthInfo2M.set(requireAuth);
    }

    public boolean markAndGetAuthStatus(boolean isForce) {
        boolean needAuth = false;
        if (isForce) {
            this.nextWithAuthInfo2M.set(false);
        } else if (this.nextWithAuthInfo2M.get() && this.nextWithAuthInfo2M.compareAndSet(true, false)) {
            needAuth = true;
        }
        return needAuth;
    }

    public boolean markAndGetBrokerAuthStatus(int brokerId, boolean isForce) {
        boolean needAuth = false;
        AtomicBoolean authStatus = this.nextWithAuthInfo2BMap.get(brokerId);
        if (authStatus == null) {
            AtomicBoolean tmpAuthStatus = new AtomicBoolean(false);
            authStatus = this.nextWithAuthInfo2BMap.putIfAbsent(brokerId, tmpAuthStatus);
            if (authStatus == null) {
                authStatus = tmpAuthStatus;
            }
        }
        if (isForce) {
            needAuth = true;
            authStatus.set(false);
        } else if (authStatus.get() && authStatus.compareAndSet(true, false)) {
            needAuth = true;
        }
        return needAuth;
    }

    public ClientMaster.OpsTaskInfo buildOpsTaskInfo() {
        boolean hasData = false;
        ClientMaster.OpsTaskInfo.Builder builder = ClientMaster.OpsTaskInfo.newBuilder();
        if (this.defFlowCtrlRuleHandler.getFlowCtrlId() >= 0L) {
            builder.setDefFlowCheckId(this.defFlowCtrlRuleHandler.getFlowCtrlId());
            hasData = true;
        }
        if (this.groupFlowCtrlRuleHandler.getFlowCtrlId() >= 0L) {
            builder.setGroupFlowCheckId(this.groupFlowCtrlRuleHandler.getFlowCtrlId());
            hasData = true;
        }
        if (this.groupFlowCtrlRuleHandler.getQryPriorityId() >= 0) {
            builder.setQryPriorityId(this.groupFlowCtrlRuleHandler.getQryPriorityId());
            hasData = true;
        }
        if (this.reqMaxOffsetCsmId.get() >= 0L) {
            builder.setCsmFrmMaxOffsetCtrlId(this.reqMaxOffsetCsmId.get());
            hasData = true;
        }
        if (hasData) {
            return builder.build();
        }
        return null;
    }

    public ClientMaster.ClientSubRepInfo buildClientSubRepInfo() {
        ClientMaster.ClientSubRepInfo.Builder builder = ClientMaster.ClientSubRepInfo.newBuilder();
        builder.setBrokerConfigId(this.lstBrokerConfigId.get());
        builder.setTopicMetaInfoId(this.topicMetaInfoId.get());
        if (this.topicMetaUpdatedTime.get() >= 0L) {
            builder.setLstAssignedTime(this.topicMetaUpdatedTime.get());
        }
        builder.setReportSubInfo(false);
        if (this.isFirstReport) {
            if (!this.partitionMap.isEmpty()) {
                this.isFirstReport = false;
                builder.setReportSubInfo(true);
                this.lstReportTime = this.partMapChgTime.get();
                builder.addAllPartSubInfo(this.getSubscribedPartitionInfo());
            }
        } else if (this.lstReportTime != this.partMapChgTime.get() || ++this.reportIntCount % this.maxReportTimes == 0L) {
            builder.setReportSubInfo(true);
            this.lstReportTime = this.partMapChgTime.get();
            builder.addAllPartSubInfo(this.getSubscribedPartitionInfo());
        }
        return builder.build();
    }

    public long getLastBrokerConfigId() {
        return this.lstBrokerConfigId.get();
    }

    public long getlastTopicMetaInfoId() {
        return this.topicMetaInfoId.get();
    }

    public boolean isCurGroupInFlowCtrl() {
        long curCheckTime = this.lastCheckTime.get();
        if (System.currentTimeMillis() - curCheckTime >= 10000L && this.lastCheckTime.compareAndSet(curCheckTime, System.currentTimeMillis())) {
            this.isCurGroupCtrl.set(this.groupFlowCtrlRuleHandler.getCurDataLimit(Long.MAX_VALUE) != null);
        }
        return this.isCurGroupCtrl.get();
    }

    public void setPartitionContextInfo(String partitionKey, long currOffset, int reqProcType, int errCode, boolean isEscLimit, int msgSize, long limitDlt, long curDataDlt, boolean isRequireSlow, long maxOffset) {
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null) {
            this.updateOffsetCache(partitionKey, currOffset, maxOffset);
            partitionExt.setPullTempData(reqProcType, errCode, isEscLimit, msgSize, limitDlt, curDataDlt, isRequireSlow);
        }
    }

    public boolean isPartitionsReady(long maxWaitTime) {
        long currTime = System.currentTimeMillis();
        while (!this.isClosed.get()) {
            if (!this.partitionMap.isEmpty()) {
                return true;
            }
            ThreadUtils.sleep(250L);
            if (System.currentTimeMillis() - currTime > maxWaitTime) continue;
        }
        return !this.partitionMap.isEmpty();
    }

    public PartitionSelectResult getCurrPartsStatus() {
        if (this.isClosed.get()) {
            return new PartitionSelectResult(false, 400, "Client instance has been shutdown!");
        }
        if (this.partitionMap.isEmpty()) {
            return new PartitionSelectResult(false, 406, "No partition info in local, please wait and try later");
        }
        if (this.indexPartition.isEmpty()) {
            if (!this.timeouts.isEmpty()) {
                return new PartitionSelectResult(false, 407, "All partition in waiting, retry later!");
            }
            if (!this.partitionUsedMap.isEmpty()) {
                return new PartitionSelectResult(false, 408, "No idle partition to consume, please wait and try later");
            }
            return new PartitionSelectResult(false, 405, "All partition are frozen to consume, please unfreeze partition(s) or wait");
        }
        return new PartitionSelectResult(true, 200, "OK");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionSelectResult pullSelect() {
        PartitionSelectResult result = this.getCurrPartsStatus();
        if (!result.isSuccess()) {
            return result;
        }
        this.waitCont.incrementAndGet();
        try {
            this.rebProcessWait();
            if (this.isClosed.get()) {
                PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 400, "Client instance has been shutdown!");
                return partitionSelectResult;
            }
            if (this.partitionMap.isEmpty()) {
                PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 406, "No partition info in local, please wait and try later");
                return partitionSelectResult;
            }
            String key = this.indexPartition.poll();
            if (key == null) {
                if (this.hasPartitionWait()) {
                    PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 407, "All partition in waiting, retry later!");
                    return partitionSelectResult;
                }
                if (!this.partitionUsedMap.isEmpty()) {
                    PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 408, "No idle partition to consume, please wait and try later");
                    return partitionSelectResult;
                }
                PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 405, "All partition are frozen to consume, please unfreeze partition(s) or wait");
                return partitionSelectResult;
            }
            PartitionExt partitionExt = this.partitionMap.get(key);
            if (partitionExt == null) {
                PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 400, "No valid partition to consume, retry later 1");
                return partitionSelectResult;
            }
            long curTime = System.currentTimeMillis();
            Long newTime = this.partitionUsedMap.putIfAbsent(key, curTime);
            if (newTime != null) {
                PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 400, "No valid partition to consume, retry later 2");
                return partitionSelectResult;
            }
            PartitionSelectResult partitionSelectResult = new PartitionSelectResult(true, 200, "Ok!", partitionExt, curTime, partitionExt.getAndResetLastPackConsumed());
            return partitionSelectResult;
        }
        catch (Throwable e1) {
            PartitionSelectResult partitionSelectResult = new PartitionSelectResult(false, 400, new StringBuilder(256).append("Wait partition to consume abnormal : ").append(e1.getMessage()).toString());
            return partitionSelectResult;
        }
        finally {
            this.waitCont.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionSelectResult pushSelect() {
        while (!this.isClosed.get() && this.partitionMap.isEmpty()) {
            ThreadUtils.sleep(300L);
        }
        if (this.isClosed.get()) {
            return null;
        }
        this.waitCont.incrementAndGet();
        try {
            this.rebProcessWait();
            if (this.isClosed.get()) {
                PartitionSelectResult partitionSelectResult = null;
                return partitionSelectResult;
            }
            int cycleCnt = 0;
            String key = null;
            while ((this.indexPartition.isEmpty() || (key = this.indexPartition.poll()) == null) && !this.isClosed.get()) {
                ThreadUtils.sleep(300L);
                if (cycleCnt++ < 500) continue;
            }
            if (key == null) {
                PartitionSelectResult partitionSelectResult = null;
                return partitionSelectResult;
            }
            PartitionExt partitionExt = this.partitionMap.get(key);
            if (partitionExt == null) {
                PartitionSelectResult partitionSelectResult = null;
                return partitionSelectResult;
            }
            long curTime = System.currentTimeMillis();
            Long newTime = this.partitionUsedMap.putIfAbsent(key, curTime);
            if (newTime != null) {
                PartitionSelectResult partitionSelectResult = null;
                return partitionSelectResult;
            }
            PartitionSelectResult partitionSelectResult = new PartitionSelectResult(partitionExt, curTime, partitionExt.getAndResetLastPackConsumed());
            return partitionSelectResult;
        }
        catch (Throwable e1) {
            PartitionSelectResult partitionSelectResult = null;
            return partitionSelectResult;
        }
        finally {
            this.waitCont.decrementAndGet();
        }
    }

    protected boolean isPartitionInUse(String partitionKey, long usedToken) {
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null) {
            Long curToken = this.partitionUsedMap.get(partitionKey);
            return curToken != null && curToken == usedToken;
        }
        return false;
    }

    public boolean isPartitionInUse(String partitionKey) {
        return this.partitionMap.get(partitionKey) != null;
    }

    public Partition getPartitionByKey(String partitionKey) {
        return this.partitionMap.get(partitionKey);
    }

    public void addPartition(Partition partition, long currOffset, long maxOffset) {
        if (partition == null) {
            return;
        }
        HashMap<Partition, ConsumeOffsetInfo> tmpPartOffsetMap = new HashMap<Partition, ConsumeOffsetInfo>();
        tmpPartOffsetMap.put(partition, new ConsumeOffsetInfo(partition.getPartitionKey(), currOffset, maxOffset));
        this.addPartitionsInfo(tmpPartOffsetMap);
    }

    public boolean bookPartition(String partitionKey) {
        Integer isReged = this.partRegisterBookMap.get(partitionKey);
        if (isReged == null) {
            isReged = this.partRegisterBookMap.putIfAbsent(partitionKey, 1);
            return isReged == null;
        }
        return false;
    }

    protected void errReqRelease(String partitionKey, long usedToken, boolean isLastPackConsumed) {
        Long oldUsedToken;
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null && !this.indexPartition.contains(partitionKey) && !this.isTimeWait(partitionKey) && (oldUsedToken = this.partitionUsedMap.get(partitionKey)) != null && oldUsedToken == usedToken && (oldUsedToken = this.partitionUsedMap.remove(partitionKey)) != null) {
            partitionExt.setLastPackConsumed(isLastPackConsumed);
            this.releaseIdlePartition(partitionKey);
        }
    }

    protected void succRspRelease(String partitionKey, String topicName, long usedToken, boolean isLastPackConsumed, boolean isFilterConsume, long currOffset, long maxOffset) {
        Long oldUsedToken;
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null && !this.indexPartition.contains(partitionKey) && !this.isTimeWait(partitionKey) && (oldUsedToken = this.partitionUsedMap.get(partitionKey)) != null && oldUsedToken == usedToken) {
            this.updateOffsetCache(partitionKey, currOffset, maxOffset);
            oldUsedToken = this.partitionUsedMap.remove(partitionKey);
            if (oldUsedToken != null) {
                partitionExt.setLastPackConsumed(isLastPackConsumed);
                long waitDlt = partitionExt.procConsumeResult(isFilterConsume);
                this.releaseIdlePartition(waitDlt, partitionKey);
            }
        }
    }

    public void errRspRelease(String partitionKey, String topicName, long usedToken, boolean isLastPackConsumed, long currOffset, int reqProcType, int errCode, boolean isEscLimit, int msgSize, long limitDlt, boolean isFilterConsume, long curDataDlt, long maxOffset) {
        Long oldUsedToken;
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null && !this.indexPartition.contains(partitionKey) && !this.isTimeWait(partitionKey) && (oldUsedToken = this.partitionUsedMap.get(partitionKey)) != null && oldUsedToken == usedToken) {
            this.updateOffsetCache(partitionKey, currOffset, maxOffset);
            oldUsedToken = this.partitionUsedMap.remove(partitionKey);
            if (oldUsedToken != null) {
                partitionExt.setLastPackConsumed(isLastPackConsumed);
                long waitDlt = partitionExt.procConsumeResult(isFilterConsume, reqProcType, errCode, msgSize, isEscLimit, limitDlt, curDataDlt, false);
                this.releaseIdlePartition(waitDlt, partitionKey);
            }
        }
    }

    public void updPartOffsetInfo(String partitionKey, long currOffset, long maxOffset) {
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        if (partitionExt != null) {
            this.updateOffsetCache(partitionKey, currOffset, maxOffset);
        }
    }

    private void releaseIdlePartition(long waitDlt, String partitionKey) {
        Long frozenTime = this.partitionFrozenMap.get(partitionKey);
        if (frozenTime == null) {
            if (waitDlt > 10L) {
                TimeoutTask timeoutTask = new TimeoutTask(partitionKey);
                this.timeouts.put(partitionKey, timer.newTimeout(timeoutTask, waitDlt, TimeUnit.MILLISECONDS));
            } else {
                this.releaseIdlePartition(partitionKey);
            }
        }
    }

    private void releaseIdlePartition(String partitionKey) {
        Long frozenTime = this.partitionFrozenMap.get(partitionKey);
        PartitionExt partitionExt = this.partitionMap.get(partitionKey);
        Timeout timeout = this.timeouts.get(partitionKey);
        Long usedTime = this.partitionUsedMap.get(partitionKey);
        if (partitionExt == null || frozenTime != null || timeout != null || usedTime != null) {
            return;
        }
        if (!this.indexPartition.contains(partitionKey)) {
            try {
                this.indexPartition.offer(partitionKey);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.isClosed.compareAndSet(false, true)) {
            if (refCont.decrementAndGet() == 0L) {
                timer.stop();
                timer = null;
            }
            int cnt = 5;
            while (this.waitCont.get() > 0) {
                ThreadUtils.sleep(200L);
                if (--cnt > 0) continue;
                break;
            }
        }
    }

    public List<SubscribeInfo> getSubscribeInfoList(String consumerId, String consumeGroup) {
        ArrayList<SubscribeInfo> subscribeInfoList = new ArrayList<SubscribeInfo>();
        for (Partition partition : this.partitionMap.values()) {
            if (partition == null) continue;
            subscribeInfoList.add(new SubscribeInfo(consumerId, consumeGroup, partition));
        }
        return subscribeInfoList;
    }

    private List<String> getSubscribedPartitionInfo() {
        ArrayList<String> strSubInfoList = new ArrayList<String>();
        HashMap<String, StringBuilder> tmpSubInfoMap = new HashMap<String, StringBuilder>();
        for (Partition partition : this.partitionMap.values()) {
            if (partition == null) continue;
            StringBuilder sBuffer = (StringBuilder)tmpSubInfoMap.get(partition.getTopic());
            if (sBuffer == null) {
                sBuffer = new StringBuilder(512);
                tmpSubInfoMap.put(partition.getTopic(), sBuffer);
                sBuffer.append(partition.getTopic()).append("#");
            } else {
                sBuffer.append(",");
            }
            sBuffer.append(partition.getBrokerId()).append(":").append(partition.getPartitionId());
        }
        for (Map.Entry entry : tmpSubInfoMap.entrySet()) {
            strSubInfoList.add(((StringBuilder)entry.getValue()).toString());
        }
        return strSubInfoList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<BrokerInfo, List<PartitionSelectResult>> removeAndGetPartition(Map<BrokerInfo, List<Partition>> unRegisterInfoMap, List<String> partitionKeys, long inUseWaitPeriodMs, boolean isWaitTimeoutRollBack) {
        StringBuilder sBuilder = new StringBuilder(512);
        HashMap<BrokerInfo, List<PartitionSelectResult>> unNewRegisterInfoMap = new HashMap<BrokerInfo, List<PartitionSelectResult>>();
        this.pauseProcess();
        try {
            this.waitPartitions(partitionKeys, inUseWaitPeriodMs);
            boolean lastPackConsumed = false;
            for (Map.Entry<BrokerInfo, List<Partition>> entry : unRegisterInfoMap.entrySet()) {
                for (Partition partition : entry.getValue()) {
                    ConcurrentLinkedQueue<Partition> regMapPartitionList;
                    ConcurrentLinkedQueue<Partition> oldPartitionList;
                    PartitionExt partitionExt = this.rmvPartitionFromMap(partition.getPartitionKey());
                    if (partitionExt == null) continue;
                    lastPackConsumed = partitionExt.isLastPackConsumed();
                    if (!this.cancelTimeTask(partition.getPartitionKey()) && !this.indexPartition.remove(partition.getPartitionKey())) {
                        logger.info(sBuilder.append("[Process Interrupt] Partition : ").append(partition.toString()).append(", data in processing, canceled").toString());
                        sBuilder.delete(0, sBuilder.length());
                        if (lastPackConsumed && isWaitTimeoutRollBack) {
                            lastPackConsumed = false;
                        }
                    }
                    if ((oldPartitionList = this.topicPartitionConMap.get(partition.getTopic())) != null) {
                        oldPartitionList.remove(partition);
                        if (oldPartitionList.isEmpty()) {
                            this.topicPartitionConMap.remove(partition.getTopic());
                        }
                    }
                    if ((regMapPartitionList = this.brokerPartitionConMap.get(entry.getKey())) != null) {
                        regMapPartitionList.remove(partition);
                        if (regMapPartitionList.isEmpty()) {
                            this.brokerPartitionConMap.remove(entry.getKey());
                        }
                    }
                    this.partitionOffsetMap.remove(partition.getPartitionKey());
                    this.partitionUsedMap.remove(partition.getPartitionKey());
                    PartitionSelectResult partitionRet = new PartitionSelectResult(true, 200, "Ok!", partition, 0L, lastPackConsumed);
                    List targetPartitionList = unNewRegisterInfoMap.computeIfAbsent(entry.getKey(), k -> new ArrayList());
                    targetPartitionList.add(partitionRet);
                }
            }
        }
        finally {
            this.resumeProcess();
        }
        return unNewRegisterInfoMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAndGetPartition(String partitionKey, long inUseWaitPeriodMs, boolean isWaitTimeoutRollBack, ProcessResult result, StringBuilder sBuffer) {
        boolean lastPackConsumed = false;
        ArrayList<String> partitionKeys = new ArrayList<String>();
        partitionKeys.add(partitionKey);
        this.pauseProcess();
        try {
            ConcurrentLinkedQueue<Partition> regMapPartitionList;
            ConcurrentLinkedQueue<Partition> oldPartitionList;
            this.waitPartitions(partitionKeys, inUseWaitPeriodMs);
            PartitionExt partitionExt = this.rmvPartitionFromMap(partitionKey);
            if (partitionExt == null) {
                result.setSuccResult(null);
                boolean bl = result.isSuccess();
                return bl;
            }
            lastPackConsumed = partitionExt.isLastPackConsumed();
            if (!this.cancelTimeTask(partitionKey) && !this.indexPartition.remove(partitionKey)) {
                logger.info(sBuffer.append("[Process Interrupt] Partition : ").append(partitionExt.toString()).append(", data in processing, canceled").toString());
                sBuffer.delete(0, sBuffer.length());
                if (lastPackConsumed && isWaitTimeoutRollBack) {
                    lastPackConsumed = false;
                }
            }
            if ((oldPartitionList = this.topicPartitionConMap.get(partitionExt.getTopic())) != null) {
                oldPartitionList.remove(partitionExt);
                if (oldPartitionList.isEmpty()) {
                    this.topicPartitionConMap.remove(partitionExt.getTopic());
                }
            }
            if ((regMapPartitionList = this.brokerPartitionConMap.get(partitionExt.getBroker())) != null) {
                regMapPartitionList.remove(partitionExt);
                if (regMapPartitionList.isEmpty()) {
                    this.brokerPartitionConMap.remove(partitionExt.getBroker());
                }
            }
            this.partitionOffsetMap.remove(partitionKey);
            this.partitionUsedMap.remove(partitionKey);
            partitionExt.setLastPackConsumed(lastPackConsumed);
            result.setSuccResult(partitionExt);
            boolean bl = result.isSuccess();
            return bl;
        }
        finally {
            this.resumeProcess();
        }
    }

    public void removePartition(Partition partition) {
        ConcurrentLinkedQueue<Partition> regMapPartitionList;
        this.rmvPartitionFromMap(partition.getPartitionKey());
        this.cancelTimeTask(partition.getPartitionKey());
        this.indexPartition.remove(partition.getPartitionKey());
        this.partitionUsedMap.remove(partition.getPartitionKey());
        this.partitionOffsetMap.remove(partition.getPartitionKey());
        ConcurrentLinkedQueue<Partition> oldPartitionList = this.topicPartitionConMap.get(partition.getTopic());
        if (oldPartitionList != null) {
            oldPartitionList.remove(partition);
            if (oldPartitionList.isEmpty()) {
                this.topicPartitionConMap.remove(partition.getTopic());
            }
        }
        if ((regMapPartitionList = this.brokerPartitionConMap.get(partition.getBroker())) != null) {
            regMapPartitionList.remove(partition);
            if (regMapPartitionList.isEmpty()) {
                this.brokerPartitionConMap.remove(partition.getBroker());
            }
        }
    }

    public Set<String> getCurRegisteredPartSet() {
        TreeSet<String> partKeySet = new TreeSet<String>();
        for (String partKey : this.partitionMap.keySet()) {
            if (partKey == null) continue;
            partKeySet.add(partKey);
        }
        return partKeySet;
    }

    public Map<String, ConsumeOffsetInfo> getCurPartitionInfoMap() {
        ConcurrentHashMap<String, ConsumeOffsetInfo> tmpPartitionMap = new ConcurrentHashMap<String, ConsumeOffsetInfo>();
        for (Map.Entry<String, PartitionExt> entry : this.partitionMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ConsumeOffsetInfo offsetInfo = this.partitionOffsetMap.get(entry.getKey());
            tmpPartitionMap.put(entry.getKey(), new ConsumeOffsetInfo(entry.getKey(), offsetInfo.getCurrOffset(), offsetInfo.getMaxOffset(), offsetInfo.getUpdateTime()));
        }
        return tmpPartitionMap;
    }

    public long getMaxOffsetOfPartition(String partitionKey) {
        ConsumeOffsetInfo offsetInfo = this.partitionOffsetMap.get(partitionKey);
        if (offsetInfo == null) {
            return -1L;
        }
        return offsetInfo.getMaxOffset();
    }

    public Map<BrokerInfo, List<PartitionSelectResult>> getAllPartitionListWithStatus() {
        HashMap<BrokerInfo, List<PartitionSelectResult>> registeredInfoMap = new HashMap<BrokerInfo, List<PartitionSelectResult>>();
        for (PartitionExt partitionExt : this.partitionMap.values()) {
            List registerPartitionList = registeredInfoMap.computeIfAbsent(partitionExt.getBroker(), k -> new ArrayList());
            registerPartitionList.add(new PartitionSelectResult(true, 200, "Ok!", partitionExt, 0L, partitionExt.isLastPackConsumed()));
        }
        return registeredInfoMap;
    }

    public Set<BrokerInfo> getAllRegisterBrokers() {
        return this.brokerPartitionConMap.keySet();
    }

    public List<Partition> getBrokerPartitionList(BrokerInfo brokerInfo) {
        ArrayList<Partition> retPartition = new ArrayList<Partition>();
        ConcurrentLinkedQueue<Partition> partitionList = this.brokerPartitionConMap.get(brokerInfo);
        if (partitionList != null) {
            retPartition.addAll(partitionList);
        }
        return retPartition;
    }

    public void filterCachedPartitionInfo(Map<BrokerInfo, List<Partition>> registerInfoMap, List<Partition> unRegPartitionList) {
        ArrayList<BrokerInfo> brokerInfoList = new ArrayList<BrokerInfo>();
        for (Map.Entry<BrokerInfo, List<Partition>> entry : registerInfoMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            ConcurrentLinkedQueue<Partition> partitionList = this.brokerPartitionConMap.get(entry.getKey());
            if (partitionList == null || partitionList.isEmpty()) {
                unRegPartitionList.addAll((Collection<Partition>)entry.getValue());
                continue;
            }
            boolean isNewBroker = true;
            for (Partition regPartition : entry.getValue()) {
                if (partitionList.contains(regPartition)) continue;
                unRegPartitionList.add(regPartition);
                isNewBroker = false;
            }
            if (!isNewBroker) continue;
            brokerInfoList.add(entry.getKey());
        }
        for (BrokerInfo brokerInfo : brokerInfoList) {
            registerInfoMap.remove(brokerInfo);
        }
    }

    public ConcurrentLinkedQueue<Partition> getPartitionByBroker(BrokerInfo brokerInfo) {
        return this.brokerPartitionConMap.get(brokerInfo);
    }

    public void resumeTimeoutConsumePartitions(boolean isPullConsume, long allowedPeriodTimes) {
        if (isPullConsume && !this.partitionUsedMap.isEmpty()) {
            ArrayList partKeys = new ArrayList(this.partitionUsedMap.keySet());
            for (String keyId : partKeys) {
                PartitionExt partitionExt;
                Long oldTime = this.partitionUsedMap.get(keyId);
                if (oldTime == null || System.currentTimeMillis() - oldTime <= allowedPeriodTimes || (oldTime = this.partitionUsedMap.remove(keyId)) == null || (partitionExt = this.partitionMap.get(keyId)) == null) continue;
                partitionExt.setLastPackConsumed(false);
                this.releaseIdlePartition(keyId);
            }
        }
        if (!this.timeouts.isEmpty()) {
            Timeout timeout1 = null;
            ArrayList partKeys = new ArrayList(this.timeouts.keySet());
            for (String keyId : partKeys) {
                timeout1 = this.timeouts.get(keyId);
                if (timeout1 == null || !timeout1.isExpired() || (timeout1 = this.timeouts.remove(keyId)) == null) continue;
                this.releaseIdlePartition(keyId);
            }
        }
    }

    public void freezeOrUnFreezeParts(List<String> partitionKeys, boolean isFreeze) {
        if (partitionKeys == null || partitionKeys.isEmpty()) {
            return;
        }
        for (String partitionKey : partitionKeys) {
            if (partitionKey == null) continue;
            if (isFreeze) {
                this.partitionFrozenMap.put(partitionKey, System.currentTimeMillis());
                logger.info(new StringBuilder(512).append("[Freeze Partition] Partition : ").append(partitionKey).append(" is frozen by caller!").toString());
                continue;
            }
            Long frozenTime = this.partitionFrozenMap.remove(partitionKey);
            if (frozenTime == null) continue;
            this.releaseIdlePartition(partitionKey);
            logger.info(new StringBuilder(512).append("[UnFreeze Partition] Partition : ").append(partitionKey).append(" is unFreeze by caller!").toString());
        }
    }

    public void relAllFrozenPartitions() {
        Long frozenTime = null;
        ArrayList partKeys = new ArrayList(this.partitionFrozenMap.keySet());
        for (String partKey : partKeys) {
            frozenTime = this.partitionFrozenMap.remove(partKey);
            if (frozenTime == null) continue;
            this.releaseIdlePartition(partKey);
            logger.info(new StringBuilder(512).append("[UnFreeze Partition] Partition : ").append(partKey).append(" is unFreeze by caller-2!").toString());
        }
    }

    public Map<String, Long> getFrozenPartInfo() {
        HashMap<String, Long> tmpPartKeyMap = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : this.partitionFrozenMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null) continue;
            tmpPartKeyMap.put(entry.getKey(), entry.getValue());
        }
        return tmpPartKeyMap;
    }

    private void waitPartitions(List<String> partitionKeys, long inUseWaitPeriodMs) {
        boolean needWait = false;
        long startWaitTime = System.currentTimeMillis();
        do {
            needWait = false;
            for (String partitionKey : partitionKeys) {
                if (this.partitionUsedMap.get(partitionKey) == null) continue;
                needWait = true;
                break;
            }
            if (!needWait) continue;
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e1) {
                break;
            }
        } while (needWait && !this.isClosed.get() && System.currentTimeMillis() - startWaitTime < inUseWaitPeriodMs);
    }

    private void updateOffsetCache(String partitionKey, long currOffset, long maxOffset) {
        if (currOffset >= 0L) {
            ConsumeOffsetInfo tmpOffsetInfo;
            ConsumeOffsetInfo currOffsetInfo = this.partitionOffsetMap.get(partitionKey);
            if (currOffsetInfo == null && (tmpOffsetInfo = this.partitionOffsetMap.putIfAbsent(partitionKey, currOffsetInfo = new ConsumeOffsetInfo(partitionKey, currOffset, maxOffset))) != null) {
                currOffsetInfo = tmpOffsetInfo;
            }
            currOffsetInfo.updateOffsetInfo(currOffset, maxOffset);
        }
    }

    private void addPartitionsInfo(Map<Partition, ConsumeOffsetInfo> partOffsetMap) {
        if (partOffsetMap == null || partOffsetMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Partition, ConsumeOffsetInfo> entry : partOffsetMap.entrySet()) {
            ConcurrentLinkedQueue<Partition> brokerPartitionQue;
            Partition partition;
            if (entry.getKey() == null || entry.getValue() == null || this.partitionMap.containsKey((partition = entry.getKey()).getPartitionKey())) continue;
            ConcurrentLinkedQueue<Partition> topicPartitionQue = this.topicPartitionConMap.get(partition.getTopic());
            if (topicPartitionQue == null) {
                topicPartitionQue = new ConcurrentLinkedQueue();
                ConcurrentLinkedQueue<Partition> tmpTopicPartitionQue = this.topicPartitionConMap.putIfAbsent(partition.getTopic(), topicPartitionQue);
                if (tmpTopicPartitionQue != null) {
                    topicPartitionQue = tmpTopicPartitionQue;
                }
            }
            if (!topicPartitionQue.contains(partition)) {
                topicPartitionQue.add(partition);
            }
            if ((brokerPartitionQue = this.brokerPartitionConMap.get(partition.getBroker())) == null) {
                brokerPartitionQue = new ConcurrentLinkedQueue();
                ConcurrentLinkedQueue<Partition> tmpBrokerPartQues = this.brokerPartitionConMap.putIfAbsent(partition.getBroker(), brokerPartitionQue);
                if (tmpBrokerPartQues != null) {
                    brokerPartitionQue = tmpBrokerPartQues;
                }
            }
            if (!brokerPartitionQue.contains(partition)) {
                brokerPartitionQue.add(partition);
            }
            this.updateOffsetCache(partition.getPartitionKey(), entry.getValue().getCurrOffset(), entry.getValue().getMaxOffset());
            this.addPartitionToMap(partition.getPartitionKey(), new PartitionExt(this.groupFlowCtrlRuleHandler, this.defFlowCtrlRuleHandler, partition.getBroker(), partition.getTopic(), partition.getPartitionId()));
            this.partitionUsedMap.remove(partition.getPartitionKey());
            this.releaseIdlePartition(partition.getPartitionKey());
        }
    }

    public void rebProcessWait() {
        if (this.dataProcessSync != null && this.dataProcessSync.getCount() != 0L) {
            try {
                this.dataProcessSync.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public boolean isRebProcessing() {
        return this.dataProcessSync != null && this.dataProcessSync.getCount() != 0L;
    }

    private void addPartitionToMap(String partKey, PartitionExt partitionExt) {
        this.partitionMap.put(partKey, partitionExt);
        this.partMapChgTime.set(System.currentTimeMillis());
    }

    private PartitionExt rmvPartitionFromMap(String partKey) {
        PartitionExt tmpPartExt = this.partitionMap.remove(partKey);
        if (tmpPartExt != null) {
            this.partMapChgTime.set(System.currentTimeMillis());
        }
        return tmpPartExt;
    }

    private void pauseProcess() {
        this.dataProcessSync = new CountDownLatch(1);
    }

    private void resumeProcess() {
        this.dataProcessSync.countDown();
    }

    private boolean cancelTimeTask(String indexId) {
        Timeout timeout = this.timeouts.remove(indexId);
        if (timeout != null) {
            timeout.cancel();
            return true;
        }
        return false;
    }

    private boolean isTimeWait(String indexId) {
        return this.timeouts.get(indexId) != null;
    }

    private boolean hasPartitionWait() {
        return !this.timeouts.isEmpty();
    }

    public class TimeoutTask
    implements TimerTask {
        private String indexId;
        private long createTime = 0L;

        public TimeoutTask(String indexId) {
            this.indexId = indexId;
            this.createTime = System.currentTimeMillis();
        }

        public long getCreateTime() {
            return this.createTime;
        }

        @Override
        public void run(Timeout timeout) throws Exception {
            Timeout timeout1 = (Timeout)RmtDataCache.this.timeouts.remove(this.indexId);
            if (timeout1 != null) {
                RmtDataCache.this.releaseIdlePartition(this.indexId);
            }
        }
    }
}

