/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.consumer;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.inlong.tubemq.client.config.ConsumerConfig;
import org.apache.inlong.tubemq.client.consumer.PartitionSelectResult;
import org.apache.inlong.tubemq.client.consumer.SimplePushMessageConsumer;
import org.apache.inlong.tubemq.client.exception.TubeClientException;
import org.apache.inlong.tubemq.corebase.cluster.Partition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageFetchManager {
    private static final Logger logger = LoggerFactory.getLogger(MessageFetchManager.class);
    private final ConcurrentHashMap<Long, Integer> fetchWorkerStatusMap = new ConcurrentHashMap();
    private final ConsumerConfig consumerConfig;
    private final SimplePushMessageConsumer pushConsumer;
    private AtomicInteger managerStatus = new AtomicInteger(-1);
    private Thread[] fetchWorkerPool;

    public MessageFetchManager(ConsumerConfig consumerConfig, SimplePushMessageConsumer pushConsumer) {
        this.consumerConfig = consumerConfig;
        this.pushConsumer = pushConsumer;
    }

    public void startFetchWorkers() throws TubeClientException {
        this.pushConsumer.getBaseConsumer().checkClientRunning();
        if (this.managerStatus.get() == 1) {
            logger.info("Duplicated call startFetchWorkers, MessageFetchManager has started !");
            return;
        }
        if (!this.managerStatus.compareAndSet(-1, 1)) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder(256);
        logger.info("Starting Fetch Worker Pool !");
        this.fetchWorkerPool = new Thread[this.consumerConfig.getPushFetchThreadCnt()];
        logger.info(sBuilder.append("Prepare to start Fetch Worker Pool, total count:").append(this.fetchWorkerPool.length).toString());
        sBuilder.delete(0, sBuilder.length());
        for (int i = 0; i < this.fetchWorkerPool.length; ++i) {
            this.fetchWorkerPool[i] = new Thread(new FetchTaskWorker());
            this.fetchWorkerStatusMap.put(this.fetchWorkerPool[i].getId(), -1);
            this.fetchWorkerPool[i].setName(sBuilder.append("Fetch_Worker_").append(this.consumerConfig.getConsumerGroup()).append("-").append(i).toString());
            sBuilder.delete(0, sBuilder.length());
        }
        for (Thread thread : this.fetchWorkerPool) {
            thread.start();
        }
        logger.info("Fetch Worker Pool started !");
    }

    public boolean isShutdown() {
        return this.managerStatus.get() == 0;
    }

    public void stopFetchWorkers(boolean onlySetStatus) throws InterruptedException {
        if (onlySetStatus) {
            if (this.managerStatus.get() == 0) {
                return;
            }
            this.managerStatus.set(0);
            if (this.pushConsumer.isConsumePaused()) {
                this.pushConsumer.resumeConsume();
            }
            return;
        }
        this.managerStatus.set(0);
        if (this.fetchWorkerPool == null) {
            return;
        }
        StringBuilder sBuilder = new StringBuilder(256);
        logger.info(sBuilder.append("[STOP_FetchWorker] All fetch workers:").append(Arrays.toString(this.fetchWorkerPool)).toString());
        sBuilder.delete(0, sBuilder.length());
        if (this.pushConsumer.isConsumePaused()) {
            this.pushConsumer.resumeConsume();
        }
        logger.info("[STOP_FetchWorker] Wait all fetch workers exist:");
        if (this.waitAllFetchRequestHolds(this.consumerConfig.getPushListenerWaitPeriodMs())) {
            for (Thread thread : this.fetchWorkerPool) {
                if (thread == null) continue;
                thread.interrupt();
            }
            for (Thread thread : this.fetchWorkerPool) {
                if (thread == null) continue;
                thread.join();
                logger.info(sBuilder.append("[STOP_FetchWorker]").append(thread).toString());
                sBuilder.delete(0, sBuilder.length());
            }
        }
        this.pushConsumer.getBaseConsumer().notifyAllMessageListenerStopped();
        Thread.sleep(200L);
        logger.info("[STOP_FetchWorker] All fetch workers are stopped.");
    }

    private boolean waitAllFetchRequestHolds(long waitTimeInMills) {
        boolean haveProcessingThread = false;
        long startWaitTime = System.currentTimeMillis();
        do {
            boolean bl = haveProcessingThread = !this.fetchWorkerStatusMap.isEmpty();
            if (!haveProcessingThread) continue;
            try {
                Thread.sleep(150L);
            }
            catch (InterruptedException e1) {
                break;
            }
        } while (haveProcessingThread && System.currentTimeMillis() - startWaitTime < waitTimeInMills);
        return haveProcessingThread;
    }

    private class FetchTaskWorker
    implements Runnable {
        private FetchTaskWorker() {
        }

        @Override
        public void run() {
            StringBuilder sBuilder = new StringBuilder(256);
            Long curThreadId = Thread.currentThread().getId();
            MessageFetchManager.this.fetchWorkerStatusMap.put(curThreadId, 0);
            while (!MessageFetchManager.this.isShutdown()) {
                PartitionSelectResult partSelectResult = null;
                MessageFetchManager.this.fetchWorkerStatusMap.put(curThreadId, 0);
                try {
                    if (MessageFetchManager.this.isShutdown()) break;
                    MessageFetchManager.this.fetchWorkerStatusMap.put(curThreadId, 1);
                    MessageFetchManager.this.pushConsumer.allowConsumeWait();
                    partSelectResult = MessageFetchManager.this.pushConsumer.getBaseConsumer().pushSelectPartition();
                    if (partSelectResult == null) continue;
                    Partition partition = partSelectResult.getPartition();
                    long usedToken = partSelectResult.getUsedToken();
                    boolean isLastConsumed = partSelectResult.isLastPackConsumed();
                    if (MessageFetchManager.this.isShutdown()) {
                        MessageFetchManager.this.pushConsumer.getBaseConsumer().pushReqReleasePartition(partition.getPartitionKey(), usedToken, isLastConsumed);
                        partSelectResult = null;
                        break;
                    }
                    if (MessageFetchManager.this.pushConsumer.isConsumePaused()) {
                        boolean result = partSelectResult.isLastPackConsumed();
                        if (result) {
                            result = MessageFetchManager.this.pushConsumer.getBaseConsumer().flushLastRequest(partition);
                        }
                        MessageFetchManager.this.pushConsumer.getBaseConsumer().pushReqReleasePartition(partition.getPartitionKey(), usedToken, result);
                        partSelectResult = null;
                        continue;
                    }
                }
                catch (Throwable e) {
                    if (partSelectResult != null) {
                        MessageFetchManager.this.pushConsumer.getBaseConsumer().pushReqReleasePartition(partSelectResult.getPartition().getPartitionKey(), partSelectResult.getUsedToken(), false);
                    }
                    sBuilder.delete(0, sBuilder.length());
                    logger.warn(sBuilder.append("Thread {} has been interrupted 3.").append(Thread.currentThread().getName()).toString());
                    sBuilder.delete(0, sBuilder.length());
                }
                MessageFetchManager.this.fetchWorkerStatusMap.put(curThreadId, 2);
                if (partSelectResult == null) continue;
                MessageFetchManager.this.pushConsumer.processRequest(partSelectResult, sBuilder);
            }
            MessageFetchManager.this.fetchWorkerStatusMap.remove(curThreadId);
        }
    }
}

