/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.tubemq.client.common;

import java.time.Clock;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.inlong.tubemq.client.common.StatsConfig;
import org.apache.inlong.tubemq.client.common.StatsLevel;
import org.apache.inlong.tubemq.corebase.metric.TrafficStatsUnit;
import org.apache.inlong.tubemq.corebase.metric.impl.ESTHistogram;
import org.apache.inlong.tubemq.corebase.metric.impl.LongStatsCounter;
import org.apache.inlong.tubemq.corebase.metric.impl.SinceTime;
import org.apache.inlong.tubemq.corebase.utils.DateTimeConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientStatsInfo {
    private static final Logger logger = LoggerFactory.getLogger(ClientStatsInfo.class);
    private final boolean isProducer;
    private final String logPrefix;
    private final StatsConfig statsConfig = new StatsConfig();
    private final ClientStatsItemSet[] switchableSets = new ClientStatsItemSet[2];
    private final AtomicInteger writableIndex = new AtomicInteger(0);
    private final AtomicLong lstSelfPrintTime = new AtomicLong(0L);
    private final AtomicLong lstSnapshotTime = new AtomicLong(0L);

    public ClientStatsInfo(boolean isProducer, String clientId, StatsConfig statsConfig) {
        this.isProducer = isProducer;
        this.statsConfig.updateStatsConfig(statsConfig);
        StringBuilder strBuff = new StringBuilder(512);
        if (isProducer) {
            strBuff.append("[Producer");
        } else {
            strBuff.append("[Consumer");
        }
        this.logPrefix = strBuff.append(" Stats]: ").append("Client=").append(clientId).toString();
        this.switchableSets[0] = new ClientStatsItemSet();
        this.switchableSets[1] = new ClientStatsItemSet();
    }

    public void updStatsControlInfo(StatsLevel statsLevel, boolean enableSelfPrint) {
        this.statsConfig.updateStatsControl(statsLevel, enableSelfPrint);
    }

    public void bookReg2Master(boolean isFailure) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].regMasterCnt.incValue();
        if (isFailure) {
            this.switchableSets[this.getIndex()].regMasterFailCnt.incValue();
        }
    }

    public void bookHB2MasterTimeout() {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].regMasterTimoutCnt.incValue();
    }

    public void bookHB2MasterException() {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].hbMasterExcCnt.incValue();
    }

    public void bookReg2Broker(boolean isFailure) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].regBrokerCnt.incValue();
        if (isFailure) {
            this.switchableSets[this.getIndex()].regBrokerFailCnt.incValue();
        }
    }

    public void bookHB2BrokerTimeout() {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].regBrokerTimoutCnt.incValue();
    }

    public void bookHB2BrokerException() {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].hbBrokerExcCnt.incValue();
    }

    public void bookReturnDuration(String partitionKey, long dltTime) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        ClientStatsItemSet curItemSet = this.switchableSets[this.getIndex()];
        curItemSet.csmLatencyStats.update(dltTime);
        if (this.statsConfig.getStatsLevel() == StatsLevel.FULL) {
            curItemSet.addCsmLatencyByPartKey(partitionKey, dltTime);
        }
    }

    public void bookConfirmDuration(String partitionKey, long dltTime) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        ClientStatsItemSet curItemSet = this.switchableSets[this.getIndex()];
        curItemSet.confirmDltStats.update(dltTime);
        if (this.statsConfig.getStatsLevel() == StatsLevel.FULL) {
            curItemSet.addConfirmDltByPartKey(partitionKey, dltTime);
        }
    }

    public void bookFailRpcCall(int errCode) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        this.switchableSets[this.getIndex()].bookFailRpcCall(errCode);
    }

    public void bookSuccSendMsg(long dltTime, String topicName, String partitionKey, int msgSize) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        ClientStatsItemSet curItemSet = this.switchableSets[this.getIndex()];
        curItemSet.sendOrRecvMsg(topicName, dltTime, 1, msgSize);
        curItemSet.bookFailRpcCall(200);
        if (this.statsConfig.getStatsLevel() == StatsLevel.FULL) {
            curItemSet.addTrafficInfoByPartKey(partitionKey, dltTime, 1, msgSize);
        }
    }

    public void bookSuccGetMsg(long dltTime, String topicName, String partitionKey, int msgCnt, int msgSize) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO) {
            return;
        }
        ClientStatsItemSet curItemSet = this.switchableSets[this.getIndex()];
        curItemSet.sendOrRecvMsg(topicName, dltTime, msgCnt, msgSize);
        curItemSet.bookFailRpcCall(200);
        if (this.statsConfig.getStatsLevel() == StatsLevel.FULL) {
            curItemSet.addTrafficInfoByPartKey(partitionKey, dltTime, msgCnt, msgSize);
        }
    }

    public void selfPrintStatsInfo(boolean forcePrint, boolean needReset, StringBuilder strBuff) {
        if (this.statsConfig.getStatsLevel() == StatsLevel.ZERO || !this.statsConfig.isEnableSelfPrint()) {
            return;
        }
        long lstPrintTime = this.lstSelfPrintTime.get();
        long curChkTime = Clock.systemDefaultZone().millis();
        if ((forcePrint || curChkTime - lstPrintTime > this.statsConfig.getSelfPrintPeriodMs()) && this.lstSelfPrintTime.compareAndSet(lstPrintTime, curChkTime)) {
            if (this.switchWritingStatsUnit(needReset)) {
                strBuff.append(this.logPrefix).append(", reset value= ");
                this.getStatsInfo(this.switchableSets[this.getIndex(this.writableIndex.get() - 1)], true, strBuff);
            } else {
                strBuff.append(this.logPrefix).append(", value= ");
                this.getStatsInfo(this.switchableSets[this.getIndex()], false, strBuff);
            }
            logger.info(strBuff.toString());
            strBuff.delete(0, strBuff.length());
        }
    }

    private boolean switchWritingStatsUnit(boolean needReset) {
        long lstResetTime = this.lstSnapshotTime.get();
        long checkDltTime = System.currentTimeMillis() - lstResetTime;
        if ((needReset && checkDltTime > 2000L || checkDltTime > this.statsConfig.getForcedResetPeriodMs()) && this.lstSnapshotTime.compareAndSet(lstResetTime, System.currentTimeMillis())) {
            this.switchableSets[this.getIndex(this.writableIndex.incrementAndGet())].resetStartTime();
            return true;
        }
        return false;
    }

    private void getStatsInfo(ClientStatsItemSet statsSet, boolean resetValue, StringBuilder strBuff) {
        strBuff.append("{\"").append(statsSet.resetTime.getFullName()).append("\":\"").append(statsSet.resetTime.getStrSinceTime()).append("\",\"probe_time\":\"").append(DateTimeConvertUtils.ms2yyyyMMddHHmmss(System.currentTimeMillis())).append("\",");
        statsSet.totalTrafficStats.getValue(strBuff, resetValue);
        strBuff.append(",");
        statsSet.getTopicDetailInfo(strBuff, resetValue);
        if (this.statsConfig.getStatsLevel() != StatsLevel.SIMPLEST) {
            strBuff.append(",");
            if (resetValue) {
                statsSet.msgCallDltStats.snapShort(strBuff, false);
                if (!this.isProducer) {
                    strBuff.append(",");
                    statsSet.csmLatencyStats.snapShort(strBuff, false);
                    strBuff.append(",");
                    statsSet.confirmDltStats.snapShort(strBuff, false);
                }
            } else {
                statsSet.msgCallDltStats.getValue(strBuff, false);
                if (!this.isProducer) {
                    strBuff.append(",");
                    statsSet.csmLatencyStats.getValue(strBuff, false);
                    strBuff.append(",");
                    statsSet.confirmDltStats.getValue(strBuff, false);
                }
            }
            strBuff.append(",");
            statsSet.getErrorRspInfo(strBuff, resetValue);
            strBuff.append(",");
            statsSet.getStatusInfo(strBuff, resetValue);
            if (this.statsConfig.getStatsLevel() == StatsLevel.FULL) {
                strBuff.append(",");
                statsSet.getPartDetailsInfo(strBuff, this.isProducer, resetValue);
            }
        }
        strBuff.append("}");
    }

    private int getIndex() {
        return this.getIndex(this.writableIndex.get());
    }

    private int getIndex(int origIndex) {
        return Math.abs(origIndex % 2);
    }

    private static class PartitionStatsItemSet {
        private final String partKey;
        protected final TrafficStatsUnit trafficStatsUnit = new TrafficStatsUnit("msg_cnt", "msg_size", "traffic");
        protected final ESTHistogram msgCallDltStats = new ESTHistogram("msg_call_dlt", "");
        protected final ESTHistogram csmLatencyStats = new ESTHistogram("csm_latency_dlt", "");
        protected final ESTHistogram confirmDltStats = new ESTHistogram("msg_confirm_dlt", "");

        public PartitionStatsItemSet(String partKey) {
            this.partKey = partKey;
        }

        public void getValue(StringBuilder strBuff, boolean isProducer, boolean resetValue) {
            strBuff.append("\"").append(this.partKey).append("\":{");
            this.trafficStatsUnit.getValue(strBuff, resetValue);
            strBuff.append(",");
            if (resetValue) {
                this.msgCallDltStats.snapShort(strBuff, false);
                if (!isProducer) {
                    strBuff.append(",");
                    this.csmLatencyStats.snapShort(strBuff, false);
                    strBuff.append(",");
                    this.confirmDltStats.snapShort(strBuff, false);
                }
            } else {
                this.msgCallDltStats.getValue(strBuff, false);
                if (!isProducer) {
                    strBuff.append(",");
                    this.csmLatencyStats.getValue(strBuff, false);
                    strBuff.append(",");
                    this.confirmDltStats.getValue(strBuff, false);
                }
            }
            strBuff.append("}");
        }
    }

    private static class ClientStatsItemSet {
        protected final SinceTime resetTime = new SinceTime("reset_time", null);
        protected final TrafficStatsUnit totalTrafficStats = new TrafficStatsUnit("msg_cnt", "msg_size", "total_traffic");
        protected final ConcurrentHashMap<String, TrafficStatsUnit> topicTrafficMap = new ConcurrentHashMap();
        protected final ConcurrentHashMap<String, PartitionStatsItemSet> partDltStatsMap = new ConcurrentHashMap();
        protected final ESTHistogram msgCallDltStats = new ESTHistogram("msg_call_dlt", "");
        protected final ESTHistogram csmLatencyStats = new ESTHistogram("csm_latency_dlt", "");
        protected final ESTHistogram confirmDltStats = new ESTHistogram("msg_confirm_dlt", "");
        protected final ConcurrentHashMap<Integer, LongStatsCounter> errRspStatsMap = new ConcurrentHashMap();
        protected final LongStatsCounter regMasterCnt = new LongStatsCounter("reg_master_cnt", null);
        protected final LongStatsCounter regMasterFailCnt = new LongStatsCounter("reg_master_fail", null);
        protected final LongStatsCounter regMasterTimoutCnt = new LongStatsCounter("reg_master_timeout", null);
        protected final LongStatsCounter hbMasterExcCnt = new LongStatsCounter("hb_master_exception", null);
        protected final LongStatsCounter regBrokerCnt = new LongStatsCounter("reg_broker_cnt", null);
        protected final LongStatsCounter regBrokerFailCnt = new LongStatsCounter("reg_broker_fail", null);
        protected final LongStatsCounter regBrokerTimoutCnt = new LongStatsCounter("reg_broker_timeout", null);
        protected final LongStatsCounter hbBrokerExcCnt = new LongStatsCounter("hb_broker_exception", null);

        public ClientStatsItemSet() {
            this.resetStartTime();
        }

        public void resetStartTime() {
            this.resetTime.reset();
        }

        public void sendOrRecvMsg(String topic, long dltTime, int msgCnt, int msgSize) {
            TrafficStatsUnit tmpUnit;
            this.msgCallDltStats.update(dltTime);
            this.totalTrafficStats.addMsgCntAndSize(msgCnt, msgSize);
            TrafficStatsUnit curStatsUnit = this.topicTrafficMap.get(topic);
            if (curStatsUnit == null && (curStatsUnit = this.topicTrafficMap.putIfAbsent(topic, tmpUnit = new TrafficStatsUnit("msg_cnt", "msg_size", topic))) == null) {
                curStatsUnit = tmpUnit;
            }
            curStatsUnit.addMsgCntAndSize(msgCnt, msgSize);
        }

        public void bookFailRpcCall(int errCode) {
            LongStatsCounter curItemCounter = this.errRspStatsMap.get(errCode);
            if (curItemCounter == null) {
                LongStatsCounter tmpCounter = new LongStatsCounter("err_" + errCode, "");
                curItemCounter = this.errRspStatsMap.putIfAbsent(errCode, tmpCounter);
                if (curItemCounter == null) {
                    curItemCounter = tmpCounter;
                }
            }
            curItemCounter.incValue();
        }

        public void addTrafficInfoByPartKey(String partitionKey, long dltTime, int msgCnt, int msgSize) {
            PartitionStatsItemSet tmpUnit;
            PartitionStatsItemSet partStatsUnit = this.partDltStatsMap.get(partitionKey);
            if (partStatsUnit == null && (partStatsUnit = this.partDltStatsMap.putIfAbsent(partitionKey, tmpUnit = new PartitionStatsItemSet(partitionKey))) == null) {
                partStatsUnit = tmpUnit;
            }
            partStatsUnit.trafficStatsUnit.addMsgCntAndSize(msgCnt, msgSize);
            partStatsUnit.msgCallDltStats.update(dltTime);
        }

        public void addCsmLatencyByPartKey(String partitionKey, long dltTime) {
            PartitionStatsItemSet tmpUnit;
            PartitionStatsItemSet partStatsUnit = this.partDltStatsMap.get(partitionKey);
            if (partStatsUnit == null && (partStatsUnit = this.partDltStatsMap.putIfAbsent(partitionKey, tmpUnit = new PartitionStatsItemSet(partitionKey))) == null) {
                partStatsUnit = tmpUnit;
            }
            partStatsUnit.csmLatencyStats.update(dltTime);
        }

        public void addConfirmDltByPartKey(String partitionKey, long dltTime) {
            PartitionStatsItemSet tmpUnit;
            PartitionStatsItemSet partStatsUnit = this.partDltStatsMap.get(partitionKey);
            if (partStatsUnit == null && (partStatsUnit = this.partDltStatsMap.putIfAbsent(partitionKey, tmpUnit = new PartitionStatsItemSet(partitionKey))) == null) {
                partStatsUnit = tmpUnit;
            }
            partStatsUnit.confirmDltStats.update(dltTime);
        }

        public void getTopicDetailInfo(StringBuilder strBuff, boolean resetValue) {
            int totalCnt = 0;
            strBuff.append("\"topic_details\":{");
            for (Map.Entry<String, TrafficStatsUnit> entry : this.topicTrafficMap.entrySet()) {
                if (entry == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                entry.getValue().getValue(strBuff, true);
            }
            strBuff.append("}");
            if (resetValue) {
                this.topicTrafficMap.clear();
            }
        }

        public void getErrorRspInfo(StringBuilder strBuff, boolean resetValue) {
            int totalCnt = 0;
            strBuff.append("\"rsp_details\":{");
            for (LongStatsCounter statsCounter : this.errRspStatsMap.values()) {
                if (statsCounter == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                strBuff.append("\"").append(statsCounter.getFullName()).append("\":").append(statsCounter.getValue());
            }
            strBuff.append("}");
            if (resetValue) {
                this.errRspStatsMap.clear();
            }
        }

        public void getStatusInfo(StringBuilder strBuff, boolean resetValue) {
            strBuff.append("\"status_details\":{\"");
            if (resetValue) {
                strBuff.append(this.regMasterCnt.getFullName()).append("\":").append(this.regMasterCnt.getAndResetValue()).append(",\"").append(this.regMasterFailCnt.getFullName()).append("\":").append(this.regMasterFailCnt.getAndResetValue()).append(",\"").append(this.regMasterTimoutCnt.getFullName()).append("\":").append(this.regMasterTimoutCnt.getAndResetValue()).append(",\"").append(this.hbMasterExcCnt.getFullName()).append("\":").append(this.hbMasterExcCnt.getAndResetValue()).append(",\"").append(this.regBrokerCnt.getFullName()).append("\":").append(this.regBrokerCnt.getAndResetValue()).append(",\"").append(this.regBrokerFailCnt.getFullName()).append("\":").append(this.regBrokerFailCnt.getAndResetValue()).append(",\"").append(this.regBrokerTimoutCnt.getFullName()).append("\":").append(this.regBrokerTimoutCnt.getAndResetValue()).append(",\"").append(this.hbBrokerExcCnt.getFullName()).append("\":").append(this.hbBrokerExcCnt.getAndResetValue()).append("}");
            } else {
                strBuff.append(this.regMasterCnt.getFullName()).append("\":").append(this.regMasterCnt.getValue()).append(",\"").append(this.regMasterFailCnt.getFullName()).append("\":").append(this.regMasterFailCnt.getValue()).append(",\"").append(this.regMasterTimoutCnt.getFullName()).append("\":").append(this.regMasterTimoutCnt.getValue()).append(",\"").append(this.hbMasterExcCnt.getFullName()).append("\":").append(this.hbMasterExcCnt.getValue()).append(",\"").append(this.regBrokerCnt.getFullName()).append("\":").append(this.regBrokerCnt.getValue()).append(",\"").append(this.regBrokerFailCnt.getFullName()).append("\":").append(this.regBrokerFailCnt.getValue()).append(",\"").append(this.regBrokerTimoutCnt.getFullName()).append("\":").append(this.regBrokerTimoutCnt.getValue()).append(",\"").append(this.hbBrokerExcCnt.getFullName()).append("\":").append(this.hbBrokerExcCnt.getValue()).append("}");
            }
        }

        public void getPartDetailsInfo(StringBuilder strBuff, boolean isProducer, boolean resetValue) {
            int totalCnt = 0;
            strBuff.append("\"part_details\":{");
            for (PartitionStatsItemSet partStatsSet : this.partDltStatsMap.values()) {
                if (partStatsSet == null) continue;
                if (totalCnt++ > 0) {
                    strBuff.append(",");
                }
                partStatsSet.getValue(strBuff, isProducer, false);
            }
            strBuff.append("}");
            if (resetValue) {
                this.partDltStatsMap.clear();
            }
        }
    }
}

