/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import com.ibm.icu.lang.UCharacter;
import java.io.PrintWriter;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.table.utils.TimestampStringUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.StringUtils;

@Internal
public class PrintUtils {
    public static final int MAX_COLUMN_WIDTH = 30;
    public static final String NULL_COLUMN = "(NULL)";
    public static final String ROW_KIND_COLUMN = "op";
    private static final String COLUMN_TRUNCATED_FLAG = "...";

    private PrintUtils() {
    }

    public static void printAsTableauForm(ResolvedSchema resolvedSchema, Iterator<Row> it, PrintWriter printWriter, ZoneId sessionTimeZone) {
        PrintUtils.printAsTableauForm(resolvedSchema, it, printWriter, 30, NULL_COLUMN, false, false, sessionTimeZone);
    }

    public static void printAsTableauForm(ResolvedSchema resolvedSchema, Iterator<Row> it, PrintWriter printWriter, int maxColumnWidth, String nullColumn, boolean deriveColumnWidthByType, boolean printRowKind, ZoneId sessionTimeZone) {
        int[] colWidths;
        if (!it.hasNext()) {
            printWriter.println("Empty set");
            printWriter.flush();
            return;
        }
        List<Column> columns = resolvedSchema.getColumns();
        String[] columnNames = (String[])columns.stream().map(Column::getName).toArray(String[]::new);
        if (printRowKind) {
            columnNames = (String[])Stream.concat(Stream.of(ROW_KIND_COLUMN), Arrays.stream(columnNames)).toArray(String[]::new);
        }
        if (deriveColumnWidthByType) {
            colWidths = PrintUtils.columnWidthsByType(columns, maxColumnWidth, nullColumn, printRowKind ? ROW_KIND_COLUMN : null);
        } else {
            ArrayList<Row> rows = new ArrayList<Row>();
            ArrayList<String[]> content = new ArrayList<String[]>();
            content.add(columnNames);
            while (it.hasNext()) {
                Row row = it.next();
                rows.add(row);
                content.add(PrintUtils.rowToString(row, nullColumn, printRowKind, resolvedSchema, sessionTimeZone));
            }
            colWidths = PrintUtils.columnWidthsByContent(columnNames, content, maxColumnWidth);
            it = rows.iterator();
        }
        String borderline = PrintUtils.genBorderLine(colWidths);
        printWriter.println(borderline);
        PrintUtils.printSingleRow(colWidths, columnNames, printWriter);
        printWriter.println(borderline);
        long numRows = 0L;
        while (it.hasNext()) {
            String[] cols = PrintUtils.rowToString((Row)it.next(), nullColumn, printRowKind, resolvedSchema, sessionTimeZone);
            PrintUtils.printSingleRow(colWidths, cols, printWriter);
            ++numRows;
        }
        printWriter.println(borderline);
        String rowTerm = numRows > 1L ? "rows" : "row";
        printWriter.println(numRows + " " + rowTerm + " in set");
        printWriter.flush();
    }

    public static String[] rowToString(Row row, ResolvedSchema resolvedSchema, ZoneId sessionTimeZone) {
        return PrintUtils.rowToString(row, NULL_COLUMN, false, resolvedSchema, sessionTimeZone);
    }

    public static String[] rowToString(Row row, String nullColumn, boolean printRowKind, ResolvedSchema resolvedSchema, ZoneId sessionTimeZone) {
        int len = printRowKind ? row.getArity() + 1 : row.getArity();
        ArrayList<String> fields = new ArrayList<String>(len);
        if (printRowKind) {
            fields.add(row.getKind().shortString());
        }
        for (int i = 0; i < row.getArity(); ++i) {
            Object field = row.getField(i);
            LogicalType fieldType = resolvedSchema.getColumnDataTypes().get(i).getLogicalType();
            if (field == null) {
                fields.add(nullColumn);
                continue;
            }
            fields.add(StringUtils.arrayAwareToString((Object)PrintUtils.formattedTimestamp(field, fieldType, sessionTimeZone)));
        }
        return fields.toArray(new String[0]);
    }

    private static Object formattedTimestamp(Object field, LogicalType fieldType, ZoneId sessionTimeZone) {
        LogicalTypeRoot typeRoot = fieldType.getTypeRoot();
        if (field == null) {
            return "null";
        }
        switch (typeRoot) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return PrintUtils.formatTimestampField(field, fieldType, sessionTimeZone);
            }
            case TIME_WITHOUT_TIME_ZONE: {
                return PrintUtils.formatTimeField(field);
            }
            case ARRAY: {
                LogicalType elementType = ((ArrayType)fieldType).getElementType();
                if (field instanceof List) {
                    List array = (List)field;
                    Object[] formattedArray = new Object[array.size()];
                    for (int i = 0; i < array.size(); ++i) {
                        formattedArray[i] = PrintUtils.formattedTimestamp(array.get(i), elementType, sessionTimeZone);
                    }
                    return formattedArray;
                }
                if (field.getClass().isArray()) {
                    if (field.getClass() == byte[].class) {
                        byte[] array = (byte[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == short[].class) {
                        short[] array = (short[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == int[].class) {
                        int[] array = (int[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == long[].class) {
                        long[] array = (long[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == float[].class) {
                        float[] array = (float[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(Float.valueOf(array[i]), elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == double[].class) {
                        double[] array = (double[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == boolean[].class) {
                        boolean[] array = (boolean[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    if (field.getClass() == char[].class) {
                        char[] array = (char[])field;
                        Object[] formattedArray = new Object[array.length];
                        for (int i = 0; i < array.length; ++i) {
                            formattedArray[i] = PrintUtils.formattedTimestamp(Character.valueOf(array[i]), elementType, sessionTimeZone);
                        }
                        return formattedArray;
                    }
                    Object[] array = (Object[])field;
                    Object[] formattedArray = new Object[array.length];
                    for (int i = 0; i < array.length; ++i) {
                        formattedArray[i] = PrintUtils.formattedTimestamp(array[i], elementType, sessionTimeZone);
                    }
                    return formattedArray;
                }
                return field;
            }
            case ROW: {
                if (fieldType instanceof RowType && field instanceof Row) {
                    Row row = (Row)field;
                    Row formattedRow = new Row(row.getKind(), row.getArity());
                    for (int i = 0; i < ((RowType)fieldType).getFields().size(); ++i) {
                        LogicalType type = ((RowType)fieldType).getFields().get(i).getType();
                        formattedRow.setField(i, PrintUtils.formattedTimestamp(row.getField(i), type, sessionTimeZone));
                    }
                    return formattedRow;
                }
                if (fieldType instanceof RowType && field instanceof RowData) {
                    RowData rowData = (RowData)field;
                    Row formattedRow = new Row(rowData.getRowKind(), rowData.getArity());
                    for (int i = 0; i < ((RowType)fieldType).getFields().size(); ++i) {
                        LogicalType type = ((RowType)fieldType).getFields().get(i).getType();
                        RowData.FieldGetter fieldGetter = RowData.createFieldGetter(type, i);
                        formattedRow.setField(i, PrintUtils.formattedTimestamp(fieldGetter.getFieldOrNull(rowData), type, sessionTimeZone));
                    }
                    return formattedRow;
                }
                return field;
            }
            case MAP: {
                LogicalType keyType = ((MapType)fieldType).getKeyType();
                LogicalType valueType = ((MapType)fieldType).getValueType();
                if (fieldType instanceof MapType && field instanceof Map) {
                    Map map = (Map)field;
                    HashMap<Object, Object> formattedMap = new HashMap<Object, Object>(map.size());
                    for (Object key : map.keySet()) {
                        formattedMap.put(PrintUtils.formattedTimestamp(key, keyType, sessionTimeZone), PrintUtils.formattedTimestamp(map.get(key), valueType, sessionTimeZone));
                    }
                    return formattedMap;
                }
                if (fieldType instanceof MapType && field instanceof MapData) {
                    MapData map = (MapData)field;
                    HashMap<Object, Object> formattedMap = new HashMap<Object, Object>(map.size());
                    Object[] keyArray = (Object[])PrintUtils.formattedTimestamp(map.keyArray(), keyType, sessionTimeZone);
                    Object[] valueArray = (Object[])PrintUtils.formattedTimestamp(map.valueArray(), valueType, sessionTimeZone);
                    for (int i = 0; i < keyArray.length; ++i) {
                        formattedMap.put(keyArray[i], valueArray[i]);
                    }
                    return formattedMap;
                }
                return field;
            }
        }
        return field;
    }

    private static Object formatTimestampField(Object timestampField, LogicalType fieldType, ZoneId sessionTimeZone) {
        switch (fieldType.getTypeRoot()) {
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                int precision = LogicalTypeChecks.getPrecision(fieldType);
                if (timestampField instanceof Timestamp) {
                    return TimestampStringUtils.timestampToString(((Timestamp)timestampField).toLocalDateTime(), precision);
                }
                if (timestampField instanceof LocalDateTime) {
                    return TimestampStringUtils.timestampToString((LocalDateTime)timestampField, precision);
                }
                if (timestampField instanceof TimestampData) {
                    return TimestampStringUtils.timestampToString(((TimestampData)timestampField).toLocalDateTime(), precision);
                }
                return timestampField;
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                Instant instant = null;
                if (timestampField instanceof Instant) {
                    instant = (Instant)timestampField;
                } else if (timestampField instanceof Timestamp) {
                    Timestamp timestamp = (Timestamp)timestampField;
                    instant = TimestampData.fromEpochMillis(timestamp.getTime(), timestamp.getNanos() % 1000000).toInstant();
                } else if (timestampField instanceof TimestampData) {
                    instant = ((TimestampData)timestampField).toInstant();
                } else if (timestampField instanceof Integer) {
                    instant = Instant.ofEpochSecond(((Integer)timestampField).intValue());
                } else if (timestampField instanceof Long) {
                    instant = Instant.ofEpochMilli((Long)timestampField);
                }
                if (instant != null) {
                    return TimestampStringUtils.timestampToString(instant.atZone(sessionTimeZone).toLocalDateTime(), LogicalTypeChecks.getPrecision(fieldType));
                }
                return timestampField;
            }
        }
        return timestampField;
    }

    private static Object formatTimeField(Object timeField) {
        if (timeField.getClass().isAssignableFrom(Integer.TYPE) || timeField instanceof Integer) {
            return TimestampStringUtils.unixTimeToString((Integer)timeField);
        }
        if (timeField.getClass().isAssignableFrom(Long.TYPE) || timeField instanceof Long) {
            return TimestampStringUtils.unixTimeToString(((Long)timeField).intValue());
        }
        if (timeField instanceof Time) {
            return TimestampStringUtils.unixTimeToString(TimestampStringUtils.timeToInternal((Time)timeField));
        }
        if (timeField instanceof LocalTime) {
            return TimestampStringUtils.unixTimeToString(TimestampStringUtils.localTimeToUnixDate((LocalTime)timeField));
        }
        return timeField;
    }

    public static String genBorderLine(int[] colWidths) {
        StringBuilder sb = new StringBuilder();
        sb.append("+");
        for (int width : colWidths) {
            sb.append(EncodingUtils.repeat('-', width + 1));
            sb.append("-+");
        }
        return sb.toString();
    }

    private static int[] columnWidthsByContent(String[] columnNames, List<String[]> rows, int maxColumnWidth) {
        int[] colWidths = Stream.of(columnNames).mapToInt(String::length).toArray();
        for (String[] row : rows) {
            for (int i = 0; i < row.length; ++i) {
                colWidths[i] = Math.max(colWidths[i], PrintUtils.getStringDisplayWidth(row[i]));
            }
        }
        for (int i = 0; i < colWidths.length; ++i) {
            colWidths[i] = Math.min(colWidths[i], maxColumnWidth);
        }
        return colWidths;
    }

    public static int[] columnWidthsByType(List<Column> columns, int maxColumnWidth, String nullColumn, @Nullable String rowKindColumn) {
        int[] colWidths = columns.stream().mapToInt(col -> col.getName().length()).toArray();
        for (int i = 0; i < columns.size(); ++i) {
            int len;
            LogicalType type = columns.get(i).getDataType().getLogicalType();
            switch (type.getTypeRoot()) {
                case TINYINT: {
                    len = 4;
                    break;
                }
                case SMALLINT: {
                    len = 6;
                    break;
                }
                case INTEGER: {
                    len = 11;
                    break;
                }
                case BIGINT: {
                    len = 20;
                    break;
                }
                case DECIMAL: {
                    len = ((DecimalType)type).getPrecision() + 2;
                    break;
                }
                case BOOLEAN: {
                    len = 5;
                    break;
                }
                case DATE: {
                    len = 10;
                    break;
                }
                case TIME_WITHOUT_TIME_ZONE: {
                    int precision = ((TimeType)type).getPrecision();
                    len = precision == 0 ? 8 : precision + 9;
                    break;
                }
                case TIMESTAMP_WITHOUT_TIME_ZONE: {
                    int precision = ((TimestampType)type).getPrecision();
                    len = PrintUtils.timestampTypeColumnWidth(precision);
                    break;
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    int precision = ((LocalZonedTimestampType)type).getPrecision();
                    len = PrintUtils.timestampTypeColumnWidth(precision);
                    break;
                }
                default: {
                    len = maxColumnWidth;
                }
            }
            colWidths[i] = Math.max(colWidths[i], Math.max(len, nullColumn.length()));
        }
        if (rowKindColumn != null) {
            int[] ret = new int[columns.size() + 1];
            ret[0] = rowKindColumn.length();
            System.arraycopy(colWidths, 0, ret, 1, columns.size());
            return ret;
        }
        return colWidths;
    }

    private static int timestampTypeColumnWidth(int precision) {
        int base = 19;
        if (precision == 0) {
            return base;
        }
        if (precision <= 3) {
            return base + 4;
        }
        if (precision <= 6) {
            return base + 7;
        }
        return base + 10;
    }

    public static void printSingleRow(int[] colWidths, String[] cols, PrintWriter printWriter) {
        StringBuilder sb = new StringBuilder();
        sb.append("|");
        int idx = 0;
        for (String col : cols) {
            sb.append(" ");
            int displayWidth = PrintUtils.getStringDisplayWidth(col);
            if (displayWidth <= colWidths[idx]) {
                sb.append(EncodingUtils.repeat(' ', colWidths[idx] - displayWidth));
                sb.append(col);
            } else {
                sb.append(PrintUtils.truncateString(col, colWidths[idx] - COLUMN_TRUNCATED_FLAG.length()));
                sb.append(COLUMN_TRUNCATED_FLAG);
            }
            sb.append(" |");
            ++idx;
        }
        printWriter.println(sb.toString());
        printWriter.flush();
    }

    private static String truncateString(String col, int targetWidth) {
        String substring;
        int lackedWidth;
        int i;
        int passedWidth = 0;
        for (i = 0; i < col.length(); ++i) {
            passedWidth = PrintUtils.isFullWidth(Character.codePointAt(col, i)) ? (passedWidth += 2) : ++passedWidth;
            if (passedWidth > targetWidth) break;
        }
        if ((lackedWidth = targetWidth - PrintUtils.getStringDisplayWidth(substring = col.substring(0, i))) > 0) {
            substring = EncodingUtils.repeat(' ', lackedWidth) + substring;
        }
        return substring;
    }

    public static int getStringDisplayWidth(String str) {
        int numOfFullWidthCh = (int)str.codePoints().filter(PrintUtils::isFullWidth).count();
        return str.length() + numOfFullWidthCh;
    }

    public static boolean isFullWidth(int codePoint) {
        int value = UCharacter.getIntPropertyValue((int)codePoint, (int)4100);
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return false;
            }
            case 3: 
            case 5: {
                return true;
            }
        }
        throw new RuntimeException("unknown UProperty.EAST_ASIAN_WIDTH: " + value);
    }
}

