/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.utils;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.core.fs.FileStatus;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;

@Internal
public class PartitionPathUtils {
    private static final Pattern PARTITION_NAME_PATTERN;
    private static final BitSet CHAR_TO_ESCAPE;

    private static boolean needsEscaping(char c) {
        return c < CHAR_TO_ESCAPE.size() && CHAR_TO_ESCAPE.get(c);
    }

    public static String generatePartitionPath(LinkedHashMap<String, String> partitionSpec) {
        if (partitionSpec.isEmpty()) {
            return "";
        }
        StringBuilder suffixBuf = new StringBuilder();
        int i = 0;
        for (Map.Entry<String, String> e : partitionSpec.entrySet()) {
            if (i > 0) {
                suffixBuf.append("/");
            }
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getKey()));
            suffixBuf.append('=');
            suffixBuf.append(PartitionPathUtils.escapePathName(e.getValue()));
            ++i;
        }
        suffixBuf.append("/");
        return suffixBuf.toString();
    }

    private static String escapePathName(String path) {
        if (path == null || path.length() == 0) {
            throw new TableException("Path should not be null or empty: " + path);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (PartitionPathUtils.needsEscaping(c)) {
                sb.append('%');
                sb.append(String.format("%1$02X", c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static List<String> extractPartitionValues(Path currPath) {
        return new ArrayList<String>(PartitionPathUtils.extractPartitionSpecFromPath(currPath).values());
    }

    public static LinkedHashMap<String, String> extractPartitionSpecFromPath(Path currPath) {
        LinkedHashMap<String, String> fullPartSpec = new LinkedHashMap<String, String>();
        ArrayList<String[]> kvs = new ArrayList<String[]>();
        do {
            String component;
            Matcher m3;
            if (!(m3 = PARTITION_NAME_PATTERN.matcher(component = currPath.getName())).matches()) continue;
            String k = PartitionPathUtils.unescapePathName(m3.group(1));
            String v = PartitionPathUtils.unescapePathName(m3.group(2));
            String[] kv = new String[]{k, v};
            kvs.add(kv);
        } while ((currPath = currPath.getParent()) != null && !currPath.getName().isEmpty());
        for (int i = kvs.size(); i > 0; --i) {
            fullPartSpec.put(((String[])kvs.get(i - 1))[0], ((String[])kvs.get(i - 1))[1]);
        }
        return fullPartSpec;
    }

    public static String unescapePathName(String path) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < path.length()) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static FileStatus[] listStatusWithoutHidden(FileSystem fs, Path dir) throws IOException {
        FileStatus[] statuses = fs.listStatus(dir);
        if (statuses == null) {
            return null;
        }
        return (FileStatus[])Arrays.stream(statuses).filter(fileStatus -> !PartitionPathUtils.isHiddenFile(fileStatus)).toArray(FileStatus[]::new);
    }

    public static List<Tuple2<LinkedHashMap<String, String>, Path>> searchPartSpecAndPaths(FileSystem fs, Path path, int partitionNumber) {
        FileStatus[] generatedParts = PartitionPathUtils.getFileStatusRecurse(path, partitionNumber, fs);
        ArrayList<Tuple2<LinkedHashMap<String, String>, Path>> ret = new ArrayList<Tuple2<LinkedHashMap<String, String>, Path>>();
        for (FileStatus part : generatedParts) {
            if (PartitionPathUtils.isHiddenFile(part)) continue;
            ret.add((Tuple2<LinkedHashMap<String, String>, Path>)new Tuple2(PartitionPathUtils.extractPartitionSpecFromPath(part.getPath()), (Object)part.getPath()));
        }
        return ret;
    }

    public static GenericRowData fillPartitionValueForRecord(String[] fieldNames, DataType[] fieldTypes, int[] selectFields, List<String> partitionKeys, Path path, String defaultPartValue) {
        GenericRowData record = new GenericRowData(selectFields.length);
        LinkedHashMap<String, String> partSpec = PartitionPathUtils.extractPartitionSpecFromPath(path);
        for (int i = 0; i < selectFields.length; ++i) {
            int selectField = selectFields[i];
            String name = fieldNames[selectField];
            if (!partitionKeys.contains(name)) continue;
            String value = partSpec.get(name);
            value = defaultPartValue.equals(value) ? null : value;
            record.setField(i, PartitionPathUtils.convertStringToInternalValue(value, fieldTypes[selectField]));
        }
        return record;
    }

    public static Object convertStringToInternalValue(String valStr, DataType type) {
        if (valStr == null) {
            return null;
        }
        LogicalTypeRoot typeRoot = type.getLogicalType().getTypeRoot();
        switch (typeRoot) {
            case CHAR: 
            case VARCHAR: {
                return StringData.fromString(valStr);
            }
            case BOOLEAN: {
                return Boolean.parseBoolean(valStr);
            }
            case TINYINT: {
                return Byte.parseByte(valStr);
            }
            case SMALLINT: {
                return Short.parseShort(valStr);
            }
            case INTEGER: {
                return Integer.parseInt(valStr);
            }
            case BIGINT: {
                return Long.parseLong(valStr);
            }
            case FLOAT: {
                return Float.valueOf(Float.parseFloat(valStr));
            }
            case DOUBLE: {
                return Double.parseDouble(valStr);
            }
            case DATE: {
                return (int)LocalDate.parse(valStr).toEpochDay();
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: {
                return TimestampData.fromLocalDateTime(LocalDateTime.parse(valStr));
            }
        }
        throw new RuntimeException(String.format("Can not convert %s to type %s for partition value", valStr, type));
    }

    private static FileStatus[] getFileStatusRecurse(Path path, int expectLevel, FileSystem fs) {
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        try {
            FileStatus fileStatus = fs.getFileStatus(path);
            PartitionPathUtils.listStatusRecursively(fs, fileStatus, 0, expectLevel, result);
        }
        catch (IOException ignore) {
            return new FileStatus[0];
        }
        return result.toArray(new FileStatus[0]);
    }

    private static void listStatusRecursively(FileSystem fs, FileStatus fileStatus, int level, int expectLevel, List<FileStatus> results) throws IOException {
        if (expectLevel == level) {
            results.add(fileStatus);
            return;
        }
        if (fileStatus.isDir()) {
            for (FileStatus stat : fs.listStatus(fileStatus.getPath())) {
                PartitionPathUtils.listStatusRecursively(fs, stat, level + 1, expectLevel, results);
            }
        }
    }

    private static boolean isHiddenFile(FileStatus fileStatus) {
        String name = fileStatus.getPath().getName();
        return name.startsWith("_") || name.startsWith(".");
    }

    static {
        char[] clist;
        PARTITION_NAME_PATTERN = Pattern.compile("([^/]+)=([^/]+)");
        CHAR_TO_ESCAPE = new BitSet(128);
        for (int c = 0; c < 32; c = (int)((char)(c + 1))) {
            CHAR_TO_ESCAPE.set(c);
        }
        for (char c : clist = new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', '\"', '#', '%', '\'', '*', '/', ':', '=', '?', '\\', '\u007f', '{', '[', ']', '^'}) {
            CHAR_TO_ESCAPE.set(c);
        }
    }
}

