/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.stats;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.BinaryOperator;
import org.apache.flink.annotation.PublicEvolving;

@PublicEvolving
public final class ColumnStats {
    private final Long ndv;
    private final Long nullCount;
    private final Double avgLen;
    private final Integer maxLen;
    @Deprecated
    private final Number maxValue;
    private final Comparable<?> max;
    @Deprecated
    private final Number minValue;
    private final Comparable<?> min;

    @Deprecated
    public ColumnStats(Long ndv, Long nullCount, Double avgLen, Integer maxLen, Number max, Number min2) {
        this.ndv = ndv;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
        this.maxValue = max;
        this.minValue = min2;
        this.max = null;
        this.min = null;
    }

    private ColumnStats(Long ndv, Long nullCount, Double avgLen, Integer maxLen, Comparable<?> max, Comparable<?> min2) {
        this.ndv = ndv;
        this.nullCount = nullCount;
        this.avgLen = avgLen;
        this.maxLen = maxLen;
        this.max = max;
        this.min = min2;
        this.maxValue = null;
        this.minValue = null;
    }

    public Long getNdv() {
        return this.ndv;
    }

    public Long getNullCount() {
        return this.nullCount;
    }

    public Double getAvgLen() {
        return this.avgLen;
    }

    public Integer getMaxLen() {
        return this.maxLen;
    }

    @Deprecated
    public Number getMaxValue() {
        return this.maxValue;
    }

    public Comparable<?> getMax() {
        return this.max;
    }

    @Deprecated
    public Number getMinValue() {
        return this.minValue;
    }

    public Comparable<?> getMin() {
        return this.min;
    }

    public String toString() {
        ArrayList<String> columnStats = new ArrayList<String>();
        if (this.ndv != null) {
            columnStats.add("ndv=" + this.ndv);
        }
        if (this.nullCount != null) {
            columnStats.add("nullCount=" + this.nullCount);
        }
        if (this.avgLen != null) {
            columnStats.add("avgLen=" + this.avgLen);
        }
        if (this.maxLen != null) {
            columnStats.add("maxLen=" + this.maxLen);
        }
        if (this.max != null) {
            columnStats.add("max=" + this.max);
        }
        if (this.maxValue != null) {
            columnStats.add("max=" + this.maxValue);
        }
        if (this.min != null) {
            columnStats.add("min=" + this.min);
        }
        if (this.minValue != null) {
            columnStats.add("min=" + this.minValue);
        }
        String columnStatsStr = String.join((CharSequence)", ", columnStats);
        return "ColumnStats(" + columnStatsStr + ")";
    }

    public ColumnStats copy() {
        if (this.maxValue != null || this.minValue != null) {
            return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.maxValue, this.minValue);
        }
        return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
    }

    public ColumnStats merge(ColumnStats other) {
        Long ndv = ColumnStats.combineIfNonNull(Long::sum, this.ndv, other.ndv);
        Long nullCount = ColumnStats.combineIfNonNull(Long::sum, this.nullCount, other.nullCount);
        Double avgLen = ColumnStats.combineIfNonNull((a1, a2) -> (a1 + a2) / 2.0, this.avgLen, other.avgLen);
        Integer maxLen = ColumnStats.combineIfNonNull(Math::max, this.maxLen, other.maxLen);
        Number maxValue = ColumnStats.combineIfNonNull((n1, n2) -> n1.doubleValue() > n2.doubleValue() ? (Number)((Number)n1) : (Number)((Number)n2), this.maxValue, other.maxValue);
        Number minValue = ColumnStats.combineIfNonNull((n1, n2) -> n1.doubleValue() < n2.doubleValue() ? (Number)((Number)n1) : (Number)((Number)n2), this.minValue, other.minValue);
        Comparable<?> max = ColumnStats.combineIfNonNull((c1, c2) -> c1.compareTo(c2) > 0 ? c1 : c2, this.max, other.max);
        Comparable<?> min2 = ColumnStats.combineIfNonNull((c1, c2) -> c1.compareTo(c2) < 0 ? c1 : c2, this.min, other.min);
        if (max != null || min2 != null) {
            return new ColumnStats(ndv, nullCount, avgLen, maxLen, max, min2);
        }
        return new ColumnStats(ndv, nullCount, avgLen, maxLen, maxValue, minValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnStats that = (ColumnStats)o;
        return Objects.equals(this.ndv, that.ndv) && Objects.equals(this.nullCount, that.nullCount) && Objects.equals(this.avgLen, that.avgLen) && Objects.equals(this.maxLen, that.maxLen) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.max, that.max) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.min, that.min);
    }

    public int hashCode() {
        return Objects.hash(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.maxValue, this.max, this.minValue, this.min);
    }

    private static <T> T combineIfNonNull(BinaryOperator<T> op, T t1, T t2) {
        if (t1 == null || t2 == null) {
            return null;
        }
        return (T)op.apply(t1, t2);
    }

    public static class Builder {
        private Long ndv = null;
        private Long nullCount = null;
        private Double avgLen = null;
        private Integer maxLen = null;
        private Comparable<?> max;
        private Comparable<?> min;

        public static Builder builder() {
            return new Builder();
        }

        public Builder setNdv(Long ndv) {
            this.ndv = ndv;
            return this;
        }

        public Builder setNullCount(Long nullCount) {
            this.nullCount = nullCount;
            return this;
        }

        public Builder setAvgLen(Double avgLen) {
            this.avgLen = avgLen;
            return this;
        }

        public Builder setMaxLen(Integer maxLen) {
            this.maxLen = maxLen;
            return this;
        }

        public Builder setMax(Comparable<?> max) {
            this.max = max;
            return this;
        }

        public Builder setMin(Comparable<?> min2) {
            this.min = min2;
            return this;
        }

        public ColumnStats build() {
            return new ColumnStats(this.ndv, this.nullCount, this.avgLen, this.maxLen, this.max, this.min);
        }
    }
}

